/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.bind.annotation.XmlInlineBinaryData;
import javax.xml.bind.annotation.XmlMixed;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.eclipse.persistence.config.DescriptorCustomizer;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.JAXBException;
import org.eclipse.persistence.internal.descriptors.InstantiationPolicy;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jaxb.DefaultElementConverter;
import org.eclipse.persistence.internal.jaxb.DomHandlerConverter;
import org.eclipse.persistence.internal.jaxb.JAXBElementConverter;
import org.eclipse.persistence.internal.jaxb.JAXBElementRootConverter;
import org.eclipse.persistence.internal.jaxb.JAXBSetMethodAttributeAccessor;
import org.eclipse.persistence.internal.jaxb.JaxbClassLoader;
import org.eclipse.persistence.internal.jaxb.MultiArgInstantiationPolicy;
import org.eclipse.persistence.internal.jaxb.WrappedValue;
import org.eclipse.persistence.internal.jaxb.XMLJavaTypeConverter;
import org.eclipse.persistence.internal.jaxb.many.JAXBObjectArrayAttributeAccessor;
import org.eclipse.persistence.internal.jaxb.many.JAXBPrimitiveArrayAttributeAccessor;
import org.eclipse.persistence.internal.jaxb.many.ManyValue;
import org.eclipse.persistence.internal.jaxb.many.MapValue;
import org.eclipse.persistence.internal.jaxb.many.MapValueAttributeAccessor;
import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.CodeVisitor;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.internal.libraries.asm.attrs.SignatureAttribute;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.JAXBEnumTypeConverter;
import org.eclipse.persistence.jaxb.TypeMappingInfo;
import org.eclipse.persistence.jaxb.compiler.ChoiceProperty;
import org.eclipse.persistence.jaxb.compiler.CompilerHelper;
import org.eclipse.persistence.jaxb.compiler.ElementDeclaration;
import org.eclipse.persistence.jaxb.compiler.EnumTypeInfo;
import org.eclipse.persistence.jaxb.compiler.NamespaceInfo;
import org.eclipse.persistence.jaxb.compiler.Property;
import org.eclipse.persistence.jaxb.compiler.ReferenceProperty;
import org.eclipse.persistence.jaxb.compiler.TypeInfo;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaField;
import org.eclipse.persistence.jaxb.javamodel.JavaMethod;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElementWrapper;
import org.eclipse.persistence.jaxb.xmlmodel.XmlJavaTypeAdapter;
import org.eclipse.persistence.jaxb.xmlmodel.XmlRootElement;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.FixedMimeTypePolicy;
import org.eclipse.persistence.oxm.mappings.MimeTypePolicy;
import org.eclipse.persistence.oxm.mappings.UnmarshalKeepAsElementPolicy;
import org.eclipse.persistence.oxm.mappings.XMLAnyAttributeMapping;
import org.eclipse.persistence.oxm.mappings.XMLAnyCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLAnyObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataMapping;
import org.eclipse.persistence.oxm.mappings.XMLChoiceCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLChoiceObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLCollectionReferenceMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.mappings.XMLInverseReferenceMapping;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.XMLObjectReferenceMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.oxm.mappings.converters.XMLListConverter;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.IsSetNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.NullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.XMLNullRepresentationType;
import org.eclipse.persistence.oxm.schema.XMLSchemaClassPathReference;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.sessions.Project;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingsGenerator {
    private static final String ATT = "@";
    private static final String TXT = "/text()";
    private static String WRAPPER_CLASS = "org.eclipse.persistence.jaxb.generated";
    private static String OBJECT_CLASS_NAME = "java.lang.Object";
    public static final QName RESERVED_QNAME = new QName("urn:ECLIPSELINK_RESERVEDURI", "RESERVEDNAME");
    private static int wrapperCounter = 0;
    String outputDir = ".";
    private HashMap userDefinedSchemaTypes;
    private org.eclipse.persistence.jaxb.javamodel.Helper helper;
    private JavaClass jotArrayList;
    private JavaClass jotHashSet;
    private HashMap<String, NamespaceInfo> packageToNamespaceMappings;
    private HashMap<String, TypeInfo> typeInfo;
    private HashMap<QName, Class> qNamesToGeneratedClasses;
    private HashMap<String, Class> classToGeneratedClasses;
    private HashMap<QName, Class> qNamesToDeclaredClasses;
    private HashMap<QName, ElementDeclaration> globalElements;
    private List<ElementDeclaration> localElements;
    private Map<TypeMappingInfo, Class> typeMappingInfoToGeneratedClasses;
    private Map<MapEntryGeneratedKey, Class> generatedMapEntryClasses;
    private Project project;
    private NamespaceResolver globalNamespaceResolver;
    private boolean isDefaultNamespaceAllowed;
    private Map<TypeMappingInfo, Class> typeMappingInfoToAdapterClasses;

    public MappingsGenerator(org.eclipse.persistence.jaxb.javamodel.Helper helper) {
        this.helper = helper;
        this.jotArrayList = helper.getJavaClass(ArrayList.class);
        this.jotHashSet = helper.getJavaClass(HashSet.class);
        this.qNamesToGeneratedClasses = new HashMap();
        this.qNamesToDeclaredClasses = new HashMap();
        this.classToGeneratedClasses = new HashMap();
        this.globalNamespaceResolver = new NamespaceResolver();
        this.isDefaultNamespaceAllowed = true;
    }

    public Project generateProject(ArrayList<JavaClass> typeInfoClasses, HashMap<String, TypeInfo> typeInfo, HashMap userDefinedSchemaTypes, HashMap<String, NamespaceInfo> packageToNamespaceMappings, HashMap<QName, ElementDeclaration> globalElements, List<ElementDeclaration> localElements, Map<TypeMappingInfo, Class> typeMappingInfoToGeneratedClass, Map<TypeMappingInfo, Class> typeMappingInfoToAdapterClasses, boolean isDefaultNamespaceAllowed) throws Exception {
        this.typeInfo = typeInfo;
        this.userDefinedSchemaTypes = userDefinedSchemaTypes;
        this.packageToNamespaceMappings = packageToNamespaceMappings;
        this.isDefaultNamespaceAllowed = isDefaultNamespaceAllowed;
        this.globalElements = globalElements;
        this.localElements = localElements;
        this.typeMappingInfoToGeneratedClasses = typeMappingInfoToGeneratedClass;
        this.typeMappingInfoToAdapterClasses = typeMappingInfoToAdapterClasses;
        this.project = new Project();
        for (JavaClass next : typeInfoClasses) {
            if (next.isEnum()) continue;
            this.generateDescriptor(next, this.project);
        }
        for (JavaClass next : typeInfoClasses) {
            if (next.isEnum()) continue;
            this.setupInheritance(next);
        }
        this.generateMappings();
        Set<Map.Entry<String, TypeInfo>> entrySet = this.typeInfo.entrySet();
        for (Map.Entry<String, TypeInfo> entry : entrySet) {
            TypeInfo tInfo = entry.getValue();
            if (tInfo.getXmlCustomizer() == null) continue;
            String customizerClassName = tInfo.getXmlCustomizer();
            try {
                Class customizerClass = PrivilegedAccessHelper.getClassForName((String)customizerClassName);
                DescriptorCustomizer descriptorCustomizer = (DescriptorCustomizer)PrivilegedAccessHelper.newInstanceFromClass((Class)customizerClass);
                descriptorCustomizer.customize((ClassDescriptor)tInfo.getDescriptor());
            }
            catch (IllegalAccessException iae) {
                throw JAXBException.couldNotCreateCustomizerInstance((Exception)iae, (String)customizerClassName);
            }
            catch (InstantiationException ie) {
                throw JAXBException.couldNotCreateCustomizerInstance((Exception)ie, (String)customizerClassName);
            }
            catch (ClassCastException cce) {
                throw JAXBException.invalidCustomizerClass((Exception)cce, (String)customizerClassName);
            }
            catch (ClassNotFoundException cnfe) {
                throw JAXBException.couldNotCreateCustomizerInstance((Exception)cnfe, (String)customizerClassName);
            }
        }
        this.processGlobalElements(this.project);
        wrapperCounter = 0;
        return this.project;
    }

    public void generateDescriptor(JavaClass javaClass, Project project) {
        JavaClass manyValueJavaClass;
        String namespace;
        String elementName;
        String jClassName = javaClass.getQualifiedName();
        TypeInfo info = this.typeInfo.get(jClassName);
        if (info.isTransient()) {
            return;
        }
        NamespaceInfo namespaceInfo = this.packageToNamespaceMappings.get(javaClass.getPackageName());
        String packageNamespace = namespaceInfo.getNamespace();
        if (javaClass.getSuperclass() != null && javaClass.getSuperclass().getName().equals("javax.xml.bind.JAXBElement")) {
            this.generateDescriptorForJAXBElementSubclass(javaClass, project, namespaceInfo.getNamespaceResolverForDescriptor());
            return;
        }
        XMLDescriptor descriptor = new XMLDescriptor();
        XmlRootElement rootElem = info.getXmlRootElement();
        if (rootElem == null) {
            elementName = Introspector.decapitalize(javaClass.getRawName().substring(jClassName.lastIndexOf(".") + 1));
            namespace = packageNamespace;
            descriptor.setResultAlwaysXMLRoot(true);
        } else {
            elementName = rootElem.getName();
            if (elementName.equals("##default")) {
                elementName = Introspector.decapitalize(javaClass.getRawName().substring(jClassName.lastIndexOf(".") + 1));
            }
            namespace = rootElem.getNamespace();
            descriptor.setResultAlwaysXMLRoot(false);
        }
        descriptor.setJavaClassName(jClassName);
        if (info.getFactoryMethodName() != null) {
            descriptor.getInstantiationPolicy().useFactoryInstantiationPolicy(info.getObjectFactoryClassName(), info.getFactoryMethodName());
        }
        if (namespace.equals("##default")) {
            namespace = namespaceInfo.getNamespace();
        }
        if (!(manyValueJavaClass = this.helper.getJavaClass(ManyValue.class)).isAssignableFrom(javaClass)) {
            if (rootElem == null) {
                descriptor.setDefaultRootElement("");
            } else if (namespace.length() == 0) {
                descriptor.setDefaultRootElement(elementName);
            } else {
                if (this.isDefaultNamespaceAllowed && this.globalNamespaceResolver.getDefaultNamespaceURI() == null) {
                    this.globalNamespaceResolver.setDefaultNamespaceURI(namespace);
                    namespaceInfo.getNamespaceResolverForDescriptor().setDefaultNamespaceURI(namespace);
                }
                descriptor.setDefaultRootElement(this.getQualifiedString(this.getPrefixForNamespace(namespace, namespaceInfo.getNamespaceResolverForDescriptor(), null), elementName));
            }
        }
        descriptor.setNamespaceResolver(namespaceInfo.getNamespaceResolverForDescriptor());
        this.setPKField(descriptor, info);
        this.setSchemaContext(descriptor, info);
        project.addDescriptor((ClassDescriptor)descriptor);
        info.setDescriptor(descriptor);
    }

    public void generateDescriptorForJAXBElementSubclass(JavaClass javaClass, Project project, NamespaceResolver nsr) {
        String jClassName = javaClass.getQualifiedName();
        TypeInfo info = this.typeInfo.get(jClassName);
        XMLDescriptor xmlDescriptor = new XMLDescriptor();
        xmlDescriptor.setJavaClassName(jClassName);
        String[] factoryMethodParamTypes = info.getFactoryMethodParamTypes();
        MultiArgInstantiationPolicy policy = new MultiArgInstantiationPolicy();
        policy.useFactoryInstantiationPolicy(info.getObjectFactoryClassName(), info.getFactoryMethodName());
        policy.setParameterTypeNames(factoryMethodParamTypes);
        policy.setDefaultValues(new String[]{null});
        xmlDescriptor.setInstantiationPolicy((InstantiationPolicy)policy);
        JavaClass paramClass = this.helper.getJavaClass(factoryMethodParamTypes[0]);
        if (this.helper.isBuiltInJavaType(paramClass)) {
            XMLDirectMapping mapping = new XMLDirectMapping();
            mapping.setAttributeName("value");
            mapping.setGetMethodName("getValue");
            mapping.setSetMethodName("setValue");
            mapping.setXPath("text()");
            Class attributeClassification = Helper.getClassFromClasseName((String)factoryMethodParamTypes[0], (ClassLoader)this.getClass().getClassLoader());
            mapping.setAttributeClassification(attributeClassification);
            xmlDescriptor.addMapping((DatabaseMapping)mapping);
        } else {
            XMLCompositeObjectMapping mapping = new XMLCompositeObjectMapping();
            mapping.setAttributeName("value");
            mapping.setGetMethodName("getValue");
            mapping.setSetMethodName("setValue");
            mapping.setXPath(".");
            mapping.setReferenceClassName(factoryMethodParamTypes[0]);
            xmlDescriptor.addMapping((DatabaseMapping)mapping);
        }
        xmlDescriptor.setNamespaceResolver(nsr);
        this.setPKField(xmlDescriptor, info);
        this.setSchemaContext(xmlDescriptor, info);
        project.addDescriptor((ClassDescriptor)xmlDescriptor);
        info.setDescriptor(xmlDescriptor);
    }

    private void setSchemaContext(XMLDescriptor desc, TypeInfo info) {
        XMLSchemaClassPathReference schemaRef = new XMLSchemaClassPathReference();
        if (info.getClassNamespace() == null || info.getClassNamespace().equals("")) {
            schemaRef.setSchemaContext("/" + info.getSchemaTypeName());
        } else {
            String prefix = desc.getNonNullNamespaceResolver().resolveNamespaceURI(info.getClassNamespace());
            if (prefix != null && !prefix.equals("")) {
                schemaRef.setSchemaContext("/" + prefix + ":" + info.getSchemaTypeName());
            } else {
                String generatedPrefix = this.getPrefixForNamespace(info.getClassNamespace(), desc.getNonNullNamespaceResolver(), null);
                schemaRef.setSchemaContext("/" + this.getQualifiedString(generatedPrefix, info.getSchemaTypeName()));
            }
            schemaRef.setSchemaContextAsQName(new QName(info.getClassNamespace(), info.getSchemaTypeName()));
        }
        if (info.isEnumerationType() || info.getPropertyNames().size() == 1 && this.helper.isAnnotationPresent(info.getProperties().get(info.getPropertyNames().get(0)).getElement(), XmlValue.class)) {
            schemaRef.setType(2);
        }
        desc.setSchemaReference((XMLSchemaReference)schemaRef);
    }

    private void setPKField(XMLDescriptor desc, TypeInfo info) {
        if (info.isIDSet()) {
            String uri = info.getIDProperty().getSchemaName().getNamespaceURI();
            String local = info.getIDProperty().getSchemaName().getLocalPart();
            String prefix = null;
            if (uri != null && uri.length() != 0 && (prefix = desc.getNamespaceResolver().resolveNamespaceURI(uri)) == null) {
                prefix = this.getPrefixForNamespace(uri, desc.getNamespaceResolver(), null, true);
            }
            prefix = prefix == null ? "" : prefix + ":";
            String pkFieldName = info.getIDProperty().isAttribute() ? ATT + prefix + local : prefix + local + TXT;
            desc.addPrimaryKeyFieldName(pkFieldName);
        }
    }

    public void generateMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        if (property.isSetXmlJavaTypeAdapter()) {
            XmlJavaTypeAdapter xja = property.getXmlJavaTypeAdapter();
            JavaClass adapterClass = this.helper.getJavaClass(xja.getValue());
            JavaClass valueType = property.getActualType();
            if (this.typeInfo.containsKey(valueType.getQualifiedName())) {
                if (this.isCollectionType(property)) {
                    this.generateCompositeCollectionMapping(property, descriptor, namespaceInfo, valueType.getQualifiedName()).setConverter((Converter)new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
                } else {
                    this.generateCompositeObjectMapping(property, descriptor, namespaceInfo, valueType.getQualifiedName()).setConverter((Converter)new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
                }
            } else if (this.isCollectionType(property)) {
                if (this.areEquals(valueType, ClassConstants.ABYTE) || this.areEquals(valueType, ClassConstants.APBYTE) || this.areEquals(valueType, "javax.activation.DataHandler") || this.areEquals(valueType, "java.awt.Image") || this.areEquals(valueType, "java.xml.transform.Source") || this.areEquals(valueType, "javax.mail.internet.MimeMultipart")) {
                    this.generateBinaryDataCollectionMapping(property, descriptor, namespaceInfo).setValueConverter((Converter)new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
                } else {
                    this.generateDirectCollectionMapping(property, descriptor, namespaceInfo).setValueConverter((Converter)new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
                }
            } else if (property.isSwaAttachmentRef() || property.isMtomAttachment()) {
                this.generateBinaryMapping(property, descriptor, namespaceInfo).setConverter((Converter)new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
            } else {
                this.generateDirectMapping(property, descriptor, namespaceInfo).setConverter((Converter)new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
            }
            return;
        }
        if (property.isChoice()) {
            if (this.isCollectionType(property)) {
                this.generateChoiceCollectionMapping(property, descriptor, namespaceInfo);
            } else {
                this.generateChoiceMapping(property, descriptor, namespaceInfo);
            }
        } else if (property.isInverseReference()) {
            this.generateInverseReferenceMapping(property, descriptor, namespaceInfo);
        } else if (property.isAny()) {
            if (this.isCollectionType(property)) {
                this.generateAnyCollectionMapping(property, descriptor, namespaceInfo, property.isMixedContent());
            } else {
                this.generateAnyObjectMapping(property, descriptor, namespaceInfo);
            }
        } else if (property.isReference()) {
            this.generateMappingForReferenceProperty((ReferenceProperty)property, descriptor, namespaceInfo);
        } else if (property.isMap()) {
            if (property.isAnyAttribute()) {
                this.generateAnyAttributeMapping(property, descriptor, namespaceInfo);
            } else {
                this.generateMapMapping(property, descriptor, namespaceInfo);
            }
        } else if (this.isCollectionType(property)) {
            this.generateCollectionMapping(property, descriptor, namespaceInfo);
        } else {
            JavaClass referenceClass = property.getType();
            String referenceClassName = referenceClass.getRawName();
            if (referenceClass.isArray() && !referenceClassName.equals("byte[]") && !referenceClassName.equals("java.lang.Byte[]")) {
                JavaClass componentType = referenceClass.getComponentType();
                TypeInfo reference = this.typeInfo.get(componentType.getQualifiedName());
                if (reference != null) {
                    this.generateCompositeCollectionMapping(property, descriptor, namespaceInfo, componentType.getQualifiedName());
                } else {
                    this.generateDirectCollectionMapping(property, descriptor, namespaceInfo);
                }
            } else {
                TypeInfo reference = this.typeInfo.get(referenceClass.getQualifiedName());
                if (reference != null) {
                    if (property.isXmlIdRef()) {
                        this.generateXMLObjectReferenceMapping(property, descriptor, namespaceInfo, referenceClass);
                    } else if (reference.isEnumerationType()) {
                        this.generateDirectEnumerationMapping(property, descriptor, namespaceInfo, (EnumTypeInfo)reference);
                    } else {
                        this.generateCompositeObjectMapping(property, descriptor, namespaceInfo, referenceClass.getQualifiedName());
                    }
                } else if (property.isSwaAttachmentRef() || property.isMtomAttachment()) {
                    this.generateBinaryMapping(property, descriptor, namespaceInfo);
                } else if (referenceClass.getQualifiedName().equals(OBJECT_CLASS_NAME)) {
                    XMLCompositeObjectMapping coMapping = this.generateCompositeObjectMapping(property, descriptor, namespaceInfo, null);
                    coMapping.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
                } else {
                    this.generateDirectMapping(property, descriptor, namespaceInfo);
                }
            }
        }
    }

    private XMLInverseReferenceMapping generateInverseReferenceMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespace) {
        XMLInverseReferenceMapping invMapping = new XMLInverseReferenceMapping();
        if (this.isCollectionType(property.getType())) {
            invMapping.setReferenceClassName(property.getGenericType().getQualifiedName());
        } else {
            invMapping.setReferenceClassName(property.getType().getQualifiedName());
        }
        invMapping.setAttributeName(property.getPropertyName());
        String setMethodName = property.getInverseReferencePropertySetMethodName();
        String getMethodName = property.getInverseReferencePropertyGetMethodName();
        if (setMethodName != null && !setMethodName.equals("")) {
            invMapping.setSetMethodName(setMethodName);
        }
        if (getMethodName != null && !getMethodName.equals("")) {
            invMapping.setGetMethodName(getMethodName);
        }
        invMapping.setMappedBy(property.getInverseReferencePropertyName());
        if (this.isCollectionType(property.getType())) {
            invMapping.setContainerPolicy(ContainerPolicy.buildDefaultPolicy());
        }
        descriptor.addMapping((DatabaseMapping)invMapping);
        return invMapping;
    }

    public XMLChoiceObjectMapping generateChoiceMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespace) {
        ChoiceProperty prop = (ChoiceProperty)property;
        XMLChoiceObjectMapping mapping = new XMLChoiceObjectMapping();
        mapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor((AttributeAccessor)new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        Iterator<Property> choiceProperties = prop.getChoiceProperties().iterator();
        while (choiceProperties.hasNext()) {
            Property next;
            JavaClass type = (next = choiceProperties.next()).getType();
            XMLField xpath = this.getXPathForField(next, namespace, !this.typeInfo.containsKey(type.getQualifiedName()));
            mapping.addChoiceElement(xpath.getName(), type.getQualifiedName(), false);
        }
        descriptor.addMapping((DatabaseMapping)mapping);
        return mapping;
    }

    public XMLChoiceCollectionMapping generateChoiceCollectionMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespace) {
        JavaClass collectionType;
        ChoiceProperty prop = (ChoiceProperty)property;
        XMLChoiceCollectionMapping mapping = new XMLChoiceCollectionMapping();
        mapping.setReuseContainer(true);
        mapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor((AttributeAccessor)new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        if (this.areEquals(collectionType = property.getType(), Collection.class) || this.areEquals(collectionType, List.class)) {
            collectionType = this.jotArrayList;
        } else if (this.areEquals(collectionType, Set.class)) {
            collectionType = this.jotHashSet;
        }
        mapping.useCollectionClassName(collectionType.getRawName());
        Iterator<Property> choiceProperties = prop.getChoiceProperties().iterator();
        while (choiceProperties.hasNext()) {
            Property next;
            JavaClass type = (next = choiceProperties.next()).getType();
            XMLField xpath = this.getXPathForField(next, namespace, !this.typeInfo.containsKey(type.getQualifiedName()));
            mapping.addChoiceElement(xpath.getName(), type.getQualifiedName());
        }
        descriptor.addMapping((DatabaseMapping)mapping);
        return mapping;
    }

    public XMLMapping generateMappingForReferenceProperty(ReferenceProperty property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        XMLChoiceCollectionMapping mapping;
        boolean isCollection;
        if (property.isMixedContent()) {
            XMLAnyCollectionMapping mapping2 = this.generateAnyCollectionMapping(property, descriptor, namespaceInfo, true);
            return mapping2;
        }
        boolean bl = isCollection = this.isCollectionType(property) || property.getType().isArray();
        if (isCollection) {
            mapping = new XMLChoiceCollectionMapping();
            mapping.setReuseContainer(true);
            mapping.setConverter((Converter)new JAXBElementRootConverter(Object.class));
        } else {
            mapping = new XMLChoiceObjectMapping();
            ((XMLChoiceObjectMapping)mapping).setConverter((Converter)new JAXBElementRootConverter(Object.class));
        }
        mapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor((AttributeAccessor)new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                ((XMLMapping)mapping).setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        List<ElementDeclaration> referencedElements = property.getReferencedElements();
        if (property.getType().isArray()) {
            JAXBObjectArrayAttributeAccessor accessor = new JAXBObjectArrayAttributeAccessor(mapping.getAttributeAccessor(), mapping.getContainerPolicy());
            accessor.setComponentClassName(property.getType().getComponentType().getRawName());
            mapping.setAttributeAccessor((AttributeAccessor)accessor);
        }
        for (ElementDeclaration element : referencedElements) {
            Converter originalConverter;
            DatabaseMapping nestedMapping;
            QName elementName = element.getElementName();
            boolean isText = !this.typeInfo.containsKey(element.getJavaTypeName()) && !element.getJavaTypeName().equals(OBJECT_CLASS_NAME);
            XMLField xmlField = this.getXPathForElement("", elementName, namespaceInfo, isText);
            if (this.helper.getXMLToJavaTypeMap().get(element.getJavaType().getRawName()) == XMLConstants.BASE_64_BINARY_QNAME) {
                xmlField.setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
            }
            if (isCollection) {
                XMLChoiceCollectionMapping xmlChoiceCollectionMapping = mapping;
                xmlChoiceCollectionMapping.addChoiceElement(xmlField, element.getJavaTypeName());
                nestedMapping = (DatabaseMapping)xmlChoiceCollectionMapping.getChoiceElementMappings().get(xmlField);
                if (nestedMapping.isAbstractCompositeCollectionMapping()) {
                    ((XMLCompositeCollectionMapping)nestedMapping).setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
                }
                if (nestedMapping.isAbstractCompositeDirectCollectionMapping()) {
                    ((XMLCompositeDirectCollectionMapping)nestedMapping).getNullPolicy().setNullRepresentedByEmptyNode(false);
                }
                if (element.isList() && nestedMapping.isAbstractCompositeDirectCollectionMapping()) {
                    XMLListConverter listConverter = new XMLListConverter();
                    listConverter.setObjectClassName(element.getJavaType().getQualifiedName());
                    ((XMLCompositeDirectCollectionMapping)nestedMapping).setValueConverter((Converter)listConverter);
                }
            } else {
                XMLChoiceObjectMapping xmlChoiceObjectMapping = (XMLChoiceObjectMapping)mapping;
                xmlChoiceObjectMapping.addChoiceElement(xmlField, element.getJavaTypeName());
                nestedMapping = (DatabaseMapping)xmlChoiceObjectMapping.getChoiceElementMappings().get(xmlField);
                if (nestedMapping.isAbstractCompositeObjectMapping()) {
                    ((XMLCompositeObjectMapping)nestedMapping).setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
                }
            }
            if (element.isXmlRootElement()) continue;
            Class<JAXBElement.GlobalScope> scopeClass = element.getScopeClass();
            if (scopeClass == XmlElementDecl.GLOBAL.class) {
                scopeClass = JAXBElement.GlobalScope.class;
            }
            Class declaredType = this.helper.getClassForJavaClass(element.getJavaType());
            JAXBElementConverter converter = new JAXBElementConverter(xmlField, declaredType, scopeClass);
            if (isCollection) {
                XMLChoiceCollectionMapping xmlChoiceCollectionMapping = mapping;
                originalConverter = xmlChoiceCollectionMapping.getConverter(xmlField);
                converter.setNestedConverter(originalConverter);
                xmlChoiceCollectionMapping.addConverter(xmlField, (Converter)converter);
                continue;
            }
            XMLChoiceObjectMapping xmlChoiceObjectMapping = (XMLChoiceObjectMapping)mapping;
            originalConverter = xmlChoiceObjectMapping.getConverter(xmlField);
            converter.setNestedConverter(originalConverter);
            xmlChoiceObjectMapping.addConverter(xmlField, (Converter)converter);
        }
        descriptor.addMapping((DatabaseMapping)mapping);
        return (XMLMapping)mapping;
    }

    public XMLAnyCollectionMapping generateAnyCollectionMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo, boolean isMixed) {
        boolean isLax = false;
        String domHandlerClassName = null;
        if (property.isAny()) {
            isLax = property.isLax();
            domHandlerClassName = property.getDomHandlerClassName();
        }
        XMLAnyCollectionMapping mapping = new XMLAnyCollectionMapping();
        mapping.setAttributeName(property.getPropertyName());
        mapping.setReuseContainer(true);
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor((AttributeAccessor)new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        if (!isMixed) {
            mapping.setUseXMLRoot(true);
        }
        Class declaredType = this.helper.getClassForJavaClass(property.getActualType());
        JAXBElementRootConverter jaxbElementRootConverter = new JAXBElementRootConverter(declaredType);
        mapping.setConverter((XMLConverter)jaxbElementRootConverter);
        if (isLax) {
            mapping.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
        } else {
            mapping.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT);
        }
        if (domHandlerClassName != null) {
            jaxbElementRootConverter.setNestedConverter(new DomHandlerConverter(domHandlerClassName));
        }
        descriptor.addMapping((DatabaseMapping)mapping);
        mapping.setMixedContent(isMixed);
        if (isMixed) {
            mapping.setPreserveWhitespaceForMixedContent(true);
        }
        return mapping;
    }

    public XMLCompositeObjectMapping generateCompositeObjectMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo, String referenceClassName) {
        XMLCompositeObjectMapping mapping = new XMLCompositeObjectMapping();
        mapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor((AttributeAccessor)new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        if (property.isNillable()) {
            mapping.getNullPolicy().setNullRepresentedByXsiNil(true);
        }
        mapping.setXPath(this.getXPathForField(property, namespaceInfo, false).getXPath());
        if (referenceClassName == null) {
            ((XMLField)mapping.getField()).setIsTypedTextField(true);
            ((XMLField)mapping.getField()).setSchemaType(XMLConstants.ANY_TYPE_QNAME);
            String defaultValue = property.getDefaultValue();
            if (null != defaultValue) {
                mapping.setConverter((Converter)new DefaultElementConverter(defaultValue));
            }
        } else {
            mapping.setReferenceClassName(referenceClassName);
        }
        if (property.getInverseReferencePropertyName() != null) {
            mapping.setContainerAttributeName(property.getInverseReferencePropertyName());
            JavaClass backPointerPropertyType = null;
            JavaClass referenceClass = property.getActualType();
            if (property.getInverseReferencePropertyGetMethodName() != null && property.getInverseReferencePropertySetMethodName() != null && !property.getInverseReferencePropertyGetMethodName().equals("") && !property.getInverseReferencePropertySetMethodName().equals("")) {
                mapping.setContainerGetMethodName(property.getInverseReferencePropertySetMethodName());
                mapping.setContainerSetMethodName(property.getInverseReferencePropertySetMethodName());
                JavaMethod getMethod = referenceClass.getDeclaredMethod(mapping.getContainerGetMethodName(), new JavaClass[0]);
                if (getMethod != null) {
                    backPointerPropertyType = getMethod.getReturnType();
                }
            } else {
                JavaField backpointerField = referenceClass.getDeclaredField(property.getInverseReferencePropertyName());
                if (backpointerField != null) {
                    backPointerPropertyType = backpointerField.getResolvedType();
                }
            }
            if (this.isCollectionType(backPointerPropertyType)) {
                mapping.getInverseReferenceMapping().setContainerPolicy(ContainerPolicy.buildDefaultPolicy());
            }
        }
        if (property.isRequired()) {
            ((XMLField)mapping.getField()).setRequired(true);
        }
        descriptor.addMapping((DatabaseMapping)mapping);
        return mapping;
    }

    public XMLDirectMapping generateDirectMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        XMLDirectMapping mapping = new XMLDirectMapping();
        mapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor((AttributeAccessor)new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        if (property.isNillable()) {
            mapping.getNullPolicy().setNullRepresentedByXsiNil(true);
        }
        mapping.setField((DatabaseField)this.getXPathForField(property, namespaceInfo, true));
        mapping.getNullPolicy().setNullRepresentedByEmptyNode(false);
        if (property.getType().getRawName().equals("java.lang.String")) {
            mapping.setNullValue((Object)"");
        }
        if (!mapping.getXPath().equals("text()")) {
            ((NullPolicy)mapping.getNullPolicy()).setSetPerformedForAbsentNode(false);
        }
        if (property.isRequired()) {
            ((XMLField)mapping.getField()).setRequired(true);
        }
        if (property.isXmlElementType()) {
            Class theClass = this.helper.getClassForJavaClass(property.getType());
            mapping.setAttributeClassification(theClass);
        }
        if (XMLConstants.QNAME_QNAME.equals(property.getSchemaType())) {
            ((XMLField)mapping.getField()).setSchemaType(XMLConstants.QNAME_QNAME);
        }
        if (property.getDefaultValue() != null) {
            mapping.setNullValue((Object)property.getDefaultValue());
        }
        descriptor.addMapping((DatabaseMapping)mapping);
        return mapping;
    }

    public XMLBinaryDataMapping generateBinaryMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        XMLBinaryDataMapping mapping = new XMLBinaryDataMapping();
        mapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor((AttributeAccessor)new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        mapping.setField((DatabaseField)this.getXPathForField(property, namespaceInfo, false));
        if (property.isSwaAttachmentRef()) {
            ((XMLField)mapping.getField()).setSchemaType(XMLConstants.SWA_REF_QNAME);
            mapping.setSwaRef(true);
        } else if (property.isMtomAttachment()) {
            ((XMLField)mapping.getField()).setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlInlineBinaryData.class)) {
            mapping.setShouldInlineBinaryData(true);
        }
        if (property.getMimeType() != null) {
            mapping.setMimeTypePolicy((MimeTypePolicy)new FixedMimeTypePolicy(property.getMimeType()));
        } else if (this.areEquals(property.getType(), Source.class)) {
            mapping.setMimeTypePolicy((MimeTypePolicy)new FixedMimeTypePolicy("application/xml"));
        } else {
            mapping.setMimeTypePolicy((MimeTypePolicy)new FixedMimeTypePolicy("application/octet-stream"));
        }
        descriptor.addMapping((DatabaseMapping)mapping);
        return mapping;
    }

    public XMLBinaryDataCollectionMapping generateBinaryDataCollectionMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        XMLBinaryDataCollectionMapping mapping = new XMLBinaryDataCollectionMapping();
        mapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor((AttributeAccessor)new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        mapping.setField((DatabaseField)this.getXPathForField(property, namespaceInfo, false));
        if (property.isSwaAttachmentRef()) {
            ((XMLField)mapping.getField()).setSchemaType(XMLConstants.SWA_REF_QNAME);
            mapping.setSwaRef(true);
        } else if (property.isMtomAttachment()) {
            ((XMLField)mapping.getField()).setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlInlineBinaryData.class)) {
            mapping.setShouldInlineBinaryData(true);
        }
        if (property.getMimeType() != null) {
            mapping.setMimeTypePolicy((MimeTypePolicy)new FixedMimeTypePolicy(property.getMimeType()));
        } else if (this.areEquals(property.getType(), Source.class)) {
            mapping.setMimeTypePolicy((MimeTypePolicy)new FixedMimeTypePolicy("application/xml"));
        } else {
            mapping.setMimeTypePolicy((MimeTypePolicy)new FixedMimeTypePolicy("application/octet-stream"));
        }
        JavaClass collectionType = property.getType();
        if (collectionType != null && this.isCollectionType(collectionType)) {
            if (collectionType.hasActualTypeArguments()) {
                JavaClass itemType = (JavaClass)collectionType.getActualTypeArguments().toArray()[0];
                try {
                    Class declaredClass = PrivilegedAccessHelper.getClassForName((String)itemType.getQualifiedName(), (boolean)false, (ClassLoader)this.helper.getClassLoader());
                    mapping.setAttributeElementClass(declaredClass);
                }
                catch (Exception e) {}
            }
        } else {
            mapping.setAttributeElementClass(Byte[].class);
        }
        if (this.areEquals(collectionType, Collection.class) || this.areEquals(collectionType, List.class)) {
            collectionType = this.jotArrayList;
        } else if (this.areEquals(collectionType, Set.class)) {
            collectionType = this.jotHashSet;
        }
        mapping.useCollectionClassName(collectionType.getRawName());
        descriptor.addMapping((DatabaseMapping)mapping);
        return mapping;
    }

    public void generateDirectEnumerationMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo, EnumTypeInfo enumInfo) {
        XMLDirectMapping mapping = new XMLDirectMapping();
        mapping.setConverter((Converter)this.buildJAXBEnumTypeConverter((DatabaseMapping)mapping, enumInfo));
        mapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor((AttributeAccessor)new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        mapping.setField((DatabaseField)this.getXPathForField(property, namespaceInfo, true));
        descriptor.addMapping((DatabaseMapping)mapping);
    }

    private JAXBEnumTypeConverter buildJAXBEnumTypeConverter(DatabaseMapping mapping, EnumTypeInfo enumInfo) {
        JAXBEnumTypeConverter converter = new JAXBEnumTypeConverter(mapping, enumInfo.getClassName(), false);
        List<Object> objects = enumInfo.getObjectValues();
        List<String> fieldValues = enumInfo.getFieldValues();
        for (int i = 0; i < objects.size(); ++i) {
            converter.addConversionValue(fieldValues.get(i), objects.get(i));
        }
        return converter;
    }

    public void generateCollectionMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        JavaClass javaClass = property.getActualType();
        if (property.isMixedContent()) {
            this.generateAnyCollectionMapping(property, descriptor, namespaceInfo, true);
            return;
        }
        if (javaClass != null && this.typeInfo.get(javaClass.getQualifiedName()) != null) {
            TypeInfo referenceInfo = this.typeInfo.get(javaClass.getQualifiedName());
            if (referenceInfo.isEnumerationType()) {
                this.generateEnumCollectionMapping(property, descriptor, namespaceInfo, (EnumTypeInfo)referenceInfo);
            } else if (property.isXmlIdRef()) {
                this.generateXMLCollectionReferenceMapping(property, descriptor, namespaceInfo, javaClass);
            } else {
                this.generateCompositeCollectionMapping(property, descriptor, namespaceInfo, javaClass.getQualifiedName());
            }
        } else if (!property.isAttribute() && javaClass != null && javaClass.getQualifiedName().equals(OBJECT_CLASS_NAME)) {
            XMLCompositeCollectionMapping ccMapping = this.generateCompositeCollectionMapping(property, descriptor, namespaceInfo, null);
            ccMapping.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
        } else if (this.areEquals(javaClass, ClassConstants.ABYTE) || this.areEquals(javaClass, ClassConstants.APBYTE) || this.areEquals(javaClass, "javax.activation.DataHandler") || this.areEquals(javaClass, "java.awt.Image") || this.areEquals(javaClass, "java.xml.transform.Source") || this.areEquals(javaClass, "javax.mail.internet.MimeMultipart")) {
            this.generateBinaryDataCollectionMapping(property, descriptor, namespaceInfo);
        } else {
            this.generateDirectCollectionMapping(property, descriptor, namespaceInfo);
        }
    }

    public void generateEnumCollectionMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo, EnumTypeInfo info) {
        XMLCompositeDirectCollectionMapping mapping = new XMLCompositeDirectCollectionMapping();
        mapping.setAttributeName(property.getPropertyName());
        mapping.setReuseContainer(true);
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor((AttributeAccessor)new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        mapping.setValueConverter((Converter)this.buildJAXBEnumTypeConverter((DatabaseMapping)mapping, info));
        JavaClass collectionType = property.getType();
        if (this.areEquals(collectionType, Collection.class) || this.areEquals(collectionType, List.class)) {
            collectionType = this.jotArrayList;
        } else if (this.areEquals(collectionType, Set.class)) {
            collectionType = this.jotHashSet;
        }
        mapping.useCollectionClassName(collectionType.getRawName());
        mapping.setField((DatabaseField)this.getXPathForField(property, namespaceInfo, true));
        if (property.isXmlList()) {
            mapping.setUsesSingleNode(true);
        }
        descriptor.addMapping((DatabaseMapping)mapping);
    }

    public void generateAnyAttributeMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        XMLAnyAttributeMapping mapping = new XMLAnyAttributeMapping();
        mapping.setAttributeName(property.getPropertyName());
        mapping.setReuseContainer(true);
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor((AttributeAccessor)new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        mapping.setSchemaInstanceIncluded(false);
        mapping.setNamespaceDeclarationIncluded(false);
        descriptor.addMapping((DatabaseMapping)mapping);
    }

    public void generateAnyObjectMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        XMLAnyObjectMapping mapping = new XMLAnyObjectMapping();
        mapping.setAttributeName(property.getPropertyName());
        mapping.setMixedContent(false);
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor((AttributeAccessor)new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        if (property.getType().getQualifiedName().equals("org.w3c.dom.Element")) {
            mapping.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT);
        } else {
            mapping.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
        }
        mapping.setUseXMLRoot(true);
        Class declaredType = this.helper.getClassForJavaClass(property.getActualType());
        JAXBElementRootConverter jaxbElementRootConverter = new JAXBElementRootConverter(declaredType);
        mapping.setConverter((XMLConverter)jaxbElementRootConverter);
        descriptor.addMapping((DatabaseMapping)mapping);
    }

    protected boolean areEquals(JavaClass src, Class tgt) {
        if (src == null || tgt == null) {
            return false;
        }
        return src.getRawName().equals(tgt.getCanonicalName());
    }

    protected boolean areEquals(JavaClass src, String tgtCanonicalName) {
        if (src == null || tgtCanonicalName == null) {
            return false;
        }
        return src.getRawName().equals(tgtCanonicalName);
    }

    public XMLCompositeCollectionMapping generateMapMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        XMLCompositeCollectionMapping mapping = new XMLCompositeCollectionMapping();
        mapping.setAttributeName(property.getPropertyName());
        mapping.setReuseContainer(true);
        XMLField field = this.getXPathForField(property, namespaceInfo, false);
        JavaClass descriptorClass = this.helper.getJavaClass(descriptor.getJavaClassName());
        JavaClass mapValueClass = this.helper.getJavaClass(MapValue.class);
        if (mapValueClass.isAssignableFrom(descriptorClass)) {
            mapping.setXPath("entry");
        } else {
            mapping.setXPath(field.getXPath() + "/entry");
        }
        Class generatedClass = this.generateMapEntryClassAndDescriptor(property, descriptor.getNonNullNamespaceResolver());
        mapping.setReferenceClass(generatedClass);
        String mapClassName = property.getType().getRawName();
        mapping.useCollectionClass(ArrayList.class);
        mapping.setAttributeAccessor((AttributeAccessor)new MapValueAttributeAccessor(mapping.getAttributeAccessor(), mapping.getContainerPolicy(), generatedClass, mapClassName));
        descriptor.addMapping((DatabaseMapping)mapping);
        return mapping;
    }

    private Class generateMapEntryClassAndDescriptor(Property property, NamespaceResolver nr) {
        JavaClass keyType = property.getKeyType();
        JavaClass valueType = property.getValueType();
        if (keyType == null) {
            keyType = this.helper.getJavaClass("java.lang.Object");
        }
        if (valueType == null) {
            valueType = this.helper.getJavaClass("java.lang.Object");
        }
        String mapEntryClassName = WRAPPER_CLASS + wrapperCounter++;
        MapEntryGeneratedKey mapKey = new MapEntryGeneratedKey(keyType.getQualifiedName(), valueType.getQualifiedName());
        Class generatedClass = this.getGeneratedMapEntryClasses().get(mapKey);
        if (generatedClass == null) {
            generatedClass = this.generateMapEntryClass(mapEntryClassName, keyType.getQualifiedName(), valueType.getQualifiedName());
            this.getGeneratedMapEntryClasses().put(mapKey, generatedClass);
            XMLDescriptor desc = new XMLDescriptor();
            desc.setJavaClass(generatedClass);
            desc.addMapping(this.generateMappingForType(keyType, "key"));
            desc.addMapping(this.generateMappingForType(valueType, "value"));
            NamespaceResolver newNr = new NamespaceResolver();
            String prefix = this.getPrefixForNamespace("http://www.w3.org/2001/XMLSchema-instance", nr, "xsi", false);
            if (prefix != null) {
                newNr.put(prefix, "http://www.w3.org/2001/XMLSchema-instance");
            }
            desc.setNamespaceResolver(newNr);
            this.project.addDescriptor((ClassDescriptor)desc);
        }
        return generatedClass;
    }

    private Class generateMapEntryClass(String className, String keyType, String valueType) {
        ClassWriter cw = new ClassWriter(false);
        String qualifiedInternalClassName = className.replace('.', '/');
        String qualifiedInternalKeyClassName = keyType.replace('.', '/');
        String qualifiedInternalValueClassName = valueType.replace('.', '/');
        cw.visit(49, 33, qualifiedInternalClassName, "java/lang/Object", new String[]{"org/eclipse/persistence/internal/jaxb/many/MapEntry"}, className.substring(className.lastIndexOf(".")));
        cw.visitField(2, "key", "L" + qualifiedInternalKeyClassName + ";", null, null);
        cw.visitField(2, "value", "L" + qualifiedInternalValueClassName + ";", null, null);
        CodeVisitor cv = cw.visitMethod(1, "<init>", "()V", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        cv.visitInsn(177);
        cv.visitMaxs(1, 1);
        cv = cw.visitMethod(1, "getKey", "()L" + qualifiedInternalKeyClassName + ";", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, qualifiedInternalClassName, "key", "L" + qualifiedInternalKeyClassName + ";");
        cv.visitInsn(176);
        cv.visitMaxs(1, 1);
        cv = cw.visitMethod(1, "setKey", "(L" + qualifiedInternalKeyClassName + ";)V", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitVarInsn(25, 1);
        cv.visitFieldInsn(181, qualifiedInternalClassName, "key", "L" + qualifiedInternalKeyClassName + ";");
        cv.visitInsn(177);
        cv.visitMaxs(2, 2);
        cv = cw.visitMethod(1, "getValue", "()L" + qualifiedInternalValueClassName + ";", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, qualifiedInternalClassName, "value", "L" + qualifiedInternalValueClassName + ";");
        cv.visitInsn(176);
        cv.visitMaxs(1, 1);
        cv = cw.visitMethod(1, "setValue", "(L" + qualifiedInternalValueClassName + ";)V", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitVarInsn(25, 1);
        cv.visitFieldInsn(181, qualifiedInternalClassName, "value", "L" + qualifiedInternalValueClassName + ";");
        cv.visitInsn(177);
        cv.visitMaxs(2, 2);
        if (!qualifiedInternalValueClassName.equals("java/lang/Object")) {
            cv = cw.visitMethod(4161, "getValue", "()Ljava/lang/Object;", null, null);
            cv.visitVarInsn(25, 0);
            cv.visitMethodInsn(182, qualifiedInternalClassName, "getValue", "()L" + qualifiedInternalValueClassName + ";");
            cv.visitInsn(176);
            cv.visitMaxs(1, 1);
            cv = cw.visitMethod(4161, "setValue", "(Ljava/lang/Object;)V", null, null);
            cv.visitVarInsn(25, 0);
            cv.visitVarInsn(25, 1);
            cv.visitTypeInsn(192, qualifiedInternalValueClassName);
            cv.visitMethodInsn(182, qualifiedInternalClassName, "setValue", "(L" + qualifiedInternalValueClassName + ";)V");
            cv.visitInsn(177);
            cv.visitMaxs(2, 2);
        }
        if (!qualifiedInternalKeyClassName.equals("java/lang/Object")) {
            cv = cw.visitMethod(4161, "getKey", "()Ljava/lang/Object;", null, null);
            cv.visitVarInsn(25, 0);
            cv.visitMethodInsn(182, qualifiedInternalClassName, "getKey", "()L" + qualifiedInternalKeyClassName + ";");
            cv.visitInsn(176);
            cv.visitMaxs(1, 1);
            cv = cw.visitMethod(4161, "setKey", "(Ljava/lang/Object;)V", null, null);
            cv.visitVarInsn(25, 0);
            cv.visitVarInsn(25, 1);
            cv.visitTypeInsn(192, qualifiedInternalKeyClassName);
            cv.visitMethodInsn(182, qualifiedInternalClassName, "setKey", "(L" + qualifiedInternalKeyClassName + ";)V");
            cv.visitInsn(177);
            cv.visitMaxs(2, 2);
        }
        SignatureAttribute attr = new SignatureAttribute("Ljava/lang/Object;Lorg/eclipse/persistence/internal/jaxb/many/MapEntry<L" + qualifiedInternalKeyClassName + ";L" + qualifiedInternalValueClassName + ";>;");
        cw.visitAttribute((Attribute)attr);
        cw.visitEnd();
        byte[] classBytes = cw.toByteArray();
        JaxbClassLoader loader = (JaxbClassLoader)this.helper.getClassLoader();
        Class generatedClass = loader.generateClass(className, classBytes);
        return generatedClass;
    }

    private DatabaseMapping generateMappingForType(JavaClass theType, String attributeName) {
        XMLCompositeObjectMapping mapping;
        boolean typeIsObject = theType.getRawName().equals(OBJECT_CLASS_NAME);
        if (this.typeInfo.containsKey(theType.getQualifiedName()) || typeIsObject) {
            mapping = new XMLCompositeObjectMapping();
            mapping.setAttributeName(attributeName);
            mapping.setXPath(attributeName);
            if (typeIsObject) {
                mapping.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
                ((XMLField)mapping.getField()).setIsTypedTextField(true);
                ((XMLField)mapping.getField()).setSchemaType(XMLConstants.ANY_TYPE_QNAME);
            } else {
                mapping.setReferenceClassName(theType.getQualifiedName());
            }
        } else {
            mapping = new XMLDirectMapping();
            mapping.setAttributeName(attributeName);
            ((XMLDirectMapping)mapping).setXPath(attributeName + TXT);
            QName schemaType = (QName)this.userDefinedSchemaTypes.get(theType);
            if (schemaType == null) {
                schemaType = (QName)this.helper.getXMLToJavaTypeMap().get(theType);
            }
            ((XMLField)((XMLDirectMapping)mapping).getField()).setSchemaType(schemaType);
        }
        return mapping;
    }

    public XMLCompositeCollectionMapping generateCompositeCollectionMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo, String referenceClassName) {
        JavaClass collectionType;
        XMLCompositeCollectionMapping mapping = new XMLCompositeCollectionMapping();
        mapping.setAttributeName(property.getPropertyName());
        mapping.setReuseContainer(true);
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor((AttributeAccessor)new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        if (property.isNillable()) {
            mapping.getNullPolicy().setNullRepresentedByXsiNil(true);
        }
        if ((collectionType = property.getType()).isArray()) {
            JAXBObjectArrayAttributeAccessor accessor = new JAXBObjectArrayAttributeAccessor(mapping.getAttributeAccessor(), mapping.getContainerPolicy());
            accessor.setComponentClassName(collectionType.getComponentType().getRawName());
            mapping.setAttributeAccessor((AttributeAccessor)accessor);
            collectionType = this.jotArrayList;
        } else if (this.areEquals(collectionType, Collection.class) || this.areEquals(collectionType, List.class)) {
            collectionType = this.jotArrayList;
        } else if (this.areEquals(collectionType, Set.class)) {
            collectionType = this.jotHashSet;
        }
        mapping.useCollectionClassName(collectionType.getRawName());
        XMLField xmlField = this.getXPathForField(property, namespaceInfo, false);
        mapping.setXPath(xmlField.getXPath());
        if (referenceClassName == null) {
            ((XMLField)mapping.getField()).setIsTypedTextField(true);
            ((XMLField)mapping.getField()).setSchemaType(XMLConstants.ANY_TYPE_QNAME);
        } else {
            mapping.setReferenceClassName(referenceClassName);
        }
        if (property.isRequired()) {
            ((XMLField)mapping.getField()).setRequired(true);
        }
        if (property.getInverseReferencePropertyName() != null) {
            mapping.setContainerAttributeName(property.getInverseReferencePropertyName());
            JavaClass backPointerPropertyType = null;
            JavaClass referenceClass = property.getActualType();
            if (property.getInverseReferencePropertyGetMethodName() != null && property.getInverseReferencePropertySetMethodName() != null && !property.getInverseReferencePropertyGetMethodName().equals("") && !property.getInverseReferencePropertySetMethodName().equals("")) {
                mapping.setContainerGetMethodName(property.getInverseReferencePropertySetMethodName());
                mapping.setContainerSetMethodName(property.getInverseReferencePropertySetMethodName());
                JavaMethod getMethod = referenceClass.getDeclaredMethod(mapping.getContainerGetMethodName(), new JavaClass[0]);
                if (getMethod != null) {
                    backPointerPropertyType = getMethod.getReturnType();
                }
            } else {
                JavaField backpointerField = referenceClass.getDeclaredField(property.getInverseReferencePropertyName());
                if (backpointerField != null) {
                    backPointerPropertyType = backpointerField.getResolvedType();
                }
            }
            if (this.isCollectionType(backPointerPropertyType)) {
                mapping.getInverseReferenceMapping().setContainerPolicy(ContainerPolicy.buildDefaultPolicy());
            }
        }
        descriptor.addMapping((DatabaseMapping)mapping);
        return mapping;
    }

    public XMLCompositeDirectCollectionMapping generateDirectCollectionMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        JavaClass collectionType;
        XMLCompositeDirectCollectionMapping mapping = new XMLCompositeDirectCollectionMapping();
        mapping.setAttributeName(property.getPropertyName());
        mapping.setReuseContainer(true);
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor((AttributeAccessor)new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        if ((collectionType = property.getType()).isArray()) {
            String componentClassName;
            AttributeAccessor accessor;
            if (collectionType.getComponentType().isPrimitive()) {
                accessor = new JAXBPrimitiveArrayAttributeAccessor(mapping.getAttributeAccessor(), mapping.getContainerPolicy());
                componentClassName = collectionType.getComponentType().getRawName();
                Class primitiveClass = XMLConversionManager.getDefaultManager().convertClassNameToClass(componentClassName);
                accessor.setComponentClass(primitiveClass);
                mapping.setAttributeAccessor(accessor);
                XMLConversionManager.getDefaultManager();
                Class declaredClass = ConversionManager.getObjectClass((Class)primitiveClass);
                mapping.setAttributeElementClass(declaredClass);
            } else {
                accessor = new JAXBObjectArrayAttributeAccessor(mapping.getAttributeAccessor(), mapping.getContainerPolicy());
                componentClassName = collectionType.getComponentType().getRawName();
                accessor.setComponentClassName(componentClassName);
                mapping.setAttributeAccessor(accessor);
                JavaClass componentType = collectionType.getComponentType();
                try {
                    Class declaredClass = PrivilegedAccessHelper.getClassForName((String)componentType.getRawName(), (boolean)false, (ClassLoader)this.helper.getClassLoader());
                    mapping.setAttributeElementClass(declaredClass);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            collectionType = this.jotArrayList;
        } else if (collectionType != null && this.isCollectionType(collectionType) && collectionType.hasActualTypeArguments()) {
            JavaClass itemType = (JavaClass)collectionType.getActualTypeArguments().toArray()[0];
            try {
                Class declaredClass = PrivilegedAccessHelper.getClassForName((String)itemType.getRawName(), (boolean)false, (ClassLoader)this.helper.getClassLoader());
                mapping.setAttributeElementClass(declaredClass);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.areEquals(collectionType, Collection.class) || this.areEquals(collectionType, List.class)) {
            collectionType = this.jotArrayList;
        } else if (this.areEquals(collectionType, Set.class)) {
            collectionType = this.jotHashSet;
        }
        mapping.useCollectionClassName(collectionType.getRawName());
        XMLField xmlField = this.getXPathForField(property, namespaceInfo, true);
        mapping.setField((DatabaseField)xmlField);
        if (this.helper.isAnnotationPresent(property.getElement(), XmlMixed.class)) {
            xmlField.setXPath("text()");
        }
        if (XMLConstants.QNAME_QNAME.equals(property.getSchemaType())) {
            ((XMLField)mapping.getField()).setSchemaType(XMLConstants.QNAME_QNAME);
        }
        if (property.getActualType() == null || property.getActualType().getRawName().equals("java.lang.String")) {
            mapping.getNullPolicy().setNullRepresentedByEmptyNode(false);
        }
        if (property.isRequired()) {
            ((XMLField)mapping.getField()).setRequired(true);
        }
        if (property.isXmlElementType() && property.getGenericType() != null) {
            Class theClass = this.helper.getClassForJavaClass(property.getGenericType());
            mapping.setAttributeElementClass(theClass);
        }
        if (xmlField.getXPathFragment().isAttribute()) {
            mapping.setUsesSingleNode(true);
        }
        if (property.isXmlList()) {
            mapping.setUsesSingleNode(true);
        }
        descriptor.addMapping((DatabaseMapping)mapping);
        return mapping;
    }

    public String getPrefixForNamespace(String URI2, NamespaceResolver namespaceResolver, String suggestedPrefix) {
        return this.getPrefixForNamespace(URI2, namespaceResolver, suggestedPrefix, true);
    }

    public String getPrefixForNamespace(String URI2, NamespaceResolver namespaceResolver, String suggestedPrefix, boolean addPrefixToNR) {
        String defaultNS = namespaceResolver.getDefaultNamespaceURI();
        if (defaultNS != null && URI2.equals(defaultNS)) {
            return null;
        }
        Enumeration keys = namespaceResolver.getPrefixes();
        while (keys.hasMoreElements()) {
            String next = (String)keys.nextElement();
            String nextUri = namespaceResolver.resolveNamespacePrefix(next);
            if (!nextUri.equals(URI2)) continue;
            return next;
        }
        String prefix = null;
        prefix = suggestedPrefix != null ? this.globalNamespaceResolver.generatePrefix(suggestedPrefix) : this.globalNamespaceResolver.generatePrefix();
        while (null != namespaceResolver.resolveNamespacePrefix(prefix)) {
            prefix = this.globalNamespaceResolver.generatePrefix();
        }
        if (addPrefixToNR) {
            namespaceResolver.put(prefix, URI2);
        }
        return prefix;
    }

    public boolean isCollectionType(Property field) {
        JavaClass type = field.getType();
        return this.isCollectionType(type);
    }

    public boolean isCollectionType(JavaClass type) {
        return this.helper.getJavaClass(Collection.class).isAssignableFrom(type) || this.helper.getJavaClass(List.class).isAssignableFrom(type) || this.helper.getJavaClass(Set.class).isAssignableFrom(type);
    }

    private void setupInheritance(JavaClass jClass) {
        XMLDescriptor descriptor = this.typeInfo.get(jClass.getName()).getDescriptor();
        if (descriptor == null) {
            return;
        }
        JavaClass superClass = this.helper.getNextMappedSuperClass(jClass);
        if (superClass == null) {
            return;
        }
        TypeInfo superTypeInfo = this.typeInfo.get(superClass.getName());
        if (superTypeInfo == null) {
            return;
        }
        XMLDescriptor superDescriptor = superTypeInfo.getDescriptor();
        if (superDescriptor != null) {
            XMLSchemaReference rootSRef;
            String sCtx;
            XMLSchemaReference sRef = descriptor.getSchemaReference();
            if (sRef == null || sRef.getSchemaContext() == null) {
                return;
            }
            JavaClass rootMappedSuperClass = this.getRootMappedSuperClass(superClass);
            TypeInfo rootTypeInfo = this.typeInfo.get(rootMappedSuperClass.getName());
            XMLDescriptor rootDescriptor = rootTypeInfo.getDescriptor();
            if (rootDescriptor.getNamespaceResolver() == null) {
                rootDescriptor.setNamespaceResolver(new NamespaceResolver());
            }
            if (rootDescriptor.getInheritancePolicy().getClassIndicatorField() == null) {
                String prefix = this.getPrefixForNamespace("http://www.w3.org/2001/XMLSchema-instance", rootDescriptor.getNamespaceResolver(), "xsi");
                XMLField classIndicatorField = new XMLField(ATT + this.getQualifiedString(prefix, "type"));
                rootDescriptor.getInheritancePolicy().setClassIndicatorField((DatabaseField)classIndicatorField);
            }
            if ((sCtx = sRef.getSchemaContext()).length() > 1 && sCtx.startsWith("/")) {
                sCtx = sCtx.substring(1);
            }
            descriptor.getInheritancePolicy().setParentClassName(superClass.getName());
            rootDescriptor.getInheritancePolicy().addClassNameIndicator(jClass.getName(), (Object)sCtx);
            Object value = rootDescriptor.getInheritancePolicy().getClassNameIndicatorMapping().get(rootDescriptor.getJavaClassName());
            if (value == null && (rootSRef = rootDescriptor.getSchemaReference()) != null && rootSRef.getSchemaContext() != null) {
                String rootSCtx = rootSRef.getSchemaContext();
                if (rootSCtx.length() > 1 && rootSCtx.startsWith("/")) {
                    rootSCtx = rootSCtx.substring(1);
                }
                rootDescriptor.getInheritancePolicy().addClassNameIndicator(rootDescriptor.getJavaClassName(), (Object)rootSCtx);
            }
            rootDescriptor.getInheritancePolicy().setShouldReadSubclasses(true);
        }
    }

    private JavaClass getRootMappedSuperClass(JavaClass javaClass) {
        JavaClass rootMappedSuperClass;
        JavaClass nextMappedSuperClass = rootMappedSuperClass = javaClass;
        while (nextMappedSuperClass != null) {
            if ((nextMappedSuperClass = this.helper.getNextMappedSuperClass(nextMappedSuperClass)) == null) {
                return rootMappedSuperClass;
            }
            rootMappedSuperClass = nextMappedSuperClass;
        }
        return rootMappedSuperClass;
    }

    public void generateMappings() {
        for (String next : this.typeInfo.keySet()) {
            XMLDescriptor descriptor;
            JavaClass javaClass = this.helper.getJavaClass(next);
            TypeInfo info = this.typeInfo.get(next);
            NamespaceInfo namespaceInfo = this.packageToNamespaceMappings.get(javaClass.getPackageName());
            if (info.isEnumerationType() || (descriptor = info.getDescriptor()) == null) continue;
            this.generateMappings(info, descriptor, namespaceInfo);
        }
    }

    public void generateMappings(TypeInfo info, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        List<Property> propertiesInOrder = info.getNonTransientPropertiesInPropOrder();
        for (int i = 0; i < propertiesInOrder.size(); ++i) {
            Property next = propertiesInOrder.get(i);
            if (next == null) continue;
            this.generateMapping(next, descriptor, namespaceInfo);
        }
    }

    public void generateXMLCollectionReferenceMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo, JavaClass referenceClass) {
        XMLField srcXPath = this.getXPathForField(property, namespaceInfo, true);
        XMLCollectionReferenceMapping mapping = new XMLCollectionReferenceMapping();
        mapping.setAttributeName(property.getPropertyName());
        mapping.setReuseContainer(true);
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor((AttributeAccessor)new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        mapping.setReferenceClassName(referenceClass.getQualifiedName());
        JavaClass collectionType = property.getType();
        if (this.areEquals(collectionType, Collection.class) || this.areEquals(collectionType, List.class)) {
            collectionType = this.jotArrayList;
        } else if (this.areEquals(collectionType, Set.class)) {
            collectionType = this.jotHashSet;
        }
        mapping.useCollectionClassName(collectionType.getRawName());
        TypeInfo referenceType = this.typeInfo.get(referenceClass.getQualifiedName());
        if (referenceType.isIDSet()) {
            Property prop;
            XMLField tgtXPath = this.getXPathForField(prop, namespaceInfo, !this.helper.isAnnotationPresent((prop = referenceType.getIDProperty()).getElement(), XmlAttribute.class));
            mapping.addSourceToTargetKeyFieldAssociation(srcXPath.getXPath(), tgtXPath.getXPath());
        }
        if (property.getInverseReferencePropertyName() != null) {
            mapping.getInverseReferenceMapping().setAttributeName(property.getInverseReferencePropertyName());
            JavaClass backPointerPropertyType = null;
            if (property.getInverseReferencePropertyGetMethodName() != null && property.getInverseReferencePropertySetMethodName() != null && !property.getInverseReferencePropertyGetMethodName().equals("") && !property.getInverseReferencePropertySetMethodName().equals("")) {
                mapping.getInverseReferenceMapping().setGetMethodName(property.getInverseReferencePropertySetMethodName());
                mapping.getInverseReferenceMapping().setSetMethodName(property.getInverseReferencePropertySetMethodName());
                JavaMethod getMethod = referenceClass.getDeclaredMethod(mapping.getInverseReferenceMapping().getGetMethodName(), new JavaClass[0]);
                if (getMethod != null) {
                    backPointerPropertyType = getMethod.getReturnType();
                }
            } else {
                JavaField backpointerField = referenceClass.getDeclaredField(property.getInverseReferencePropertyName());
                if (backpointerField != null) {
                    backPointerPropertyType = backpointerField.getResolvedType();
                }
            }
            if (this.isCollectionType(backPointerPropertyType)) {
                mapping.getInverseReferenceMapping().setContainerPolicy(ContainerPolicy.buildDefaultPolicy());
            }
        }
        descriptor.addMapping((DatabaseMapping)mapping);
    }

    public void generateXMLObjectReferenceMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo, JavaClass referenceClass) {
        XMLField srcXPath = this.getXPathForField(property, namespaceInfo, true);
        XMLObjectReferenceMapping mapping = new XMLObjectReferenceMapping();
        mapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor((AttributeAccessor)new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        mapping.setReferenceClassName(referenceClass.getQualifiedName());
        TypeInfo referenceType = this.typeInfo.get(referenceClass.getQualifiedName());
        if (referenceType.isIDSet()) {
            Property prop;
            XMLField tgtXPath = this.getXPathForField(prop, namespaceInfo, !this.helper.isAnnotationPresent((prop = referenceType.getIDProperty()).getElement(), XmlAttribute.class));
            mapping.addSourceToTargetKeyFieldAssociation(srcXPath.getXPath(), tgtXPath.getXPath());
        }
        if (property.getInverseReferencePropertyName() != null) {
            mapping.getInverseReferenceMapping().setAttributeName(property.getInverseReferencePropertyName());
            JavaClass backPointerPropertyType = null;
            if (property.getInverseReferencePropertyGetMethodName() != null && property.getInverseReferencePropertySetMethodName() != null && !property.getInverseReferencePropertyGetMethodName().equals("") && !property.getInverseReferencePropertySetMethodName().equals("")) {
                mapping.getInverseReferenceMapping().setGetMethodName(property.getInverseReferencePropertySetMethodName());
                mapping.getInverseReferenceMapping().setSetMethodName(property.getInverseReferencePropertySetMethodName());
                JavaMethod getMethod = referenceClass.getDeclaredMethod(mapping.getInverseReferenceMapping().getGetMethodName(), new JavaClass[0]);
                if (getMethod != null) {
                    backPointerPropertyType = getMethod.getReturnType();
                }
            } else {
                JavaField backpointerField = referenceClass.getDeclaredField(property.getInverseReferencePropertyName());
                if (backpointerField != null) {
                    backPointerPropertyType = backpointerField.getResolvedType();
                }
            }
            if (this.isCollectionType(backPointerPropertyType)) {
                mapping.getInverseReferenceMapping().setContainerPolicy(ContainerPolicy.buildDefaultPolicy());
            }
        }
        descriptor.addMapping((DatabaseMapping)mapping);
    }

    public XMLField getXPathForField(Property property, NamespaceInfo namespaceInfo, boolean isTextMapping) {
        QName schemaType;
        String prefix;
        String namespace;
        String xPath = "";
        XMLField xmlField = null;
        if (property.isSetXmlElementWrapper()) {
            XmlElementWrapper wrapper = property.getXmlElementWrapper();
            namespace = wrapper.getNamespace();
            if (namespace.equals("##default")) {
                namespace = namespaceInfo.isElementFormQualified() ? namespaceInfo.getNamespace() : "";
            }
            if (namespace.equals("")) {
                xPath = xPath + wrapper.getName() + "/";
            } else {
                prefix = this.getPrefixForNamespace(namespace, namespaceInfo.getNamespaceResolverForDescriptor(), null);
                xPath = xPath + this.getQualifiedString(prefix, wrapper.getName() + "/");
            }
        }
        if (property.isAttribute()) {
            QName name = property.getSchemaName();
            namespace = "";
            if (namespaceInfo.isAttributeFormQualified()) {
                namespace = namespaceInfo.getNamespace();
            }
            if (!name.getNamespaceURI().equals("")) {
                namespace = name.getNamespaceURI();
            }
            if (namespace.equals("")) {
                xPath = xPath + ATT + name.getLocalPart();
            } else {
                prefix = this.getPrefixForNamespace(namespace, namespaceInfo.getNamespaceResolverForDescriptor(), null);
                xPath = xPath + ATT + this.getQualifiedString(prefix, name.getLocalPart());
            }
            QName schemaType2 = (QName)this.userDefinedSchemaTypes.get(property.getClass());
            if (property.getSchemaType() != null) {
                schemaType2 = property.getSchemaType();
            }
            if (schemaType2 == null) {
                schemaType2 = (QName)this.helper.getXMLToJavaTypeMap().get(property.getType().getRawName());
            }
            XMLField field = new XMLField(xPath);
            field.setSchemaType(schemaType2);
            return field;
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlValue.class)) {
            xPath = "text()";
            XMLField field = new XMLField(xPath);
            schemaType = (QName)this.userDefinedSchemaTypes.get(property.getType());
            if (property.getSchemaType() != null) {
                schemaType = property.getSchemaType();
            }
            if (schemaType == null) {
                schemaType = (QName)this.helper.getXMLToJavaTypeMap().get(property.getType());
            }
            field.setSchemaType(schemaType);
            return field;
        }
        QName elementName = property.getSchemaName();
        xmlField = this.getXPathForElement(xPath, elementName, namespaceInfo, isTextMapping);
        schemaType = (QName)this.userDefinedSchemaTypes.get(property.getType());
        if (property.getSchemaType() != null) {
            schemaType = property.getSchemaType();
        }
        if (schemaType == null) {
            JavaClass propertyType = property.getActualType();
            schemaType = (QName)this.helper.getXMLToJavaTypeMap().get(propertyType.getRawName());
        }
        xmlField.setSchemaType(schemaType);
        return xmlField;
    }

    public XMLField getXPathForElement(String path, QName elementName, NamespaceInfo namespaceInfo, boolean isText) {
        String namespace = "";
        if (!elementName.getNamespaceURI().equals("")) {
            namespace = elementName.getNamespaceURI();
        }
        if (namespace.equals("")) {
            path = path + elementName.getLocalPart();
            if (isText) {
                path = path + TXT;
            }
        } else {
            String prefix = this.getPrefixForNamespace(namespace, namespaceInfo.getNamespaceResolverForDescriptor(), null);
            path = path + this.getQualifiedString(prefix, elementName.getLocalPart());
            if (isText) {
                path = path + TXT;
            }
        }
        XMLField xmlField = new XMLField(path);
        return xmlField;
    }

    public Property getXmlValueFieldForSimpleContent(ArrayList<Property> properties) {
        boolean foundValue = false;
        boolean foundNonAttribute = false;
        Property valueField = null;
        for (Property prop : properties) {
            if (this.helper.isAnnotationPresent(prop.getElement(), XmlValue.class)) {
                foundValue = true;
                valueField = prop;
                continue;
            }
            if (this.helper.isAnnotationPresent(prop.getElement(), XmlAttribute.class) || this.helper.isAnnotationPresent(prop.getElement(), XmlTransient.class) || prop.isAnyAttribute()) continue;
            foundNonAttribute = true;
        }
        if (foundValue && !foundNonAttribute) {
            return valueField;
        }
        return null;
    }

    public void processSchemaType(XmlSchemaType type) {
        String schemaTypeName = type.name();
        Class javaType = type.type();
        if (javaType == null) {
            return;
        }
        QName typeQName = new QName(type.namespace(), schemaTypeName);
        this.userDefinedSchemaTypes.put(javaType, typeQName);
    }

    public String getSchemaTypeNameForClassName(String className) {
        String typeName = Introspector.decapitalize(className.substring(className.lastIndexOf(46) + 1));
        return typeName;
    }

    public boolean isMapType(Property property) {
        JavaClass mapCls = this.helper.getJavaClass(Map.class);
        return mapCls.isAssignableFrom(property.getType());
    }

    public void processGlobalElements(Project project) {
        if (this.globalElements == null && this.localElements == null) {
            return;
        }
        ArrayList<ElementDeclaration> elements = new ArrayList<ElementDeclaration>();
        elements.addAll(this.localElements);
        elements.addAll(this.globalElements.values());
        for (ElementDeclaration nextElement : elements) {
            QName next = nextElement.getElementName();
            String nextClassName = nextElement.getJavaTypeName();
            TypeInfo type = this.typeInfo.get(nextClassName);
            if (this.helper.isBuiltInJavaType(nextElement.getJavaType()) || type != null && type.isEnumerationType()) {
                Class declaredClass;
                Class generatedClass;
                String attributeTypeName = nextClassName;
                if (nextElement.getJavaType().isPrimitive()) {
                    attributeTypeName = this.helper.getClassForJavaClass(nextElement.getJavaType()).getName();
                }
                if (nextElement.getAdaptedJavaTypeName() != null) {
                    attributeTypeName = nextElement.getAdaptedJavaTypeName();
                }
                if (next == null && (this.areEquals(nextElement.getJavaType(), ClassConstants.ABYTE) || this.areEquals(nextElement.getJavaType(), ClassConstants.APBYTE) || this.areEquals(nextElement.getJavaType(), "javax.activation.DataHandler") || this.areEquals(nextElement.getJavaType(), "java.awt.Image") || this.areEquals(nextElement.getJavaType(), "java.xml.transform.Source") || this.areEquals(nextElement.getJavaType(), "javax.mail.internet.MimeMultipart"))) {
                    generatedClass = this.addByteArrayWrapperAndDescriptor(type, nextElement.getJavaType().getRawName(), nextElement, nextClassName, attributeTypeName);
                    this.qNamesToGeneratedClasses.put(next, generatedClass);
                    if (nextElement.getTypeMappingInfo() != null) {
                        this.typeMappingInfoToGeneratedClasses.put(nextElement.getTypeMappingInfo(), generatedClass);
                    }
                    try {
                        declaredClass = PrivilegedAccessHelper.getClassForName((String)nextClassName, (boolean)false, (ClassLoader)this.helper.getClassLoader());
                        this.qNamesToDeclaredClasses.put(next, declaredClass);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    return;
                }
                generatedClass = this.generateWrapperClassAndDescriptor(type, next, nextElement, nextClassName, attributeTypeName);
                this.qNamesToGeneratedClasses.put(next, generatedClass);
                try {
                    declaredClass = PrivilegedAccessHelper.getClassForName((String)nextClassName, (boolean)false, (ClassLoader)this.helper.getClassLoader());
                    this.qNamesToDeclaredClasses.put(next, declaredClass);
                }
                catch (Exception e) {}
                continue;
            }
            if (type == null || type.isTransient()) continue;
            if (next.getNamespaceURI() == null || next.getNamespaceURI().equals("")) {
                if (type.getDescriptor().getDefaultRootElement() == null) {
                    type.getDescriptor().setDefaultRootElement(next.getLocalPart());
                    continue;
                }
                type.getDescriptor().addRootElement(next.getLocalPart());
                continue;
            }
            XMLDescriptor descriptor = type.getDescriptor();
            String uri = next.getNamespaceURI();
            String prefix = this.getPrefixForNamespace(uri, descriptor.getNamespaceResolver(), null);
            if (type.getDescriptor().getDefaultRootElement() == null) {
                descriptor.setDefaultRootElement(this.getQualifiedString(prefix, next.getLocalPart()));
                continue;
            }
            descriptor.addRootElement(this.getQualifiedString(prefix, next.getLocalPart()));
        }
    }

    private Class addByteArrayWrapperAndDescriptor(TypeInfo type, String javaClassName, ElementDeclaration nextElement, String nextClassName, String attributeTypeName) {
        Class generatedClass = this.classToGeneratedClasses.get(javaClassName);
        if (generatedClass == null) {
            generatedClass = this.generateWrapperClassAndDescriptor(type, null, nextElement, nextClassName, attributeTypeName);
            this.classToGeneratedClasses.put(javaClassName, generatedClass);
        }
        return generatedClass;
    }

    private Class generateWrapperClassAndDescriptor(TypeInfo type, QName next, ElementDeclaration nextElement, String nextClassName, String attributeTypeName) {
        String namespaceUri = null;
        if (next != null && ((namespaceUri = next.getNamespaceURI()) == null || namespaceUri.equals("##default"))) {
            namespaceUri = "";
        }
        TypeMappingInfo tmi = nextElement.getTypeMappingInfo();
        Class generatedClass = null;
        if (tmi != null) {
            generatedClass = CompilerHelper.getExisitingGeneratedClass(tmi, this.typeMappingInfoToGeneratedClasses, this.typeMappingInfoToAdapterClasses, this.helper.getClassLoader());
            if (generatedClass == null) {
                generatedClass = this.generateWrapperClass(WRAPPER_CLASS + wrapperCounter++, attributeTypeName, nextElement.isList(), next);
            }
            this.typeMappingInfoToGeneratedClasses.put(tmi, generatedClass);
        } else {
            generatedClass = this.generateWrapperClass(WRAPPER_CLASS + wrapperCounter++, attributeTypeName, nextElement.isList(), next);
        }
        this.qNamesToGeneratedClasses.put(next, generatedClass);
        try {
            Class declaredClass = PrivilegedAccessHelper.getClassForName((String)nextClassName, (boolean)false, (ClassLoader)this.helper.getClassLoader());
            this.qNamesToDeclaredClasses.put(next, declaredClass);
        }
        catch (Exception e) {
            // empty catch block
        }
        XMLDescriptor desc = (XMLDescriptor)this.project.getDescriptor(generatedClass);
        if (desc == null) {
            Class attributeClassification;
            XMLCompositeDirectCollectionMapping mapping;
            desc = new XMLDescriptor();
            desc.setJavaClass(generatedClass);
            if (nextElement.isList()) {
                mapping = new XMLCompositeDirectCollectionMapping();
                mapping.setAttributeName("value");
                mapping.setXPath("text()");
                mapping.setUsesSingleNode(true);
                mapping.setReuseContainer(true);
                if (type != null && type.isEnumerationType()) {
                    mapping.setValueConverter((Converter)this.buildJAXBEnumTypeConverter((DatabaseMapping)mapping, (EnumTypeInfo)type));
                } else {
                    try {
                        Class fieldElementClass = PrivilegedAccessHelper.getClassForName((String)nextClassName, (boolean)false, (ClassLoader)this.helper.getClassLoader());
                        mapping.setFieldElementClass(fieldElementClass);
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                }
                if (nextClassName.equals("[B") || nextClassName.equals("[Ljava.lang.Byte;")) {
                    ((XMLField)mapping.getField()).setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
                } else if (nextClassName.equals("javax.xml.namespace.QName")) {
                    ((XMLField)mapping.getField()).setSchemaType(XMLConstants.QNAME_QNAME);
                }
                desc.addMapping((DatabaseMapping)mapping);
            } else if (nextElement.getJavaTypeName().equals(OBJECT_CLASS_NAME)) {
                mapping = new XMLCompositeObjectMapping();
                mapping.setAttributeName("value");
                mapping.setSetMethodName("setValue");
                mapping.setGetMethodName("getValue");
                mapping.getNullPolicy().setNullRepresentedByXsiNil(true);
                mapping.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
                mapping.setXPath(".");
                ((XMLField)mapping.getField()).setIsTypedTextField(true);
                ((XMLField)mapping.getField()).setSchemaType(XMLConstants.ANY_TYPE_QNAME);
                desc.addMapping((DatabaseMapping)mapping);
            } else if (this.areEquals(nextElement.getJavaType(), ClassConstants.ABYTE) || this.areEquals(nextElement.getJavaType(), ClassConstants.APBYTE) || this.areEquals(nextElement.getJavaType(), "javax.activation.DataHandler") || this.areEquals(nextElement.getJavaType(), "java.awt.Image") || this.areEquals(nextElement.getJavaType(), "javax.xml.transform.Source")) {
                mapping = new XMLBinaryDataMapping();
                mapping.setAttributeName("value");
                mapping.setXPath(".");
                ((XMLField)mapping.getField()).setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
                mapping.setSetMethodName("setValue");
                mapping.setGetMethodName("getValue");
                attributeClassification = Helper.getClassFromClasseName((String)attributeTypeName, (ClassLoader)this.getClass().getClassLoader());
                mapping.setAttributeClassification(attributeClassification);
                mapping.setShouldInlineBinaryData(false);
                if (nextElement.getTypeMappingInfo() != null) {
                    mapping.setSwaRef(nextElement.isXmlAttachmentRef());
                    mapping.setMimeType(nextElement.getXmlMimeType());
                }
                desc.addMapping((DatabaseMapping)mapping);
            } else {
                mapping = new XMLDirectMapping();
                mapping.setAttributeName("value");
                mapping.setXPath("text()");
                mapping.setSetMethodName("setValue");
                mapping.setGetMethodName("getValue");
                if (nextElement.getDefaultValue() != null) {
                    mapping.setNullValue((Object)nextElement.getDefaultValue());
                }
                if (this.helper.isBuiltInJavaType(nextElement.getJavaType())) {
                    attributeClassification = null;
                    attributeClassification = nextElement.getJavaType().isPrimitive() ? XMLConversionManager.getDefaultManager().convertClassNameToClass(attributeTypeName) : Helper.getClassFromClasseName((String)attributeTypeName, (ClassLoader)this.getClass().getClassLoader());
                    mapping.setAttributeClassification(attributeClassification);
                }
                IsSetNullPolicy nullPolicy = new IsSetNullPolicy("isSetValue", false, true, XMLNullRepresentationType.ABSENT_NODE);
                mapping.setNullPolicy((AbstractNullPolicy)nullPolicy);
                if (type != null && type.isEnumerationType()) {
                    mapping.setConverter((Converter)this.buildJAXBEnumTypeConverter((DatabaseMapping)mapping, (EnumTypeInfo)type));
                }
                if (nextClassName.equals("[B") || nextClassName.equals("[Ljava.lang.Byte;")) {
                    ((XMLField)mapping.getField()).setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
                } else if (nextClassName.equals("javax.xml.namespace.QName")) {
                    ((XMLField)mapping.getField()).setSchemaType(XMLConstants.QNAME_QNAME);
                }
                if (nextElement.getJavaTypeAdapterClass() != null) {
                    mapping.setConverter((Converter)new XMLJavaTypeConverter(nextElement.getJavaTypeAdapterClass()));
                }
                desc.addMapping((DatabaseMapping)mapping);
            }
            if (next != null) {
                NamespaceResolver resolver;
                NamespaceInfo info = this.getNamespaceInfoForURI(namespaceUri);
                if (info != null) {
                    resolver = info.getNamespaceResolverForDescriptor();
                    String prefix = resolver.resolveNamespaceURI(namespaceUri);
                    desc.setNamespaceResolver(resolver);
                    desc.setDefaultRootElement("");
                    desc.addRootElement(this.getQualifiedString(prefix, next.getLocalPart()));
                } else if (namespaceUri.equals("")) {
                    desc.setDefaultRootElement(next.getLocalPart());
                } else {
                    resolver = new NamespaceResolver();
                    String prefix = this.getPrefixForNamespace(namespaceUri, resolver, null);
                    desc.setNamespaceResolver(resolver);
                    desc.setDefaultRootElement("");
                    desc.addRootElement(this.getQualifiedString(prefix, next.getLocalPart()));
                }
            }
            this.project.addDescriptor((ClassDescriptor)desc);
        }
        return generatedClass;
    }

    private String getQualifiedString(String prefix, String localPart) {
        if (prefix == null) {
            return localPart;
        }
        return prefix + ':' + localPart;
    }

    private NamespaceInfo getNamespaceInfoForURI(String namespaceUri) {
        for (NamespaceInfo next : this.packageToNamespaceMappings.values()) {
            if (!next.getNamespace().equals(namespaceUri)) continue;
            return next;
        }
        return null;
    }

    private String getPackageNameForURI(String namespaceUri) {
        for (String next : this.packageToNamespaceMappings.keySet()) {
            if (!this.packageToNamespaceMappings.get(next).getNamespace().equals(namespaceUri)) continue;
            return next;
        }
        return null;
    }

    public Class generateWrapperClass(String className, String attributeType, boolean isList, QName theQName) {
        ClassWriter cw = new ClassWriter(false);
        cw.visit(49, 1, className.replace(".", "/"), Type.getType(WrappedValue.class).getInternalName(), new String[0], null);
        String fieldType = null;
        if (isList) {
            fieldType = "Ljava/util/List;";
        } else {
            fieldType = attributeType.replace(".", "/");
            if (!fieldType.startsWith("[")) {
                fieldType = "L" + fieldType + ";";
            }
        }
        if (theQName == null) {
            theQName = RESERVED_QNAME;
        }
        CodeVisitor cv = cw.visitMethod(1, "<init>", "()V", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitTypeInsn(187, "javax/xml/namespace/QName");
        cv.visitInsn(89);
        cv.visitLdcInsn((Object)theQName.getNamespaceURI());
        cv.visitLdcInsn((Object)theQName.getLocalPart());
        cv.visitMethodInsn(183, "javax/xml/namespace/QName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V");
        cv.visitLdcInsn((Object)Type.getType((String)fieldType));
        cv.visitInsn(1);
        cv.visitMethodInsn(183, "org/eclipse/persistence/internal/jaxb/WrappedValue", "<init>", "(Ljavax/xml/namespace/QName;Ljava/lang/Class;Ljava/lang/Object;)V");
        cv.visitInsn(177);
        cv.visitMaxs(5, 1);
        cw.visitEnd();
        byte[] classBytes = cw.toByteArray();
        JaxbClassLoader loader = (JaxbClassLoader)this.helper.getClassLoader();
        Class generatedClass = loader.generateClass(className, classBytes);
        return generatedClass;
    }

    public HashMap<QName, Class> getQNamesToGeneratedClasses() {
        return this.qNamesToGeneratedClasses;
    }

    public HashMap<String, Class> getClassToGeneratedClasses() {
        return this.classToGeneratedClasses;
    }

    public HashMap<QName, Class> getQNamesToDeclaredClasses() {
        return this.qNamesToDeclaredClasses;
    }

    private Map<MapEntryGeneratedKey, Class> getGeneratedMapEntryClasses() {
        if (this.generatedMapEntryClasses == null) {
            this.generatedMapEntryClasses = new HashMap<MapEntryGeneratedKey, Class>();
        }
        return this.generatedMapEntryClasses;
    }

    private class MapEntryGeneratedKey {
        String keyClassName;
        String valueClassName;

        public MapEntryGeneratedKey(String keyClass, String valueClass) {
            this.keyClassName = keyClass;
            this.valueClassName = valueClass;
        }
    }
}

