/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.io.Serializable;
import java.io.StringWriter;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.sessions.Record;

public abstract class AbstractRecord
implements Record,
Cloneable,
Serializable,
Map {
    protected Vector fields;
    protected Vector values;
    protected DatabaseField lookupField;
    protected int size;
    public static final NoEntry noEntry = new NoEntry();

    public AbstractRecord() {
        this.fields = new NonSynchronizedVector();
        this.values = new NonSynchronizedVector();
        this.size = 0;
    }

    public AbstractRecord(int initialCapacity) {
        this.fields = new NonSynchronizedVector(initialCapacity);
        this.values = new NonSynchronizedVector(initialCapacity);
        this.size = 0;
    }

    public AbstractRecord(Vector fields, Vector values) {
        this.fields = fields;
        this.values = values;
        this.resetSize();
    }

    protected void resetSize() {
        this.size = this.fields == null ? 0 : this.fields.size();
    }

    public void add(DatabaseField key, Object value) {
        this.fields.add(key);
        this.values.add(value);
        ++this.size;
    }

    public void clear() {
        this.fields = new Vector();
        this.values = new Vector();
        this.resetSize();
    }

    public Object clone() {
        try {
            AbstractRecord clone = (AbstractRecord)super.clone();
            clone.setFields((Vector)this.getFields().clone());
            clone.setValues((Vector)this.getValues().clone());
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new InternalError();
        }
    }

    public boolean contains(Object value) {
        return this.containsValue(value);
    }

    public boolean containsKey(Object key) {
        if (key instanceof String) {
            return this.containsKey((String)key);
        }
        if (key instanceof DatabaseField) {
            return this.containsKey((DatabaseField)key);
        }
        return false;
    }

    public boolean containsKey(String fieldName) {
        if (this.lookupField == null) {
            this.lookupField = new DatabaseField(fieldName);
        } else {
            this.lookupField.resetQualifiedName(fieldName);
        }
        return this.containsKey(this.lookupField);
    }

    public boolean containsKey(DatabaseField key) {
        DatabaseField field;
        int index = key.getIndex();
        if (index >= 0 && index < this.size && ((field = (DatabaseField)this.fields.get(index)) == key || field.equals(key))) {
            return true;
        }
        return this.fields.contains(key);
    }

    public boolean containsValue(Object value) {
        return this.getValues().contains(value);
    }

    public Enumeration elements() {
        return this.getValues().elements();
    }

    public Set entrySet() {
        return new EntrySet();
    }

    public Object get(Object key) {
        if (key instanceof String) {
            return this.get((String)key);
        }
        if (key instanceof DatabaseField) {
            return this.get((DatabaseField)key);
        }
        return null;
    }

    public Object get(String fieldName) {
        Object value = this.getIndicatingNoEntry(fieldName);
        if (value == noEntry) {
            return null;
        }
        return value;
    }

    public Object getIndicatingNoEntry(String fieldName) {
        if (this.lookupField == null) {
            this.lookupField = new DatabaseField(fieldName);
        } else {
            this.lookupField.resetQualifiedName(fieldName);
        }
        return this.getIndicatingNoEntry(this.lookupField);
    }

    public Object get(DatabaseField key) {
        DatabaseField field;
        int index = key.getIndex();
        if (index >= 0 && index < this.size && ((field = (DatabaseField)this.fields.get(index)) == key || field.equals(key))) {
            return this.values.get(index);
        }
        index = this.fields.indexOf(key);
        if (index >= 0) {
            if (index == -1) {
                key.setIndex(index);
            }
            return this.values.get(index);
        }
        return null;
    }

    public Object getValues(DatabaseField key) {
        return this.get(key);
    }

    public Object getValues(String key) {
        return this.get(key);
    }

    public Object getIndicatingNoEntry(DatabaseField key) {
        DatabaseField field;
        int index = key.getIndex();
        if (index >= 0 && index < this.size && ((field = (DatabaseField)this.fields.get(index)) == key || field.equals(key))) {
            return this.values.get(index);
        }
        index = this.fields.indexOf(key);
        if (index >= 0) {
            if (index == -1) {
                key.setIndex(index);
            }
            return this.values.get(index);
        }
        return noEntry;
    }

    public DatabaseField getField(DatabaseField key) {
        DatabaseField field;
        int index = key.getIndex();
        if (index >= 0 && index < this.getFields().size() && ((field = (DatabaseField)this.getFields().elementAt(index)) == key || field.equals(key))) {
            return field;
        }
        for (index = 0; index < this.getFields().size(); ++index) {
            field = (DatabaseField)this.getFields().elementAt(index);
            if (field != key && !field.equals(key)) continue;
            return field;
        }
        return null;
    }

    public Vector getFields() {
        return this.fields;
    }

    public Vector getValues() {
        return this.values;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Enumeration keys() {
        return this.getFields().elements();
    }

    public Set keySet() {
        return new KeySet();
    }

    public void mergeFrom(AbstractRecord row) {
        for (int index = 0; index < row.size(); ++index) {
            this.put(row.getFields().get(index), row.getValues().get(index));
        }
    }

    public Object put(Object key, Object value) throws ValidationException {
        if (key instanceof String) {
            return this.put((String)key, value);
        }
        if (key instanceof DatabaseField) {
            return this.put((DatabaseField)key, value);
        }
        throw ValidationException.onlyFieldsAreValidKeysForDatabaseRows();
    }

    public Object put(String key, Object value) {
        return this.put(new DatabaseField(key), value);
    }

    public Object put(DatabaseField key, Object value) {
        int index = this.fields.indexOf(key);
        if (index >= 0) {
            return this.values.set(index, value);
        }
        this.add(key, value);
        return null;
    }

    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object key) {
        if (key instanceof String) {
            return this.remove((String)key);
        }
        if (key instanceof DatabaseField) {
            return this.remove((DatabaseField)key);
        }
        return null;
    }

    public Object remove(String fieldName) {
        return this.remove(new DatabaseField(fieldName));
    }

    public Object remove(DatabaseField key) {
        int index = this.getFields().indexOf(key);
        if (index >= 0) {
            this.getFields().removeElementAt(index);
            Object value = this.getValues().elementAt(index);
            this.getValues().removeElementAt(index);
            this.resetSize();
            return value;
        }
        return null;
    }

    public void replaceAt(Object value, int index) {
        this.values.set(index, value);
    }

    protected void setFields(Vector fields) {
        this.fields = fields;
        this.resetSize();
    }

    protected void setValues(Vector values) {
        this.values = values;
    }

    public int size() {
        return this.fields.size();
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write(Helper.getShortClassName(this.getClass()));
        writer.write("(");
        for (int index = 0; index < this.getFields().size(); ++index) {
            writer.write(Helper.cr());
            writer.write("\t");
            writer.write(String.valueOf(this.getFields().elementAt(index)));
            writer.write(" => ");
            writer.write(String.valueOf(this.getValues().elementAt(index)));
        }
        writer.write(")");
        return writer.toString();
    }

    public Collection values() {
        return new ValuesSet();
    }

    protected class EntrySet
    extends AbstractSet {
        protected EntrySet() {
        }

        public Iterator iterator() {
            return new RecordEntryIterator();
        }

        public int size() {
            return AbstractRecord.this.size();
        }

        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            return AbstractRecord.this.containsKey(((Map.Entry)object).getKey());
        }

        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            AbstractRecord.this.remove(((Map.Entry)object).getKey());
            return true;
        }

        public void clear() {
            AbstractRecord.this.clear();
        }
    }

    protected class KeySet
    extends EntrySet {
        protected KeySet() {
        }

        public Iterator iterator() {
            return new RecordKeyIterator();
        }

        public boolean contains(Object object) {
            return AbstractRecord.this.containsKey(object);
        }

        public boolean remove(Object object) {
            return AbstractRecord.this.remove(object) != null;
        }
    }

    public static class NoEntry {
        private NoEntry() {
        }
    }

    protected static class RecordEntry
    implements Map.Entry {
        Object key;
        Object value;

        public RecordEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return this.compare(this.key, entry.getKey()) && this.compare(this.value, entry.getValue());
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        private boolean compare(Object object1, Object object2) {
            return object1 == null ? object2 == null : object1.equals(object2);
        }
    }

    protected class RecordEntryIterator
    implements Iterator {
        int index = 0;

        RecordEntryIterator() {
        }

        public boolean hasNext() {
            return this.index < AbstractRecord.this.size();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.index;
            return new RecordEntry(AbstractRecord.this.getFields().get(this.index - 1), AbstractRecord.this.getValues().get(this.index - 1));
        }

        public void remove() {
            if (this.index >= AbstractRecord.this.size()) {
                throw new IllegalStateException();
            }
            AbstractRecord.this.remove(AbstractRecord.this.getFields().get(this.index));
        }
    }

    protected class RecordKeyIterator
    extends RecordEntryIterator {
        protected RecordKeyIterator() {
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.index;
            return AbstractRecord.this.getFields().get(this.index - 1);
        }
    }

    protected class RecordValuesIterator
    extends RecordEntryIterator {
        protected RecordValuesIterator() {
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.index;
            return AbstractRecord.this.getValues().get(this.index - 1);
        }
    }

    protected class ValuesSet
    extends EntrySet {
        protected ValuesSet() {
        }

        public Iterator iterator() {
            return new RecordValuesIterator();
        }

        public boolean contains(Object object) {
            return AbstractRecord.this.contains(object);
        }

        public boolean remove(Object object) {
            int index = AbstractRecord.this.getValues().indexOf(object);
            if (index == -1) {
                return false;
            }
            AbstractRecord.this.remove(AbstractRecord.this.getFields().get(index));
            return true;
        }
    }
}

