/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.types;

import commonj.sdo.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.oxm.schema.XMLSchemaURLReference;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.SDOClassLoader;
import org.eclipse.persistence.sdo.helper.SDOMethodAttributeAccessor;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;
import org.eclipse.persistence.sdo.helper.extension.SDOUtil;
import org.eclipse.persistence.sessions.Project;

public class SDOWrapperType
extends SDOType
implements Type {
    private static final List EMPTY_LIST = new ArrayList(0);
    private String typeName;
    private Map<QName, XMLDescriptor> descriptorsMap;

    public SDOWrapperType(Type aPropertyType, String aTypeName, SDOTypeHelper aSDOTypeHelper) {
        this(aPropertyType, aTypeName, aSDOTypeHelper, (QName)null);
    }

    public SDOWrapperType(Type aPropertyType, String aTypeName, SDOTypeHelper aSDOTypeHelper, QName aSchemaType) {
        this(aPropertyType, aTypeName, aSDOTypeHelper, new QName[]{aSchemaType});
    }

    public SDOWrapperType(Type aPropertyType, String aTypeName, SDOTypeHelper aSDOTypeHelper, QName[] schemaTypes) {
        super("org.eclipse.persistence.sdo", aTypeName, aSDOTypeHelper);
        this.typeName = aTypeName;
        SDOProperty valueProperty = new SDOProperty(this.aHelperContext);
        valueProperty.setName("value");
        valueProperty.setType(aPropertyType);
        valueProperty.setXsdType(schemaTypes[0]);
        this.addDeclaredProperty(valueProperty);
        String normalizedTypeName = SDOUtil.className(aTypeName, true, true, false);
        String instanceClassName = "org.eclipse.persistence.sdo." + normalizedTypeName + "Wrapper";
        this.setInstanceClassName(instanceClassName);
        String implClassName = "org.eclipse.persistence.sdo." + normalizedTypeName + "WrapperImpl";
        this.setImplClassName(implClassName);
        this.getInstanceClass();
        this.getImplClass();
        this.xmlDescriptor.getInterfacePolicy().addParentInterface(this.getInstanceClass());
        this.initializeDescriptor(this.xmlDescriptor, schemaTypes[0], aPropertyType, valueProperty);
        this.descriptorsMap = new HashMap<QName, XMLDescriptor>();
        this.descriptorsMap.put(schemaTypes[0], this.xmlDescriptor);
        this.setSchemaContext(this.xmlDescriptor, schemaTypes[0]);
        if (schemaTypes.length > 1) {
            for (int i = 1; i < schemaTypes.length; ++i) {
                XMLDescriptor d = new XMLDescriptor();
                QName schemaType = schemaTypes[i];
                String className = "org.eclipse.persistence.sdo." + normalizedTypeName + "_" + schemaType.getLocalPart() + "Wrapper";
                try {
                    SDOClassLoader loader = ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).getLoader();
                    d.setJavaClass(loader.loadClass(className + "Impl", this));
                    d.getInterfacePolicy().addParentInterface(loader.loadClass(className, this));
                }
                catch (ClassNotFoundException e) {
                    throw SDOException.classNotFound((Exception)e, (String)this.getURI(), (String)this.getName());
                }
                catch (SecurityException e) {
                    throw SDOException.classNotFound((Exception)e, (String)this.getURI(), (String)this.getName());
                }
                this.initializeDescriptor(d, schemaType, aPropertyType, valueProperty);
                this.descriptorsMap.put(schemaTypes[i], d);
                this.setSchemaContext(d, schemaTypes[i]);
            }
        }
    }

    private void setSchemaContext(XMLDescriptor desc, QName schemaType) {
        if (schemaType == null || desc == null) {
            return;
        }
        XMLSchemaURLReference urlRef = new XMLSchemaURLReference();
        urlRef.setSchemaContextAsQName(schemaType);
        desc.setSchemaReference((XMLSchemaReference)urlRef);
    }

    private void initializeDescriptor(XMLDescriptor aDescriptor, QName aQName, Type aPropertyType, SDOProperty aValueProperty) {
        aDescriptor.setNamespaceResolver(null);
        XMLDirectMapping mapping = new XMLDirectMapping();
        mapping.setAttributeName("value");
        mapping.setXPath("text()");
        mapping.setAttributeClassification(aPropertyType.getInstanceClass());
        ((XMLField)mapping.getField()).setSchemaType(aQName);
        SDOMethodAttributeAccessor accessor = null;
        accessor = new SDOMethodAttributeAccessor(aValueProperty);
        mapping.setAttributeAccessor((AttributeAccessor)accessor);
        aDescriptor.addMapping((DatabaseMapping)mapping);
        aDescriptor.setIsWrapper(true);
    }

    public XMLDescriptor getXmlDescriptor(QName aQName) {
        XMLDescriptor d = this.descriptorsMap.get(aQName);
        if (d == null) {
            return this.xmlDescriptor;
        }
        return d;
    }

    public Map getDescriptorsMap() {
        return this.descriptorsMap;
    }

    public void addDescriptorToProject(Project project) {
        Iterator<XMLDescriptor> it = this.descriptorsMap.values().iterator();
        while (it.hasNext()) {
            project.addDescriptor((ClassDescriptor)it.next());
        }
    }

    public List getAliasNames() {
        return EMPTY_LIST;
    }

    public List getBaseTypes() {
        return EMPTY_LIST;
    }

    public String getName() {
        return this.typeName;
    }

    public String getURI() {
        return "org.eclipse.persistence.sdo";
    }

    public boolean isAbstract() {
        return false;
    }

    public boolean isDataType() {
        return false;
    }

    public boolean isOpen() {
        return false;
    }

    public boolean isSequenced() {
        return false;
    }

    public boolean isFinalized() {
        return true;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append(this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()));
        str.append("{uri=");
        str.append(this.getURI());
        str.append(" name=");
        str.append(this.getName());
        str.append("}");
        return str.toString();
    }
}

