/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.descriptors.CascadeLockingPolicy;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.indirection.ProxyIndirectionPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.mappings.Association;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.mappings.RelationalMapping;
import org.eclipse.persistence.mappings.foundation.MapKeyMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneToOneMapping
extends ObjectReferenceMapping
implements RelationalMapping,
MapKeyMapping {
    protected Map<DatabaseField, DatabaseField> sourceToTargetKeyFields;
    protected Map<DatabaseField, DatabaseField> targetToSourceKeyFields;
    protected boolean shouldVerifyDelete;
    protected transient Expression privateOwnedCriteria;

    public OneToOneMapping() {
        this.selectionQuery = new ReadObjectQuery();
        this.sourceToTargetKeyFields = new HashMap<DatabaseField, DatabaseField>(2);
        this.targetToSourceKeyFields = new HashMap<DatabaseField, DatabaseField>(2);
        this.foreignKeyFields = NonSynchronizedVector.newInstance(1);
        this.isForeignKeyRelationship = false;
        this.shouldVerifyDelete = true;
    }

    @Override
    public boolean isRelationalMapping() {
        return true;
    }

    public void addForeignKeyField(DatabaseField sourceForeignKeyField, DatabaseField targetPrimaryKeyField) {
        this.setIsForeignKeyRelationship(true);
        this.getForeignKeyFields().addElement(sourceForeignKeyField);
        this.getSourceToTargetKeyFields().put(sourceForeignKeyField, targetPrimaryKeyField);
        this.getTargetToSourceKeyFields().put(targetPrimaryKeyField, sourceForeignKeyField);
    }

    public void addForeignKeyFieldName(String sourceForeignKeyFieldName, String targetPrimaryKeyFieldName) {
        this.addForeignKeyField(new DatabaseField(sourceForeignKeyFieldName), new DatabaseField(targetPrimaryKeyFieldName));
    }

    public void addTargetForeignKeyField(DatabaseField targetForeignKeyField, DatabaseField sourcePrimaryKeyField) {
        this.getSourceToTargetKeyFields().put(sourcePrimaryKeyField, targetForeignKeyField);
        this.getTargetToSourceKeyFields().put(targetForeignKeyField, sourcePrimaryKeyField);
    }

    public void addTargetForeignKeyFieldName(String targetForeignKeyFieldName, String sourcePrimaryKeyFieldName) {
        this.addTargetForeignKeyField(new DatabaseField(targetForeignKeyFieldName), new DatabaseField(sourcePrimaryKeyFieldName));
    }

    @Override
    public Expression buildObjectJoinExpression(Expression expression, Object value, AbstractSession session) {
        Expression base = ((ObjectExpression)expression).getBaseExpression();
        Expression foreignKeyJoin = null;
        if (value == null) {
            if (!this.isForeignKeyRelationship()) {
                throw QueryException.cannotCompareTargetForeignKeysToNull(base, value, this);
            }
            for (DatabaseField field : this.getSourceToTargetKeyFields().keySet()) {
                Expression join = null;
                join = base.getField(field).equal(null);
                if (foreignKeyJoin == null) {
                    foreignKeyJoin = join;
                    continue;
                }
                foreignKeyJoin = foreignKeyJoin.and(join);
            }
        } else {
            if (!this.getReferenceDescriptor().getJavaClass().isInstance(value)) {
                value = ProxyIndirectionPolicy.getValueFromProxy(value);
                if (!this.getReferenceDescriptor().getJavaClass().isInstance(value)) {
                    throw QueryException.incorrectClassForObjectComparison(base, value, this);
                }
            }
            Enumeration keyEnum = this.extractKeyFromReferenceObject(value, session).elements();
            for (DatabaseField field : this.getSourceToTargetKeyFields().keySet()) {
                Expression join = null;
                join = base.getField(field).equal(keyEnum.nextElement());
                if (foreignKeyJoin == null) {
                    foreignKeyJoin = join;
                    continue;
                }
                foreignKeyJoin = foreignKeyJoin.and(join);
            }
        }
        return foreignKeyJoin;
    }

    @Override
    public Expression buildObjectJoinExpression(Expression expression, Expression argument, AbstractSession session) {
        Expression base = ((ObjectExpression)expression).getBaseExpression();
        Expression foreignKeyJoin = null;
        if (expression == argument) {
            for (DatabaseField field : this.getSourceToTargetKeyFields().keySet()) {
                Expression join = base.getField(field);
                join = join.equal(join);
                if (foreignKeyJoin == null) {
                    foreignKeyJoin = join;
                    continue;
                }
                foreignKeyJoin = foreignKeyJoin.and(join);
            }
        } else {
            Iterator<DatabaseField> targetFieldsEnum = this.getSourceToTargetKeyFields().values().iterator();
            for (DatabaseField sourceField : this.getSourceToTargetKeyFields().keySet()) {
                DatabaseField targetField = targetFieldsEnum.next();
                Expression join = null;
                join = base.getField(sourceField).equal(argument.getField(targetField));
                if (foreignKeyJoin == null) {
                    foreignKeyJoin = join;
                    continue;
                }
                foreignKeyJoin = foreignKeyJoin.and(join);
            }
        }
        return foreignKeyJoin;
    }

    @Override
    public Object clone() {
        DatabaseField sourceClone;
        DatabaseField targetClone;
        OneToOneMapping clone = (OneToOneMapping)super.clone();
        clone.setForeignKeyFields(NonSynchronizedVector.newInstance(this.getForeignKeyFields().size()));
        clone.setSourceToTargetKeyFields(new HashMap<DatabaseField, DatabaseField>(this.getSourceToTargetKeyFields().size()));
        clone.setTargetToSourceKeyFields(new HashMap<DatabaseField, DatabaseField>(this.getTargetToSourceKeyFields().size()));
        Hashtable<DatabaseField, DatabaseField> setOfFields = new Hashtable<DatabaseField, DatabaseField>(this.getTargetToSourceKeyFields().size());
        Enumeration<DatabaseField> enumtr = this.getForeignKeyFields().elements();
        while (enumtr.hasMoreElements()) {
            DatabaseField field = enumtr.nextElement();
            DatabaseField fieldClone = (DatabaseField)field.clone();
            setOfFields.put(field, fieldClone);
            clone.getForeignKeyFields().addElement(fieldClone);
        }
        for (DatabaseField sourceField : this.getSourceToTargetKeyFields().keySet()) {
            DatabaseField targetField = this.getSourceToTargetKeyFields().get(sourceField);
            targetClone = (DatabaseField)setOfFields.get(targetField);
            if (targetClone == null) {
                targetClone = (DatabaseField)targetField.clone();
                setOfFields.put(targetField, targetClone);
            }
            if ((sourceClone = (DatabaseField)setOfFields.get(sourceField)) == null) {
                sourceClone = (DatabaseField)sourceField.clone();
                setOfFields.put(sourceField, sourceClone);
            }
            clone.getSourceToTargetKeyFields().put(sourceClone, targetClone);
        }
        for (DatabaseField targetField : this.getTargetToSourceKeyFields().keySet()) {
            DatabaseField sourceField = this.getTargetToSourceKeyFields().get(targetField);
            targetClone = (DatabaseField)setOfFields.get(targetField);
            if (targetClone == null) {
                targetClone = (DatabaseField)targetField.clone();
                setOfFields.put(targetField, targetClone);
            }
            if ((sourceClone = (DatabaseField)setOfFields.get(sourceField)) == null) {
                sourceClone = (DatabaseField)sourceField.clone();
                setOfFields.put(sourceField, sourceClone);
            }
            clone.getTargetToSourceKeyFields().put(targetClone, sourceClone);
        }
        return clone;
    }

    protected Vector extractForeignKeyFromRow(AbstractRecord row, AbstractSession session) {
        Vector<Object> key = new Vector<Object>();
        for (DatabaseField field : this.getSourceToTargetKeyFields().keySet()) {
            Object value = row.get(field);
            try {
                value = session.getDatasourcePlatform().getConversionManager().convertObject(value, this.getDescriptor().getObjectBuilder().getFieldClassification(field));
            }
            catch (ConversionException e) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), e);
            }
            key.addElement(value);
        }
        return key;
    }

    protected Vector extractKeyFromReferenceObject(Object object, AbstractSession session) {
        Vector<Object> key = new Vector<Object>();
        for (DatabaseField field : this.getSourceToTargetKeyFields().values()) {
            if (object == null) {
                key.addElement(null);
                continue;
            }
            key.addElement(this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(object, field, session));
        }
        return key;
    }

    @Override
    public Vector extractPrimaryKeysForReferenceObjectFromRow(AbstractRecord row) {
        List<DatabaseField> primaryKeyFields = this.getReferenceDescriptor().getPrimaryKeyFields();
        Vector<Object> result = new Vector<Object>(primaryKeyFields.size());
        for (int index = 0; index < primaryKeyFields.size(); ++index) {
            DatabaseField targetKeyField = primaryKeyFields.get(index);
            DatabaseField sourceKeyField = this.getTargetToSourceKeyFields().get(targetKeyField);
            if (sourceKeyField == null) {
                return new Vector(1);
            }
            result.addElement(row.get(sourceKeyField));
        }
        return result;
    }

    @Override
    protected void postPrepareNestedBatchQuery(ReadQuery batchQuery, ReadAllQuery query) {
        if (!query.isDistinctComputed()) {
            ((ObjectLevelReadQuery)batchQuery).useDistinct();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object extractResultFromBatchQuery(DatabaseQuery query, AbstractRecord databaseRow, AbstractSession session, AbstractRecord argumentRow) {
        Hashtable<CacheKey, Object> referenceObjectsByKey = null;
        DatabaseQuery databaseQuery = query;
        synchronized (databaseQuery) {
            referenceObjectsByKey = this.getBatchReadObjects(query, session);
            if (referenceObjectsByKey == null) {
                Vector results = (Vector)session.executeQuery(query, argumentRow);
                referenceObjectsByKey = new Hashtable<CacheKey, Object>();
                Enumeration enumeration = results.elements();
                while (enumeration.hasMoreElements()) {
                    Object eachReferenceObject = enumeration.nextElement();
                    CacheKey eachReferenceKey = new CacheKey(this.extractKeyFromReferenceObject(eachReferenceObject, session));
                    referenceObjectsByKey.put(eachReferenceKey, session.wrapObject(eachReferenceObject));
                }
                this.setBatchReadObjects(referenceObjectsByKey, query, session);
            }
        }
        return referenceObjectsByKey.get(new CacheKey(this.extractForeignKeyFromRow(databaseRow, session)));
    }

    @Override
    public Class getFieldClassification(DatabaseField fieldToClassify) throws DescriptorException {
        DatabaseField fieldInTarget = this.getSourceToTargetKeyFields().get(fieldToClassify);
        if (fieldInTarget == null) {
            return null;
        }
        DatabaseMapping mapping = this.getReferenceDescriptor().getObjectBuilder().getMappingForField(fieldInTarget);
        if (mapping == null) {
            return null;
        }
        return mapping.getFieldClassification(fieldInTarget);
    }

    public Vector getForeignKeyFieldNames() {
        Vector<String> fieldNames = new Vector<String>(this.getForeignKeyFields().size());
        Enumeration<DatabaseField> fieldsEnum = this.getForeignKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            fieldNames.addElement(fieldsEnum.nextElement().getQualifiedName());
        }
        return fieldNames;
    }

    protected Map getForeignKeysToPrimaryKeys() {
        if (this.isForeignKeyRelationship()) {
            return this.getSourceToTargetKeyFields();
        }
        return this.getTargetToSourceKeyFields();
    }

    public Vector getOrderedForeignKeyFields() {
        List<DatabaseField> primaryKeyFields = this.getPrimaryKeyDescriptor().getPrimaryKeyFields();
        Vector<DatabaseField> result = new Vector<DatabaseField>(primaryKeyFields.size());
        for (int index = 0; index < primaryKeyFields.size(); ++index) {
            DatabaseField pkField = primaryKeyFields.get(index);
            boolean found = false;
            for (DatabaseField fkField : this.getForeignKeysToPrimaryKeys().keySet()) {
                if (!this.getForeignKeysToPrimaryKeys().get(fkField).equals(pkField)) continue;
                found = true;
                result.addElement(fkField);
                break;
            }
            if (found) continue;
            throw DescriptorException.missingForeignKeyTranslation(this, pkField);
        }
        return result;
    }

    protected ClassDescriptor getPrimaryKeyDescriptor() {
        if (this.isForeignKeyRelationship()) {
            return this.getReferenceDescriptor();
        }
        return this.getDescriptor();
    }

    public Expression getPrivateOwnedCriteria() {
        if (this.privateOwnedCriteria == null) {
            this.initializePrivateOwnedCriteria();
        }
        return this.privateOwnedCriteria;
    }

    public Vector getSourceToTargetKeyFieldAssociations() {
        Vector<Association> associations = new Vector<Association>(this.getSourceToTargetKeyFields().size());
        Iterator<DatabaseField> sourceFieldEnum = this.getSourceToTargetKeyFields().keySet().iterator();
        Iterator<DatabaseField> targetFieldEnum = this.getSourceToTargetKeyFields().values().iterator();
        while (sourceFieldEnum.hasNext()) {
            String fieldValue = sourceFieldEnum.next().getQualifiedName();
            String attributeValue = targetFieldEnum.next().getQualifiedName();
            associations.addElement(new Association(fieldValue, attributeValue));
        }
        return associations;
    }

    public Map<DatabaseField, DatabaseField> getSourceToTargetKeyFields() {
        return this.sourceToTargetKeyFields;
    }

    public Map<DatabaseField, DatabaseField> getTargetToSourceKeyFields() {
        return this.targetToSourceKeyFields;
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        for (int index = 0; index < this.getForeignKeyFields().size(); ++index) {
            DatabaseField foreignKeyField = this.getForeignKeyFields().get(index);
            foreignKeyField = this.getDescriptor().buildField(foreignKeyField);
            this.getForeignKeyFields().set(index, foreignKeyField);
        }
        if (!this.getTargetToSourceKeyFields().isEmpty() || !this.getSourceToTargetKeyFields().isEmpty()) {
            if (this.getTargetToSourceKeyFields().isEmpty() || this.getSourceToTargetKeyFields().isEmpty()) {
                this.initializeForeignKeysWithDefaults(session);
            } else {
                this.initializeForeignKeys(session);
            }
        }
        if (this.shouldInitializeSelectionCriteria()) {
            if (this.shouldForceInitializationOfSelectionCriteria()) {
                this.setSelectionCriteria(this.buildSelectionCriteria());
            } else {
                this.initializeSelectionCriteria(session);
            }
        } else {
            this.setShouldVerifyDelete(false);
        }
        this.setFields(this.collectFields());
        if (this.getReferenceDescriptor() != null && this.getReferenceDescriptor().hasTablePerClassPolicy()) {
            this.getReferenceDescriptor().getTablePerClassPolicy().prepareChildrenSelectionQuery(this, session);
        }
    }

    protected void initializeForeignKeys(AbstractSession session) {
        HashMap<DatabaseField, DatabaseField> newSourceToTargetKeyFields = new HashMap<DatabaseField, DatabaseField>(this.getSourceToTargetKeyFields().size());
        HashMap<DatabaseField, DatabaseField> newTargetToSourceKeyFields = new HashMap<DatabaseField, DatabaseField>(this.getTargetToSourceKeyFields().size());
        for (Map.Entry<DatabaseField, DatabaseField> entry : this.getSourceToTargetKeyFields().entrySet()) {
            DatabaseField sourceField = entry.getKey();
            sourceField = this.getDescriptor().buildField(sourceField);
            DatabaseField targetField = entry.getValue();
            targetField = this.getReferenceDescriptor().buildField(targetField);
            newSourceToTargetKeyFields.put(sourceField, targetField);
            newTargetToSourceKeyFields.put(targetField, sourceField);
        }
        this.setSourceToTargetKeyFields(newSourceToTargetKeyFields);
        this.setTargetToSourceKeyFields(newTargetToSourceKeyFields);
    }

    protected void initializeForeignKeysWithDefaults(AbstractSession session) {
        if (this.isForeignKeyRelationship()) {
            if (this.getSourceToTargetKeyFields().size() != 1) {
                throw DescriptorException.foreignKeysDefinedIncorrectly(this);
            }
            List<DatabaseField> targetKeys = this.getReferenceDescriptor().getPrimaryKeyFields();
            if (targetKeys.size() != 1) {
                throw DescriptorException.sizeMismatchOfForeignKeys(this);
            }
            DatabaseField sourceField = this.getSourceToTargetKeyFields().keySet().iterator().next();
            sourceField = this.getDescriptor().buildField(sourceField);
            this.getSourceToTargetKeyFields().clear();
            this.getTargetToSourceKeyFields().clear();
            this.getSourceToTargetKeyFields().put(sourceField, targetKeys.get(0));
            this.getTargetToSourceKeyFields().put(targetKeys.get(0), sourceField);
        } else {
            if (this.getTargetToSourceKeyFields().size() != 1) {
                throw DescriptorException.foreignKeysDefinedIncorrectly(this);
            }
            List<DatabaseField> sourceKeys = this.getDescriptor().getPrimaryKeyFields();
            if (sourceKeys.size() != 1) {
                throw DescriptorException.sizeMismatchOfForeignKeys(this);
            }
            DatabaseField targetField = this.getTargetToSourceKeyFields().keySet().iterator().next();
            targetField = this.getReferenceDescriptor().buildField(targetField);
            this.getSourceToTargetKeyFields().clear();
            this.getTargetToSourceKeyFields().clear();
            this.getTargetToSourceKeyFields().put(targetField, sourceKeys.get(0));
            this.getSourceToTargetKeyFields().put(sourceKeys.get(0), targetField);
        }
    }

    protected void initializePrivateOwnedCriteria() {
        if (!this.isForeignKeyRelationship()) {
            this.setPrivateOwnedCriteria(this.getSelectionCriteria());
        } else {
            Expression pkCriteria = this.getDescriptor().getObjectBuilder().getPrimaryKeyExpression();
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression backRef = builder.getManualQueryKey(this.getAttributeName() + "-back-ref", this.getDescriptor());
            Expression newPKCriteria = pkCriteria.rebuildOn(backRef);
            Expression twistedSelection = backRef.twist(this.getSelectionCriteria(), builder);
            if (this.getDescriptor().getQueryManager().getAdditionalJoinExpression() != null) {
                Expression rebuiltAdditional = this.getDescriptor().getQueryManager().getAdditionalJoinExpression().rebuildOn(backRef);
                twistedSelection = twistedSelection == null ? rebuiltAdditional : twistedSelection.and(rebuiltAdditional);
            }
            this.setPrivateOwnedCriteria(newPKCriteria.and(twistedSelection));
        }
    }

    protected void initializeSelectionCriteria(AbstractSession session) {
        if (this.getSourceToTargetKeyFields().isEmpty()) {
            throw DescriptorException.noForeignKeysAreSpecified(this);
        }
        ExpressionBuilder builder = new ExpressionBuilder();
        for (Map.Entry<DatabaseField, DatabaseField> entry : this.getSourceToTargetKeyFields().entrySet()) {
            DatabaseField foreignKey = entry.getKey();
            DatabaseField targetKey = entry.getValue();
            Expression expression = ((Expression)builder).getField(targetKey).equal(builder.getParameter(foreignKey));
            Expression criteria = expression.and(this.getSelectionCriteria());
            this.setSelectionCriteria(criteria);
        }
    }

    @Override
    public void prepareCascadeLockingPolicy() {
        CascadeLockingPolicy policy = new CascadeLockingPolicy(this.getDescriptor(), this.getReferenceDescriptor());
        policy.setQueryKeyFields(this.getSourceToTargetKeyFields(), !this.isForeignKeyRelationship());
        this.getReferenceDescriptor().addCascadeLockingPolicy(policy);
    }

    public Expression buildSelectionCriteria() {
        if (this.getSourceToTargetKeyFields().isEmpty()) {
            throw DescriptorException.noForeignKeysAreSpecified(this);
        }
        Expression criteria = null;
        ExpressionBuilder builder = new ExpressionBuilder();
        for (DatabaseField foreignKey : this.getSourceToTargetKeyFields().keySet()) {
            DatabaseField targetKey = this.getSourceToTargetKeyFields().get(foreignKey);
            Expression expression = ((Expression)builder).getField(targetKey).equal(builder.getParameter(foreignKey));
            if (criteria == null) {
                criteria = expression;
                continue;
            }
            criteria = expression.and(criteria);
        }
        return criteria;
    }

    @Override
    public void buildShallowOriginalFromRow(AbstractRecord databaseRow, Object original, JoinedAttributeManager joinManager, ObjectBuildingQuery query, AbstractSession executionSession) {
        ClassDescriptor descriptor = this.getReferenceDescriptor();
        DatabaseRecord targetRow = new DatabaseRecord();
        for (DatabaseField foreignKey : this.getSourceToTargetKeyFields().keySet()) {
            DatabaseField targetKey = this.getSourceToTargetKeyFields().get(foreignKey);
            targetRow.put(targetKey, databaseRow.get(foreignKey));
        }
        Object targetObject = descriptor.getObjectBuilder().buildNewInstance();
        descriptor.getObjectBuilder().buildAttributesIntoShallowObject(targetObject, databaseRow, query);
        targetObject = this.getIndirectionPolicy().valueFromRow(targetObject);
        this.setAttributeValueInObject(original, targetObject);
    }

    @Override
    public boolean isOneToOneMapping() {
        return true;
    }

    @Override
    protected Object readPrivateOwnedForObject(ObjectLevelModifyQuery modifyQuery) throws DatabaseException {
        if (modifyQuery.getSession().isUnitOfWork()) {
            return super.readPrivateOwnedForObject(modifyQuery);
        }
        if (!this.shouldVerifyDelete()) {
            return null;
        }
        ReadObjectQuery readQuery = (ReadObjectQuery)this.getSelectionQuery().clone();
        readQuery.setSelectionCriteria(this.getPrivateOwnedCriteria());
        return modifyQuery.getSession().executeQuery((DatabaseQuery)readQuery, modifyQuery.getTranslationRow());
    }

    @Override
    public void rehashFieldDependancies(AbstractSession session) {
        this.setSourceToTargetKeyFields(Helper.rehashMap(this.getSourceToTargetKeyFields()));
    }

    public void setForeignKeyFieldName(String sourceForeignKeyFieldName) {
        DatabaseField sourceField = new DatabaseField(sourceForeignKeyFieldName);
        this.setIsForeignKeyRelationship(true);
        this.getForeignKeyFields().addElement(sourceField);
        this.getSourceToTargetKeyFields().put(sourceField, new DatabaseField());
    }

    public void setForeignKeyFieldNames(Vector fieldNames) {
        NonSynchronizedVector fields = NonSynchronizedVector.newInstance(fieldNames.size());
        Enumeration fieldNamesEnum = fieldNames.elements();
        while (fieldNamesEnum.hasMoreElements()) {
            ((Vector)fields).addElement(new DatabaseField((String)fieldNamesEnum.nextElement()));
        }
        this.setForeignKeyFields(fields);
    }

    protected void setPrivateOwnedCriteria(Expression expression) {
        this.privateOwnedCriteria = expression;
    }

    public void setShouldVerifyDelete(boolean shouldVerifyDelete) {
        this.shouldVerifyDelete = shouldVerifyDelete;
    }

    public void setSourceToTargetKeyFieldAssociations(Vector sourceToTargetKeyFieldAssociations) {
        this.setSourceToTargetKeyFields(new HashMap<DatabaseField, DatabaseField>(sourceToTargetKeyFieldAssociations.size() + 1));
        this.setTargetToSourceKeyFields(new HashMap<DatabaseField, DatabaseField>(sourceToTargetKeyFieldAssociations.size() + 1));
        Enumeration associationsEnum = sourceToTargetKeyFieldAssociations.elements();
        while (associationsEnum.hasMoreElements()) {
            Association association = (Association)associationsEnum.nextElement();
            DatabaseField sourceField = new DatabaseField((String)association.getKey());
            DatabaseField targetField = new DatabaseField((String)association.getValue());
            this.getSourceToTargetKeyFields().put(sourceField, targetField);
            this.getTargetToSourceKeyFields().put(targetField, sourceField);
        }
    }

    public void setSourceToTargetKeyFields(Map<DatabaseField, DatabaseField> sourceToTargetKeyFields) {
        this.sourceToTargetKeyFields = sourceToTargetKeyFields;
    }

    public void setTargetForeignKeyFieldName(String targetForeignKeyFieldName) {
        DatabaseField targetField = new DatabaseField(targetForeignKeyFieldName);
        this.getTargetToSourceKeyFields().put(targetField, new DatabaseField());
    }

    public void setTargetToSourceKeyFields(Map<DatabaseField, DatabaseField> targetToSourceKeyFields) {
        this.targetToSourceKeyFields = targetToSourceKeyFields;
    }

    public boolean shouldVerifyDelete() {
        return this.shouldVerifyDelete;
    }

    @Override
    public boolean isCascadedLockingSupported() {
        return true;
    }

    @Override
    public boolean isJoiningSupported() {
        return true;
    }

    @Override
    public void writeFromAttributeIntoRow(Object attribute, AbstractRecord row, AbstractSession session) {
        Enumeration<DatabaseField> fieldsEnum = this.getForeignKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            DatabaseField sourceKey = fieldsEnum.nextElement();
            DatabaseField targetKey = this.getSourceToTargetKeyFields().get(sourceKey);
            Object referenceValue = null;
            if (attribute != null) {
                referenceValue = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(attribute, targetKey, session);
            }
            row.add(sourceKey, referenceValue);
        }
    }

    @Override
    public Object valueFromObject(Object object, DatabaseField field, AbstractSession session) {
        Object attributeValue = this.getAttributeValueFromObject(object);
        AbstractRecord referenceRow = this.indirectionPolicy.extractReferenceRow(attributeValue);
        if (referenceRow != null) {
            Object value = referenceRow.get(field);
            Class type = this.getFieldClassification(field);
            if (value == null || value.getClass() != type) {
                try {
                    value = session.getDatasourcePlatform().convertObject(value, type);
                }
                catch (ConversionException exception) {
                    throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), exception);
                }
            }
            return value;
        }
        Object referenceObject = this.getRealAttributeValueFromAttribute(attributeValue, object, session);
        if (referenceObject == null) {
            return null;
        }
        DatabaseField targetField = this.sourceToTargetKeyFields.get(field);
        return this.referenceDescriptor.getObjectBuilder().extractValueFromObjectForField(referenceObject, targetField, session);
    }

    @Override
    protected Object valueFromRowInternalWithJoin(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, AbstractSession executionSession) throws DatabaseException {
        Vector key;
        AbstractRecord targetRow = this.trimRowForJoin(row, joinManager, executionSession);
        if (joinManager != null && joinManager.hasOuterJoinedAttributeQuery() && !sourceQuery.hasPartialAttributeExpressions() && (key = this.referenceDescriptor.getObjectBuilder().extractPrimaryKeyFromRow(targetRow, executionSession)) == null) {
            return this.indirectionPolicy.nullValueFromRow();
        }
        ObjectLevelReadQuery nestedQuery = this.prepareNestedJoinQueryClone(row, null, joinManager, sourceQuery, executionSession);
        nestedQuery.setTranslationRow(targetRow);
        Object referenceObject = this.referenceDescriptor.getObjectBuilder().buildObject(nestedQuery, targetRow);
        if (nestedQuery.shouldUseWrapperPolicy() && executionSession.isUnitOfWork()) {
            referenceObject = this.referenceDescriptor.getObjectBuilder().wrapObject(referenceObject, executionSession);
        }
        return this.indirectionPolicy.valueFromRow(referenceObject);
    }

    @Override
    protected Object valueFromRowInternal(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, AbstractSession executionSession) throws DatabaseException {
        int size = this.fields.size();
        for (int index = 0; index < size; ++index) {
            DatabaseField field = (DatabaseField)this.fields.get(index);
            if (row.get(field) != null) continue;
            return this.indirectionPolicy.nullValueFromRow();
        }
        return super.valueFromRowInternal(row, joinManager, sourceQuery, executionSession);
    }

    @Override
    public void writeFromObjectIntoRow(Object object, AbstractRecord databaseRow, AbstractSession session) {
        if (this.isReadOnly || !this.isForeignKeyRelationship) {
            return;
        }
        Object attributeValue = this.getAttributeValueFromObject(object);
        AbstractRecord referenceRow = this.indirectionPolicy.extractReferenceRow(attributeValue);
        if (referenceRow == null) {
            Object referenceObject = this.getRealAttributeValueFromAttribute(attributeValue, object, session);
            Vector<DatabaseField> foreignKeyFields = this.getForeignKeyFields();
            int size = foreignKeyFields.size();
            for (int index = 0; index < size; ++index) {
                DatabaseField sourceKey = (DatabaseField)foreignKeyFields.get(index);
                Object referenceValue = null;
                if (referenceObject != null) {
                    DatabaseField targetKey = this.sourceToTargetKeyFields.get(sourceKey);
                    referenceValue = this.referenceDescriptor.getObjectBuilder().extractValueFromObjectForField(referenceObject, targetKey, session);
                }
                databaseRow.add(sourceKey, referenceValue);
            }
        } else {
            Vector<DatabaseField> foreignKeyFields = this.getForeignKeyFields();
            int size = foreignKeyFields.size();
            for (int index = 0; index < size; ++index) {
                DatabaseField sourceKey = (DatabaseField)foreignKeyFields.get(index);
                databaseRow.add(sourceKey, referenceRow.get(sourceKey));
            }
        }
    }

    @Override
    public void writeFromObjectIntoRowForShallowInsert(Object object, AbstractRecord databaseRow, AbstractSession session) {
        if (this.isReadOnly() || !this.isForeignKeyRelationship()) {
            return;
        }
        Enumeration<DatabaseField> fieldsEnum = this.getForeignKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            DatabaseField sourceKey = fieldsEnum.nextElement();
            databaseRow.add(sourceKey, null);
        }
    }

    @Override
    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, AbstractRecord databaseRow, AbstractSession session) {
        if (!this.isReadOnly && this.isPrimaryKeyMapping && !changeRecord.getOwner().isNew()) {
            throw ValidationException.primaryKeyUpdateDisallowed(changeRecord.getOwner().getClassName(), changeRecord.getAttribute());
        }
        Object object = ((ObjectChangeSet)changeRecord.getOwner()).getUnitOfWorkClone();
        this.writeFromObjectIntoRow(object, databaseRow, session);
    }

    @Override
    public void writeFromObjectIntoRowForShallowInsertWithChangeRecord(ChangeRecord ChangeRecord2, AbstractRecord databaseRow, AbstractSession session) {
        if (this.isReadOnly() || !this.isForeignKeyRelationship()) {
            return;
        }
        Enumeration<DatabaseField> fieldsEnum = this.getForeignKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            DatabaseField sourceKey = fieldsEnum.nextElement();
            databaseRow.add(sourceKey, null);
        }
    }

    @Override
    public void writeInsertFieldsIntoRow(AbstractRecord databaseRow, AbstractSession session) {
        if (this.isReadOnly() || !this.isForeignKeyRelationship()) {
            return;
        }
        Enumeration<DatabaseField> fieldsEnum = this.getForeignKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            DatabaseField sourceKey = fieldsEnum.nextElement();
            databaseRow.add(sourceKey, null);
        }
    }
}

