/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws;

import java.io.File;
import java.io.FileInputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.eclipse.persistence.tools.dbws.DBWSPackager;
import org.eclipse.persistence.tools.dbws.JarArchiver;
import org.eclipse.persistence.tools.dbws.ProviderPackager;
import org.eclipse.persistence.tools.dbws.Util;

public class JavasePackager
extends ProviderPackager {
    public JavasePackager() {
        this(new JavaseArchiver(), "javase", DBWSPackager.ArchiveUse.archive);
    }

    protected JavasePackager(DBWSPackager.Archiver archiver, String packagerLabel, DBWSPackager.ArchiveUse useJavaArchive) {
        super(archiver, packagerLabel, useJavaArchive);
    }

    @Override
    public DBWSPackager.Archiver buildDefaultArchiver() {
        return new JavaseArchiver(this);
    }

    @Override
    public String getWSDLPathPrefix() {
        return null;
    }

    static class JavaseArchiver
    extends JarArchiver {
        JavaseArchiver() {
        }

        JavaseArchiver(DBWSPackager packager) {
            super(packager);
        }

        @Override
        protected void addFilesToJarOutputStream(JarOutputStream jarOutputStream) {
            super.addFilesToJarOutputStream(jarOutputStream);
            try {
                jarOutputStream.putNextEntry(this.getDBWSProviderClassJarEntry());
                this.f = new File(this.packager.getStageDir(), "DBWSProvider.class");
                this.fis = new FileInputStream(this.f);
                int read = 0;
                while (read != -1) {
                    jarOutputStream.write(this.buffer, 0, read);
                    read = this.fis.read(this.buffer);
                }
                this.fis.close();
                this.f.deleteOnExit();
                jarOutputStream.putNextEntry(this.getWSDLJarEntry());
                this.f = new File(this.packager.getStageDir(), "eclipselink-dbws.wsdl");
                this.fis = new FileInputStream(this.f);
                read = 0;
                while (read != -1) {
                    jarOutputStream.write(this.buffer, 0, read);
                    read = this.fis.read(this.buffer);
                }
                this.fis.close();
                this.f.deleteOnExit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        protected JarEntry getSchemaJarEntry() {
            return new JarEntry(this.getWSDLPathPrefix() + "eclipselink-dbws-schema.xsd");
        }

        @Override
        protected JarEntry getSWARefJarEntry() {
            return new JarEntry(this.getWSDLPathPrefix() + Util.SWAREF_FILENAME);
        }

        ZipEntry getWSDLJarEntry() {
            return new JarEntry(this.getWSDLPathPrefix() + "eclipselink-dbws.wsdl");
        }

        ZipEntry getDBWSProviderClassJarEntry() {
            return new JarEntry("_dbws/DBWSProvider.class");
        }
    }
}

