/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork.writechanges;

import java.math.BigDecimal;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class WriteChangesFailed_TestCase
extends AutoVerifyTestCase {
    Exception exception;
    public BigDecimal id = null;

    public void setup() {
        this.id = new BigDecimal(1);
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Employee employee = new Employee();
        employee = (Employee)uow.registerObject((Object)employee);
        employee.setId(this.id);
        employee.setFirstName("Stephen");
        uow.commit();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        try {
            Employee employee = new Employee();
            employee = (Employee)uow.registerNewObject((Object)employee);
            employee.setId(this.id);
            employee.setFirstName("Andrew");
            try {
                uow.writeChanges();
            }
            catch (Exception e) {
                this.exception = e;
            }
            if (this.exception == null) {
                return;
            }
            if (((UnitOfWorkImpl)uow).getLifecycle() != 3) {
                throw new TestErrorException("Lifecycle state not set to WriteChangesFailed.  Instead it was: " + ((UnitOfWorkImpl)uow).getLifecycle());
            }
            try {
                uow.revertAndResume();
                throw new TestErrorException("Exception not thrown calling revertAndResume after writeChanges failed.");
            }
            catch (Exception expected) {
                if (!(expected instanceof ValidationException) || ((ValidationException)((Object)expected)).getErrorCode() != 7124) {
                    throw new TestErrorException("Exception not thrown calling revertAndResume after writeChanges.  Instead triggered other exception.", (Throwable)expected);
                }
                if (this.getAbstractSession().isInTransaction()) {
                    throw new TestErrorException("Should not be in transaction after a failed writeChanges.");
                }
                uow.release();
            }
        }
        finally {
            uow.release();
        }
    }

    public void verify() {
        if (this.exception == null) {
            throw new TestErrorException("Exception not thrown in writeChanges where UnitOfWork was trying to add a duplicate object.");
        }
    }

    public void reset() {
        if (this.id == null) {
            return;
        }
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Expression expression = new ExpressionBuilder().get("id").equal((Object)this.id);
        ReadObjectQuery query = new ReadObjectQuery(Employee.class, expression);
        Employee employee = (Employee)uow.executeQuery((DatabaseQuery)query);
        uow.deleteObject((Object)employee);
        uow.commit();
    }

    protected void resetVerify() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        Expression expression = new ExpressionBuilder().get("id").equal((Object)this.id);
        ReadObjectQuery query = new ReadObjectQuery(Employee.class, expression);
        Employee employee = (Employee)this.getSession().executeQuery((DatabaseQuery)query);
        this.id = null;
        if (employee != null) {
            throw new TestErrorException("Employee not removed after the test.");
        }
    }
}

