/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.util.Enumeration;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.EmploymentPeriod;

public class MergeUnitOfWorkTest
extends WriteObjectTest {
    public Object unitOfWorkWorkingCopy;
    public UnitOfWork unitOfWork;
    public Object objectBeforeMerge;

    public MergeUnitOfWorkTest() {
    }

    public MergeUnitOfWorkTest(Object originalObject) {
        super(originalObject);
    }

    protected void changeUnitOfWorkWorkingCopy() {
        Employee employee = (Employee)this.unitOfWorkWorkingCopy;
        Employee managedEmployee = (Employee)employee.getManagedEmployees().firstElement();
        Employee newEmployee = (Employee)this.unitOfWork.registerObject((Object)new Employee());
        newEmployee.setNormalHours(employee.getNormalHours());
        newEmployee.setPeriod((EmploymentPeriod)employee.getPeriod().clone());
        newEmployee.setAddress(managedEmployee.getAddress());
        newEmployee.setFirstName("New Man");
        newEmployee.setLastName("Smith");
        employee.addManagedEmployee(newEmployee);
        this.setObjectBeforeMerge(newEmployee);
    }

    protected void compareForProperMerge(Employee employeeBeforeMerge, Employee employeeAfterMerge) {
        if (employeeBeforeMerge.getAddress() == employeeAfterMerge.getAddress()) {
            throw new TestErrorException("The object '" + employeeAfterMerge + "'Was not merged properly. It is still referencing cloned address instead of original address");
        }
        if (employeeBeforeMerge.getPeriod() == employeeAfterMerge.getPeriod()) {
            throw new TestErrorException("The object '" + employeeAfterMerge + "'Was not merged properly. It is still referencing cloned Period instead of original Period");
        }
        if (employeeBeforeMerge.getNormalHours() == employeeAfterMerge.getNormalHours()) {
            throw new TestErrorException("The object '" + employeeAfterMerge + "'Was not merged properly. It is still referencing cloned NormalHours instead of original NormalHours");
        }
    }

    public void setObjectBeforeMerge(Object preMergeObject) {
        this.objectBeforeMerge = preMergeObject;
    }

    public void setup() {
        super.setup();
        this.unitOfWork = this.getSession().acquireUnitOfWork();
        this.unitOfWorkWorkingCopy = this.unitOfWork.registerObject(this.objectToBeWritten);
        this.changeUnitOfWorkWorkingCopy();
        if (!this.compareObjects(this.originalObject, this.objectToBeWritten)) {
            throw new TestErrorException("The original object was changed through changing the clone.");
        }
    }

    protected void test() {
        this.unitOfWork.commit();
    }

    protected void verify() {
        boolean found = false;
        Employee employeeToBeWritten = new Employee();
        Enumeration enumeration = ((Employee)this.objectToBeWritten).getManagedEmployees().elements();
        while (!found && enumeration.hasMoreElements()) {
            Employee employee = (Employee)enumeration.nextElement();
            if (employee.getFirstName() != "New Man") continue;
            employeeToBeWritten = employee;
            found = true;
        }
        this.compareForProperMerge((Employee)this.objectBeforeMerge, employeeToBeWritten);
    }
}

