/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.simultaneous;

import java.math.BigDecimal;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.unitofwork.ConcurrentLargeProject;
import org.eclipse.persistence.testing.tests.unitofwork.ConcurrentPerson;

public class ConcurrentReadOneToOneInheritanceTest
extends AutoVerifyTestCase {
    protected BigDecimal personId = null;
    protected BigDecimal projectId = null;
    protected ConcurrentPerson person = null;
    protected boolean deadlockDetected = false;

    public void setup() {
        this.deadlockDetected = false;
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.person = new ConcurrentPerson();
        this.person.name = "Wenger";
        ConcurrentLargeProject project = new ConcurrentLargeProject();
        project.setName("Football");
        this.person.setHobby(project);
        project.setSupervisor(this.person);
        uow.registerObject((Object)this.person);
        uow.registerObject((Object)project);
        uow.commit();
        uow.release();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.personId = this.person.id;
        this.projectId = project.getId();
    }

    public void test() {
        block4: {
            ConcurrentPerson.RUNNING_TEST = ConcurrentPerson.ONE_TO_ONE_INHERITANCE;
            Thread thread1 = new Thread(new PersonReader(this.getSession().acquireUnitOfWork(), this.personId));
            Thread thread2 = new Thread(new LargeProjectReader(this.getSession().acquireUnitOfWork(), this.projectId));
            thread1.start();
            thread2.start();
            try {
                thread1.join(30000L);
                if (!thread1.isAlive()) break block4;
                try {
                    thread1.interrupt();
                    thread2.interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.deadlockDetected = true;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void verify() {
        if (this.deadlockDetected) {
            throw new TestErrorException("Deadlock detected when reading a bidirectional 1-1 with Inheritance.");
        }
    }

    public void reset() {
        ConcurrentPerson.RUNNING_TEST = Integer.MIN_VALUE;
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.deleteObject((Object)this.person.getHobby());
        uow.deleteObject((Object)this.person);
        uow.commit();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public class PersonReader
    implements Runnable {
        private UnitOfWork uow;
        private BigDecimal id;

        public PersonReader(UnitOfWork uow, BigDecimal id) {
            this.uow = uow;
            this.id = id;
        }

        @Override
        public void run() {
            this.uow.readObject(ConcurrentPerson.class, new ExpressionBuilder().get("id").equal((Object)this.id));
        }
    }

    public class LargeProjectReader
    implements Runnable {
        private UnitOfWork uow;
        private BigDecimal id;

        public LargeProjectReader(UnitOfWork uow, BigDecimal id) {
            this.uow = uow;
            this.id = id;
        }

        @Override
        public void run() {
            this.uow.readObject(ConcurrentLargeProject.class, new ExpressionBuilder().get("id").equal((Object)this.id));
        }
    }
}

