/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessioncache;

import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class ReadObjectNotInSessionCacheTest
extends TestCase {
    private int oldLevel;

    public ReadObjectNotInSessionCacheTest() {
        this.setDescription("The test ensures we don't merge an object into the session cache when we dont need to.");
    }

    protected void setup() {
        this.checkNoWaitSupported();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.getAbstractSession().beginTransaction();
        this.oldLevel = this.getSession().getDescriptor(Employee.class).getUnitOfWorkCacheIsolationLevel();
        this.getSession().getDescriptor(Employee.class).setUnitOfWorkCacheIsolationLevel(4);
    }

    protected void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        ReadObjectQuery query = new ReadObjectQuery(Employee.class);
        query.setLockMode((short)2);
        Employee emp = (Employee)uow.executeQuery((DatabaseQuery)query);
        emp.setSalary(emp.getSalary() + 1);
        uow.commit();
    }

    protected void verify() {
        IdentityMap im = ((AbstractSession)this.getSession()).getIdentityMapAccessorInstance().getIdentityMap(Employee.class);
        if (im != null && im.getSize() > 0) {
            throw new TestErrorException("Employee read should not have been put into session cache.");
        }
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.getSession().getDescriptor(Employee.class).setUnitOfWorkCacheIsolationLevel(this.oldLevel);
    }
}

