/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessionbroker;

import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import junit.framework.Test;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.broker.SessionBroker;
import org.eclipse.persistence.sessions.remote.rmi.RMIConnection;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeSystem;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeTableCreator;
import org.eclipse.persistence.testing.tests.employee.EmployeeBasicTestModel;
import org.eclipse.persistence.testing.tests.queries.CursoredStreamTest;
import org.eclipse.persistence.testing.tests.queries.PredefinedInQueryReadAllTest;
import org.eclipse.persistence.testing.tests.queries.PredefinedQueryReadObjectTest;
import org.eclipse.persistence.testing.tests.remote.RemoteModel;
import org.eclipse.persistence.testing.tests.sessionbroker.EmployeeProject1;
import org.eclipse.persistence.testing.tests.sessionbroker.EmployeeProject2;
import org.eclipse.persistence.testing.tests.sessionbroker.RMIServerManagerController;
import org.eclipse.persistence.testing.tests.sessionbroker.RMISessionBrokerServerManager;
import org.eclipse.persistence.testing.tests.sessionbroker.SequnceSettingOnRemoteTest;
import org.eclipse.persistence.testing.tests.sessionbroker.Server;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;

public class RMISessionBrokerRemoteModel
extends RemoteModel {
    public Session oldSession;

    @Override
    public void addRequiredSystems() {
    }

    @Override
    public void addTests() {
        this.addTest((Test)RMISessionBrokerRemoteModel.getBasicReadTestSuite());
        this.addTest((Test)RMISessionBrokerRemoteModel.getFeatureTestSuite());
        this.addTest((Test)RMISessionBrokerRemoteModel.getSequencingTestSuite());
    }

    protected SessionBroker buildClientSessionBrokerAndPopulate() {
        SessionBroker sb = Server.buildServerBroker();
        sb.setLogLevel(this.getSession().getLogLevel());
        sb.setLog(this.getSession().getLog());
        sb.login();
        SessionBroker cb = sb.acquireClientSessionBroker();
        try {
            new EmployeeSystem().populate((DatabaseSession)cb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        cb.getIdentityMapAccessor().initializeAllIdentityMaps();
        return cb;
    }

    public static RMIConnection createConnection() {
        RMISessionBrokerServerManager serverManager = null;
        try {
            System.setSecurityManager(new RMISecurityManager());
        }
        catch (Exception exception) {
            System.out.println("Security violation " + exception.toString());
        }
        try {
            serverManager = (RMISessionBrokerServerManager)Naming.lookup("SERVER-BROKER-MANAGER");
        }
        catch (Exception exception) {
            throw new TestProblemException(exception.toString());
        }
        RMIConnection rmiConnection = null;
        try {
            rmiConnection = new RMIConnection(serverManager.createRemoteSessionController());
        }
        catch (RemoteException exception) {
            System.out.println("Error in invocation " + exception.toString());
        }
        return rmiConnection;
    }

    public void createTables() {
        SessionBroker broker = new SessionBroker();
        DatabaseSessionImpl session1 = new DatabaseSessionImpl((Login)Server.getLogin1());
        DatabaseSessionImpl session2 = new DatabaseSessionImpl((Login)Server.getLogin2());
        session1.addDescriptors((Project)new EmployeeProject1());
        session2.addDescriptors((Project)new EmployeeProject2());
        broker.registerSession("broker1", (Session)session1);
        broker.registerSession("broker2", (Session)session2);
        broker.setLogLevel(this.getSession().getLogLevel());
        broker.setLog(this.getSession().getLog());
        broker.login();
        ((ManyToManyMapping)session1.getDescriptor(Employee.class).getObjectBuilder().getMappingForAttributeName("projects")).setSessionName("broker2");
        ((OneToOneMapping)session1.getDescriptor(Employee.class).getObjectBuilder().getMappingForAttributeName("address")).setShouldVerifyDelete(false);
        EmployeeTableCreator tables = new EmployeeTableCreator();
        tables.replaceTables((DatabaseSession)session1);
        tables.replaceTables((DatabaseSession)session2);
        tables.dropConstraints((DatabaseSession)session1);
        tables.dropConstraints((DatabaseSession)session2);
        new SchemaManager((DatabaseSession)session1).createSequences();
        new SchemaManager((DatabaseSession)session2).createSequences();
        broker.logout();
    }

    public static TestSuite getBasicReadTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("BasicReadTestSuite");
        suite.setDescription("This suite tests the reading of objects remotely.");
        suite.addTest((Test)EmployeeBasicTestModel.getReadObjectTestSuite());
        suite.addTest((Test)EmployeeBasicTestModel.getReadAllTestSuite());
        return suite;
    }

    public static TestSuite getFeatureTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("FeatureTestSuite");
        suite.setDescription("This suite tests the features on the remote model.");
        suite.addTest((Test)new CursoredStreamTest(Employee.class, new ExpressionBuilder().get("firstName").equal((Object)"Bob")));
        suite.addTest((Test)new PredefinedQueryReadObjectTest(PopulationManager.getDefaultManager().getObject(Employee.class, "0001")));
        suite.addTest((Test)new PredefinedInQueryReadAllTest(Employee.class, 1));
        return suite;
    }

    public static TestSuite getSequencingTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("SequencingTestSuite");
        suite.setDescription("This suite tests the sequencing setting on the remote model.");
        suite.addTest((Test)new SequnceSettingOnRemoteTest());
        return suite;
    }

    @Override
    public void reset() {
        try {
            if (this.getExecutor().getSession() instanceof SessionBroker) {
                ((ClientSession)((SessionBroker)this.getExecutor().getSession()).getSessionForName("broker1")).getParent().logout();
                ((ClientSession)((SessionBroker)this.getExecutor().getSession()).getSessionForName("broker2")).getParent().logout();
            }
        }
        finally {
            this.getExecutor().setSession(this.oldSession);
        }
    }

    @Override
    public void setup() {
        this.createTables();
        this.oldSession = this.getSession();
        SessionBroker broker = this.buildClientSessionBrokerAndPopulate();
        RemoteModel.setServerSession((Session)broker);
        RMIServerManagerController.start((Session)broker);
        RMIConnection connection = RMISessionBrokerRemoteModel.createConnection();
        Session remoteSession = connection.createRemoteSession();
        remoteSession.setLogLevel(this.oldSession.getLogLevel());
        remoteSession.setLog(this.oldSession.getLog());
        this.getExecutor().setSession(remoteSession);
    }
}

