/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.Vector;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.sessions.DataRecord;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.queries.OrderingTest;

public class OrderingByExpressionTest
extends OrderingTest {
    @Override
    protected void setup() {
        this.customSQLRows = this.getSession().executeSelectingCall((Call)new SQLCall("SELECT * FROM EMPLOYEE t1, ADDRESS t2 WHERE t1.ADDR_ID = t2.ADDRESS_ID ORDER BY CITY DESC, STREET"));
    }

    @Override
    public void test() {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Employee.class);
        query.addOrdering(query.getExpressionBuilder().get("address").get("city").descending());
        query.addOrdering(query.getExpressionBuilder().get("address").get("street"));
        this.orderedQueryObjects = (Vector)this.getSession().executeQuery((DatabaseQuery)query);
    }

    @Override
    protected void verify() {
        for (int i = 0; i < this.orderedQueryObjects.size(); ++i) {
            DataRecord row = (DataRecord)this.customSQLRows.elementAt(i);
            Employee employee = (Employee)this.orderedQueryObjects.elementAt(i);
            String city = (String)row.get((Object)"CITY");
            String street = (String)row.get((Object)"STREET");
            if (employee.getAddress().getCity().equals(city) && employee.getAddress().getStreet().equals(street)) continue;
            throw new TestErrorException("The ordering test failed.  The results are not in the right order");
        }
    }
}

