/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.optimization.queryandsqlcounting;

import java.util.Vector;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.optimization.queryandsqlcounting.QuerySQLTracker;

public class BatchReadingValueholderInstantiationTest
extends TestCase {
    protected QuerySQLTracker tracker = null;
    protected int initialSQLStatements = 0;
    protected int postIndirectionTriggerSQLStatements = 0;
    protected int postSecondQuerySQLStatements = 0;
    protected int initialQueries = 0;
    protected int postIndirectionTriggerQueries = 0;
    protected int postSecondQueryQueries = 0;
    public static final int EXPECTED_INITIAL_STATEMENTS = 1;
    public static final int EXPECTED_INDIRECTION_STATEMENTS = 2;
    public static final int EXPECTED_SECOND_QUERY_STATEMENTS = 3;
    public static final int EXPECTED_INITIAL_QUERIES = 1;
    public static final int EXPECTED_INDIRECTION_QUERIES = 2;
    public static final int EXPECTED_SECOND_QUERY_QUERIES = 3;

    public BatchReadingValueholderInstantiationTest() {
        this.setDescription("Ensure the proper SQL statements are generated with batch reading when valueholders are triggered.");
    }

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.tracker = new QuerySQLTracker(this.getSession());
    }

    public void test() {
        Employee m;
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        query.addBatchReadAttribute("manager");
        Vector emps = (Vector)this.getSession().executeQuery((DatabaseQuery)query);
        this.initialSQLStatements = this.tracker.getSqlStatements().size();
        this.initialQueries = this.tracker.getQueries().size();
        for (Employee e : emps) {
            m = (Employee)e.getManager();
            if (m == null) continue;
            m.hashCode();
        }
        this.postIndirectionTriggerSQLStatements = this.tracker.getSqlStatements().size();
        this.postIndirectionTriggerQueries = this.tracker.getQueries().size();
        emps = (Vector)this.getSession().executeQuery((DatabaseQuery)query);
        for (Employee e : emps) {
            m = (Employee)e.getManager();
            if (m == null) continue;
            m.hashCode();
        }
        this.postSecondQuerySQLStatements = this.tracker.getSqlStatements().size();
        this.postSecondQueryQueries = this.tracker.getQueries().size();
    }

    public void verify() {
        if (this.initialSQLStatements > 1) {
            throw new TestErrorException("A ReadAllQuery with batching executed an incorrect number of SQL Statements.  expected: 1 got: " + this.initialSQLStatements);
        }
        if (this.postIndirectionTriggerSQLStatements > 2) {
            throw new TestErrorException("Triggering indirection on a batch read attribute executed the incorrect number of SQL statements.  expected: 1 got: " + (this.postIndirectionTriggerSQLStatements - 1));
        }
        if (this.postSecondQuerySQLStatements > 3) {
            throw new TestErrorException("Rerunning a ReadAllQuery with batch and triggering indirection executed the incorrect number of SQL statements.  expected: 1 got: " + (this.postSecondQuerySQLStatements - 2));
        }
        if (this.initialQueries > 1) {
            throw new TestErrorException("A ReadAllQuery with batching executed an incorrect number of Queries.  expected: 1 got: " + this.initialQueries);
        }
        if (this.postIndirectionTriggerQueries > 2) {
            throw new TestErrorException("Triggering indirection on a batch read attribute executed the incorrect number of Queries.  expected: 1 got: " + (this.postIndirectionTriggerQueries - 1));
        }
        if (this.postSecondQueryQueries > 3) {
            throw new TestErrorException("Rerunning a ReadAllQuery with batch and triggering indirection executed the incorrect number of Queries.  expected: 1 got: " + (this.postSecondQueryQueries - 2));
        }
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.tracker.remove();
    }
}

