/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.optimisticlocking;

import java.util.Vector;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.optimisticlocking.Guitar;
import org.eclipse.persistence.testing.models.optimisticlocking.RockBand;
import org.eclipse.persistence.testing.models.optimisticlocking.RockMusician;

public class OptimisticLockingPolicyDeleteRowTest
extends AutoVerifyTestCase {
    protected Object originalObject;
    protected Class<?> testClass;

    public OptimisticLockingPolicyDeleteRowTest(Class<?> aClass) {
        this.setDescription("This test verifies that an optimistic lock exception is thrown when underlying database row is delete");
        this.testClass = aClass;
    }

    protected void guitarSetup() {
        Guitar guitar = Guitar.example1();
        guitar.make = "new";
        this.getDatabaseSession().writeObject((Object)guitar);
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.originalObject = this.getSession().readObject((Object)guitar);
    }

    public void guitarTest() {
        this.getSession().executeNonSelectingCall((Call)new SQLCall("DELETE FROM MUSICALINSTRUMENT WHERE ID = " + ((Guitar)this.originalObject).id));
        this.getSession().executeNonSelectingCall((Call)new SQLCall("DELETE FROM GUITAR WHERE ID = " + ((Guitar)this.originalObject).id));
    }

    public void reset() {
        this.rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    protected void rockBandSetup() {
        RockBand band = RockBand.example1();
        band.setBandMembers(new Vector());
        this.getDatabaseSession().writeObject((Object)band);
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.originalObject = this.getSession().readObject((Object)band);
    }

    public void rockBandTest() {
        this.getSession().executeNonSelectingCall((Call)new SQLCall("DELETE FROM ROCKBAND WHERE ID = " + ((RockBand)this.originalObject).id));
    }

    protected void rockMusicianSetup() {
        RockMusician guy = RockMusician.example1();
        guy.band = new ValueHolder();
        guy.mainInstrument = null;
        this.getDatabaseSession().writeObject((Object)guy);
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.originalObject = this.getSession().readObject((Object)guy);
    }

    public void rockMusicianTest() {
        this.getSession().executeNonSelectingCall((Call)new SQLCall("DELETE FROM ROCKMUSICIAN WHERE ID = " + ((RockMusician)this.originalObject).id));
    }

    protected void setup() {
        this.beginTransaction();
        if (this.testClass.equals(Guitar.class)) {
            this.guitarSetup();
        }
        if (this.testClass.equals(RockBand.class)) {
            this.rockBandSetup();
        }
        if (this.testClass.equals(RockMusician.class)) {
            this.rockMusicianSetup();
        }
    }

    public void test() {
        if (this.testClass.equals(Guitar.class)) {
            this.guitarTest();
        }
        if (this.testClass.equals(RockBand.class)) {
            this.rockBandTest();
        }
        if (this.testClass.equals(RockMusician.class)) {
            this.rockMusicianTest();
        }
    }

    protected void verify() {
        boolean exceptionCaught = false;
        try {
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            uow.deleteObject(uow.registerObject(this.originalObject));
            uow.commit();
        }
        catch (OptimisticLockException exception) {
            exceptionCaught = true;
        }
        if (!exceptionCaught) {
            throw new TestErrorException("No Optimistic Lock exception was thrown");
        }
    }
}

