/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.inheritance;

import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.inheritance.BaseProject;
import org.eclipse.persistence.testing.models.inheritance.BudgettedProject;

public class UnitOfWorkIdentityMapAccessorTest
extends AutoVerifyTestCase {
    private UnitOfWork unitOfWork;
    private BaseProject baseProject;
    private Object result;

    protected void setup() {
        DatabaseSession session = (DatabaseSession)this.getSession();
        UnitOfWork uow = session.acquireUnitOfWork();
        this.baseProject = new BaseProject();
        this.baseProject.setName("Bob");
        uow.registerNewObject((Object)this.baseProject);
        uow.commit();
    }

    protected void test() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.unitOfWork = this.getSession().acquireUnitOfWork();
        ReadObjectQuery query = new ReadObjectQuery(BaseProject.class);
        query.setShouldRefreshIdentityMapResult(true);
        this.unitOfWork.getParent().executeQuery((DatabaseQuery)query);
        this.result = this.unitOfWork.getIdentityMapAccessor().getFromIdentityMap((Object)this.baseProject.getId(), BudgettedProject.class);
    }

    protected void verify() {
        try {
            if (this.result != null && !(this.result instanceof BudgettedProject)) {
                throw new TestErrorException("The object fetched from identity map accessor belong to different subclass " + this.result.getClass().getName());
            }
        }
        catch (DatabaseException exception) {
            if (this.getSession().getPlatform().isDBase()) {
                throw new TestWarningException("This fails because of some strange bug in the DBase driver. " + exception.getMessage());
            }
            throw exception;
        }
        finally {
            this.unitOfWork.release();
        }
    }

    public void reset() {
        DatabaseSession session = (DatabaseSession)this.getSession();
        UnitOfWork uow = session.acquireUnitOfWork();
        uow.deleteObject((Object)this.baseProject);
        uow.commit();
        this.unitOfWork = null;
        this.result = null;
        this.baseProject = null;
    }
}

