/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.feature;

import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.platform.database.OraclePlatform;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DefaultConnector;
import org.eclipse.persistence.sessions.DirectConnector;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.feature.DatabaseLoginWrapper;

public class DatabaseLoginCodeCoverageTest
extends AutoVerifyTestCase {
    private DatabaseLogin login;
    private String testFailures;

    public void setup() {
        this.login = new DatabaseLogin();
        this.testFailures = "";
    }

    public void test() {
        this.runTests();
    }

    public void verify() {
        if (this.testFailures.length() > 0) {
            throw new TestErrorException("Tests failures from DatabaseLogin: " + this.testFailures);
        }
    }

    private void addToTestFailures(String fail) {
        this.testFailures = this.testFailures + "\n - " + fail;
    }

    public void runTests() {
        DatabaseLoginWrapper dbWrapper;
        this.login.bindAllParameters();
        if (!this.login.getShouldBindAllParameters()) {
            this.addToTestFailures("bindAllParameters");
        }
        this.login.dontBindAllParameters();
        if (this.login.getShouldBindAllParameters()) {
            this.addToTestFailures("dontBindAllParameters");
        }
        this.login.cacheAllStatements();
        if (!this.login.getShouldCacheAllStatements()) {
            this.addToTestFailures("cacheAllStatements");
        }
        this.login.dontCacheAllStatements();
        if (this.login.getShouldCacheAllStatements()) {
            this.addToTestFailures("dontCacheAllStatements");
        }
        this.login.optimizeDataConversion();
        if (!this.login.getShouldOptimizeDataConversion()) {
            this.addToTestFailures("optimizeDataConversion");
        }
        this.login.dontOptimizeDataConversion();
        if (this.login.getShouldOptimizeDataConversion()) {
            this.addToTestFailures("dontOptimizeDataConversion");
        }
        this.login.useBatchWriting();
        if (!this.login.shouldUseBatchWriting()) {
            this.addToTestFailures("useBatchWriting");
        }
        this.login.dontUseBatchWriting();
        if (this.login.shouldUseBatchWriting()) {
            this.addToTestFailures("dontUseBatchWriting");
        }
        this.login.useByteArrayBinding();
        if (!this.login.shouldUseByteArrayBinding()) {
            this.addToTestFailures("useByteArrayBinding");
        }
        this.login.dontUseByteArrayBinding();
        if (this.login.shouldUseByteArrayBinding()) {
            this.addToTestFailures("dontUseByteArrayBinding");
        }
        this.login.useExternalConnectionPooling();
        if (!this.login.shouldUseExternalConnectionPooling()) {
            this.addToTestFailures("useExternalConnectionPooling");
        }
        this.login.dontUseExternalConnectionPooling();
        if (this.login.shouldUseExternalConnectionPooling()) {
            this.addToTestFailures("dontUseExternalConnectionPooling");
        }
        this.login.useJDBCBatchWriting();
        if (!this.login.shouldUseJDBCBatchWriting()) {
            this.addToTestFailures("useJDBCBatchWriting");
        }
        this.login.dontUseJDBCBatchWriting();
        if (this.login.shouldUseJDBCBatchWriting()) {
            this.addToTestFailures("dontUseJDBCBatchWriting");
        }
        this.login.useNativeSequencing();
        if (!this.login.shouldUseNativeSequencing()) {
            this.addToTestFailures("useNativeSequencing");
        }
        this.login.useNativeSQL();
        if (!this.login.shouldUseNativeSQL()) {
            this.addToTestFailures("useNativeSQL");
        }
        this.login.dontUseNativeSQL();
        if (this.login.shouldUseNativeSQL()) {
            this.addToTestFailures("dontUseNativeSQL");
        }
        this.login.useStreamsForBinding();
        if (!this.login.shouldUseStreamsForBinding()) {
            this.addToTestFailures("useStreamsForBinding");
        }
        this.login.dontUseStreamsForBinding();
        if (this.login.shouldUseStreamsForBinding()) {
            this.addToTestFailures("dontUseStreamsForBinding");
        }
        this.login.useStringBinding();
        if (!this.login.shouldUseStringBinding()) {
            this.addToTestFailures("useStringBinding");
        }
        this.login.dontUseStringBinding();
        if (this.login.shouldUseStringBinding()) {
            this.addToTestFailures("dontUseStringBinding");
        }
        this.login.setMaxBatchWritingSize(1492);
        if (this.login.getMaxBatchWritingSize() != 1492) {
            this.addToTestFailures("maxBatchWritingSize");
        }
        this.login.setProperty("aProperty", (Object)"junk");
        if (this.login.getProperty("aProperty") != "junk") {
            this.addToTestFailures("property");
        }
        this.login.setStatementCacheSize(1492);
        if (this.login.getStatementCacheSize() != 1492) {
            this.addToTestFailures("statementCacheSize");
        }
        this.login.setStringBindingSize(1492);
        if (this.login.getStringBindingSize() != 1492) {
            this.addToTestFailures("stringBindingSize");
        }
        this.login.setTransactionIsolation(2);
        if (this.login.getTransactionIsolation() != 2) {
            this.addToTestFailures("transactionIsolation");
        }
        this.login.dontUseByteArrayBinding();
        if (this.login.shouldUseByteArrayBinding()) {
            this.addToTestFailures("dontUseBinding");
        }
        this.login.dontUseExternalConnectionPooling();
        if (this.login.shouldUseExternalConnectionPooling()) {
            this.addToTestFailures("dontUseExternalConnectionPooling");
        }
        this.login.setDriverClassName("oracle.jdbc.OracleDriver");
        if (!this.login.getDriverClassName().equals("oracle.jdbc.OracleDriver")) {
            this.addToTestFailures("driverClassName");
        }
        this.login.useCloudscapeDriver();
        if (!this.login.isCloudscapeJDBCDriver()) {
            this.addToTestFailures("cloudscapeJDBCDriver");
        }
        this.login.useDB2JDBCDriver();
        if (!this.login.isDB2JDBCDriver()) {
            this.addToTestFailures("DB2JDBCDriver");
        }
        this.login.useIntersolvSequeLinkDriver();
        if (!this.login.isIntersolvSequeLinkDriver()) {
            this.addToTestFailures("intersolvSequeLinkDriver");
        }
        this.login.useJConnectDriver();
        if (!this.login.isJConnectDriver()) {
            this.addToTestFailures("JConnectDriver");
        }
        this.login.useJDBCConnectDriver();
        if (!this.login.isJDBCConnectDriver()) {
            this.addToTestFailures("JDBCConnectDriver");
        }
        this.login.useJDBCConnectRemoteDriver();
        if (!this.login.isJDBCConnectRemoteDriver()) {
            this.addToTestFailures("JDBCConnectRemoteDriver");
        }
        this.login.useOracle7JDBCDriver();
        if (!this.login.isOracle7JDBCDriver()) {
            this.addToTestFailures("oracle7JDBCDriver");
        }
        this.login.useOracleJDBCDriver();
        if (!this.login.isOracleJDBCDriver()) {
            this.addToTestFailures("oracleJDBCDriver()");
        }
        this.login.useOracleServerJDBCDriver();
        if (!this.login.isOracleServerJDBCDriver()) {
            this.addToTestFailures("oracleServerJDBCDriver");
        }
        this.login.useOracleThinJDBCDriver();
        if (!this.login.isOracleThinJDBCDriver()) {
            this.addToTestFailures("oracleThinJDBCDriver");
        }
        this.login.useWebLogicOracleOCIDriver();
        if (!this.login.isWebLogicOracleOCIDriver()) {
            this.addToTestFailures("webLogicOracleOCIDriver");
        }
        this.login.useWebLogicSQLServerDBLibDriver();
        if (!this.login.isWebLogicSQLServerDBLibDriver()) {
            this.addToTestFailures("webLogicSQLServerDBLibDriver");
        }
        this.login.useWebLogicSQLServerDriver();
        if (!this.login.isWebLogicSQLServerDriver()) {
            this.addToTestFailures("weblogicSQLServerDriver");
        }
        this.login.useWebLogicSybaseDBLibDriver();
        if (!this.login.isWebLogicSybaseDBLibDriver()) {
            this.addToTestFailures("webLogicSybaseDBLibDriver");
        }
        this.login.useWebLogicThinClientDriver();
        if (!this.login.isWebLogicThinClientDriver()) {
            this.addToTestFailures("weblogicThinClientDriver");
        }
        this.login.useWebLogicThinDriver();
        if (!this.login.isWebLogicThinDriver()) {
            this.addToTestFailures("webLogicThinDriver");
        }
        this.login.useAccess();
        if (!this.login.getPlatform().isAccess()) {
            this.addToTestFailures("useAccess");
        }
        this.login.useDBase();
        if (!this.login.getPlatform().isDBase()) {
            this.addToTestFailures("useDBase");
        }
        this.login.useInformix();
        if (!this.login.getPlatform().isInformix()) {
            this.addToTestFailures("useInformix");
        }
        this.login.useJDBCODBCBridge();
        if (!this.login.isJDBCODBCBridge()) {
            this.addToTestFailures("JDBCODBCBridge");
        }
        this.login.useWebLogicJDBCConnectionPool("martinsPool");
        if (this.login.getConnectionString().indexOf("martinsPool") == -1) {
            this.addToTestFailures("useWebLogicJDBCConnectionPool");
        }
        this.login.useWebLogicDriverCursoredOutputCode();
        if (this.login.getCursorCode() != 1111) {
            this.addToTestFailures("useWeblogicDriverCursoredOutputCode");
        }
        this.login.useDirectDriverConnect();
        if (this.login.getConnector() == null || !(this.login.getConnector() instanceof DirectConnector)) {
            this.addToTestFailures("useDirectDriverConnect()");
        }
        this.login.useSymfoware();
        if (!this.login.getPlatform().isSymfoware()) {
            this.addToTestFailures("useSymfoware");
        }
        this.login.useDirectDriverConnect("myDriverClassName", "myDriverURLHeader", "myDatabaseURL");
        DefaultConnector connector = (DefaultConnector)this.login.getConnector();
        if (connector == null) {
            this.addToTestFailures("useDirectDriverConnect() == null");
        } else {
            if (!connector.getDriverClassName().equals("myDriverClassName")) {
                this.addToTestFailures("useDirectDriverConnect() - driverClassName wrong ");
            }
            if (!connector.getDriverURLHeader().equals("myDriverURLHeader")) {
                this.addToTestFailures("useDirectDriverConnect() - driverURLHeader wrong");
            }
            if (!connector.getDatabaseURL().equals("myDatabaseURL")) {
                this.addToTestFailures("useDirectDriverConnect() - databaseURL wrong");
            }
        }
        this.login.setUsesNativeSQL(false);
        if (this.login.getUsesNativeSQL()) {
            this.addToTestFailures("usesNativeSQL");
        }
        this.login.setUsesStringBinding(false);
        if (this.login.getUsesStringBinding()) {
            this.addToTestFailures("usesStringBinding");
        }
        this.login.setUsesStreamsForBinding(false);
        if (this.login.getUsesStreamsForBinding()) {
            this.addToTestFailures("usesStreamsForBinding");
        }
        this.login.setProperty("completelyUseless", (Object)"evenMoreUseless");
        if (!this.login.getProperty("completelyUseless").equals("evenMoreUseless")) {
            this.addToTestFailures("setProperty");
        }
        this.login.removeProperty("completelyUseless");
        if (this.login.getProperty("completelyUseless") != null) {
            this.addToTestFailures("removeProperty");
        }
        if ((dbWrapper = new DatabaseLoginWrapper()).driverIs("complete.non.existent.moronic.driver.class")) {
            this.addToTestFailures("driverIs (true when should be false)");
        }
        dbWrapper.useDB2NetJDBCDriver();
        if (!dbWrapper.driverIs("COM.ibm.db2.jdbc.net.DB2Driver")) {
            this.addToTestFailures("DB2NetJDBCDriver");
        }
        dbWrapper.useHSQLDriver();
        if (!dbWrapper.driverIs("org.hsqldb.jdbcDriver")) {
            this.addToTestFailures("HSQLDriver");
        }
        dbWrapper.useINetSQLServerDriver();
        if (!dbWrapper.driverIs("com.inet.tds.TdsDriver")) {
            this.addToTestFailures("INetSQLServerDriver");
        }
        dbWrapper.useJConnect50Driver();
        if (!dbWrapper.driverIs("com.sybase.jdbc2.jdbc.SybDriver")) {
            this.addToTestFailures("JConnect50Driver");
        }
        dbWrapper.usePointBaseDriver();
        if (!dbWrapper.driverIs("com.pointbase.jdbc.jdbcUniversalDriver")) {
            this.addToTestFailures("PointBaseDriver");
        }
        dbWrapper.useOracleJDBCDriver();
        if (!dbWrapper.oracleDriverIs("oci8")) {
            this.addToTestFailures("oracleDriverIs");
        }
        this.login.setCacheTransactionIsolation(9);
        if (this.login.getCacheTransactionIsolation() != 9) {
            this.addToTestFailures("cacheTransactionIsolation");
        }
        this.login.setCursorCode(9);
        if (this.login.getCursorCode() != 9) {
            this.addToTestFailures("cursorCode");
        }
        this.login.setODBCDataSourceName("fakeDataSourceName");
        if (!this.login.getDataSourceName().equals("fakeDataSourceName")) {
            this.addToTestFailures("dataSourceName");
        }
        this.login.setShouldTrimStrings(false);
        if (this.login.getShouldTrimStrings()) {
            this.addToTestFailures("getShouldTrimStrings");
        }
        this.login.setDatabaseName("oneCompleteLie");
        if (!this.login.getDatabaseName().equals("oneCompleteLie")) {
            this.addToTestFailures("databaseName");
        }
        if (this.login.toString().indexOf("oneCompleteLie") == -1) {
            this.addToTestFailures("databaseName - toString failed");
        }
        this.login.setServerName("homer");
        if (!this.login.getServerName().equals("homer")) {
            this.addToTestFailures("serverName");
        }
        if (this.login.toString().indexOf("homer") == -1) {
            this.addToTestFailures("serverName - toString failed");
        }
        DatabaseLogin.setShouldIgnoreCaseOnFieldComparisons((boolean)false);
        if (DatabaseLogin.shouldIgnoreCaseOnFieldComparisons()) {
            this.addToTestFailures("shouldIgnoreCaseOnFieldComparisons");
        }
        this.login.setTableQualifier("tableQualifier");
        if (!this.login.getTableQualifier().equals("tableQualifier")) {
            this.addToTestFailures("tableQualifier");
        }
        this.login.setEncryptionClassName("class.does.not.exist");
        boolean didNotCatchException = true;
        try {
            this.login.setPassword("password");
        }
        catch (ValidationException e) {
            didNotCatchException = false;
        }
        if (didNotCatchException) {
            this.addToTestFailures("encryptionClassName should have thrown an exception");
        }
        this.login.setEncryptionClassName(null);
        this.login.setPassword(null);
        if (this.login.getPassword() != null) {
            this.addToTestFailures("setPassword to null, did not remove it from the properties");
        }
        org.eclipse.persistence.platform.database.DatabasePlatform originalPlatform = this.login.getPlatform();
        DatabasePlatform platform = new DatabasePlatform();
        String defaultSeqTableName = platform.getSequenceTableName();
        String newSeqTableName = defaultSeqTableName.concat("_NEW");
        platform.setSequenceTableName(newSeqTableName);
        this.login.setPlatform((Platform)platform);
        this.login.usePlatform((org.eclipse.persistence.platform.database.DatabasePlatform)new OraclePlatform());
        String name = this.login.getPlatform().getSequenceTableName();
        if (!name.equals(newSeqTableName)) {
            this.addToTestFailures("usePlatform() method hasn't copied SequenceTableName from the existing DatabasePlatform");
        }
        this.login.setPlatform((Platform)originalPlatform);
        originalPlatform = this.login.getPlatform();
        this.login.setPlatform(null);
        didNotCatchException = true;
        try {
            this.login.usePlatform((Platform)new DatabasePlatform());
        }
        catch (NullPointerException e) {
            didNotCatchException = false;
        }
        if (!didNotCatchException) {
            this.addToTestFailures("usePlatform() method throws a NullPointerException when there is no platform in the login");
        }
        this.login.setPlatform((Platform)originalPlatform);
        originalPlatform = this.login.getPlatform();
        platform = new DatabasePlatform();
        defaultSeqTableName = platform.getSequenceTableName();
        newSeqTableName = defaultSeqTableName.concat("_NEW");
        platform.setSequenceTableName(newSeqTableName);
        this.login.setPlatform((Platform)platform);
        this.login.setPlatformClassName("org.eclipse.persistence.platform.database.OraclePlatform");
        name = this.login.getPlatform().getSequenceTableName();
        if (!name.equals(newSeqTableName)) {
            this.addToTestFailures("setPlatformClassName() method hasn't copied settings from the existing platform");
        }
        this.login.setPlatform((Platform)originalPlatform);
        didNotCatchException = true;
        try {
            this.login.setPlatformClassName("one.big.dumb.platform");
        }
        catch (ValidationException e) {
            didNotCatchException = false;
        }
        if (didNotCatchException) {
            this.addToTestFailures("setting false platform name didn't throw an exception");
        }
        didNotCatchException = true;
        try {
            DatabaseLoginWrapper wrap = new DatabaseLoginWrapper();
            wrap.getStupidConnector();
        }
        catch (ValidationException e) {
            didNotCatchException = false;
        }
        if (didNotCatchException) {
            this.addToTestFailures("did not catch validation exception on invalid database connector");
        }
    }
}

