/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.expressions;

import java.util.Arrays;
import java.util.Vector;
import junit.framework.Test;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.UnitTestCase;
import org.eclipse.persistence.testing.tests.expressions.ExpressionTestSuite;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class ExpressionOperatorUnitTestSuite
extends ExpressionTestSuite {
    public ExpressionOperatorUnitTestSuite() {
        this.setDescription("This suite tests ExpressionOperator.");
    }

    public void _testEquals$nullTest() {
        Object operator2;
        ExpressionOperator operator = Expression.getOperator((int)15);
        if (operator.equals(operator2 = null)) {
            throw new TestErrorException("Equals() must handle null case.");
        }
    }

    public void _testEquals$ObjectTest() {
        Integer operator2;
        ExpressionOperator operator = Expression.getOperator((int)15);
        if (operator.equals((Object)(operator2 = Integer.valueOf(5)))) {
            throw new TestErrorException("Equals() must handle other class case.");
        }
    }

    public void _testEqualsTest() {
        ExpressionOperator operator2;
        ExpressionOperator operator = Expression.getOperator((int)15);
        if (!operator.equals((Object)(operator2 = new ExpressionOperator(15, new Vector())))) {
            throw new TestErrorException("Equals() must do comparison by selector only.");
        }
    }

    public void _testEqualsArrayTest() {
        Vector<String> dbStrings = new Vector<String>();
        dbStrings.add("one");
        dbStrings.add("two");
        ExpressionOperator operator1 = new ExpressionOperator(0, dbStrings);
        ExpressionOperator operator2 = new ExpressionOperator(0, dbStrings);
        if (!operator1.equals((Object)operator2)) {
            throw new TestErrorException("Equals() must do comparison by database strings.");
        }
    }

    public void _testIsComparisonOperatorTest() {
        ExpressionOperator operator = Expression.getOperator((int)15);
        if (!operator.isComparisonOperator()) {
            throw new TestErrorException("IsComparisonOperator() invalid.");
        }
    }

    public void _testIsFunctionOperatorTest() {
        ExpressionOperator operator = Expression.getOperator((int)3);
        if (!operator.isFunctionOperator()) {
            throw new TestErrorException("IsFunctionOperator() invalid.");
        }
    }

    public void _testIsLogicalOperatorTest() {
        ExpressionOperator operator = Expression.getOperator((int)1);
        if (!operator.isLogicalOperator()) {
            throw new TestErrorException("IsLogicalOperator() invalid.");
        }
    }

    public void _testDefaultCaseOperatorDatabaseStringsTest() {
        ExpressionOperator caseOp = ExpressionOperator.caseStatement();
        Object[] databaseStrings = caseOp.getDatabaseStrings(0);
        Object[] expectedStrings = new String[]{"CASE ", " END"};
        if (!Arrays.equals(expectedStrings, databaseStrings)) {
            throw new TestErrorException("Expected " + Arrays.toString(expectedStrings) + " but was " + Arrays.toString(databaseStrings));
        }
        databaseStrings = caseOp.getDatabaseStrings(1);
        expectedStrings = new String[]{"CASE ", " END"};
        if (!Arrays.equals(expectedStrings, databaseStrings)) {
            throw new TestErrorException("Expected " + Arrays.toString(expectedStrings) + " but was " + Arrays.toString(databaseStrings));
        }
        databaseStrings = caseOp.getDatabaseStrings(2);
        expectedStrings = new String[]{"CASE ", " ELSE ", " END"};
        if (!Arrays.equals(expectedStrings, databaseStrings)) {
            throw new TestErrorException("Expected " + Arrays.toString(expectedStrings) + " but was " + Arrays.toString(databaseStrings));
        }
        databaseStrings = caseOp.getDatabaseStrings(3);
        expectedStrings = new String[]{"CASE ", " WHEN ", " THEN ", " END"};
        if (!Arrays.equals(expectedStrings, databaseStrings)) {
            throw new TestErrorException("Expected " + Arrays.toString(expectedStrings) + " but was " + Arrays.toString(databaseStrings));
        }
        databaseStrings = caseOp.getDatabaseStrings(4);
        expectedStrings = new String[]{"CASE ", " WHEN ", " THEN ", " ELSE ", " END"};
        if (!Arrays.equals(expectedStrings, databaseStrings)) {
            throw new TestErrorException("Expected " + Arrays.toString(expectedStrings) + " but was " + Arrays.toString(databaseStrings));
        }
        databaseStrings = caseOp.getDatabaseStrings(5);
        expectedStrings = new String[]{"CASE ", " WHEN ", " THEN ", " WHEN ", " THEN ", " END"};
        if (!Arrays.equals(expectedStrings, databaseStrings)) {
            throw new TestErrorException("Expected " + Arrays.toString(expectedStrings) + " but was " + Arrays.toString(databaseStrings));
        }
        databaseStrings = caseOp.getDatabaseStrings(6);
        expectedStrings = new String[]{"CASE ", " WHEN ", " THEN ", " WHEN ", " THEN ", " ELSE ", " END"};
        if (!Arrays.equals(expectedStrings, databaseStrings)) {
            throw new TestErrorException("Expected " + Arrays.toString(expectedStrings) + " but was " + Arrays.toString(databaseStrings));
        }
    }

    public void _testDefaultCaseConditionOperatorDatabaseStringsTest() {
        ExpressionOperator caseConditionOp = ExpressionOperator.caseConditionStatement();
        Object[] databaseStrings = caseConditionOp.getDatabaseStrings(0);
        Object[] expectedStrings = new String[]{"CASE WHEN ", " END "};
        if (!Arrays.equals(expectedStrings, databaseStrings)) {
            throw new TestErrorException("Expected " + Arrays.toString(expectedStrings) + " but was " + Arrays.toString(databaseStrings));
        }
        databaseStrings = caseConditionOp.getDatabaseStrings(1);
        expectedStrings = new String[]{"CASE WHEN ", " END "};
        if (!Arrays.equals(expectedStrings, databaseStrings)) {
            throw new TestErrorException("Expected " + Arrays.toString(expectedStrings) + " but was " + Arrays.toString(databaseStrings));
        }
        databaseStrings = caseConditionOp.getDatabaseStrings(2);
        expectedStrings = new String[]{"CASE WHEN ", " THEN ", " END "};
        if (!Arrays.equals(expectedStrings, databaseStrings)) {
            throw new TestErrorException("Expected " + Arrays.toString(expectedStrings) + " but was " + Arrays.toString(databaseStrings));
        }
        databaseStrings = caseConditionOp.getDatabaseStrings(3);
        expectedStrings = new String[]{"CASE WHEN ", " THEN ", " ELSE ", " END "};
        if (!Arrays.equals(expectedStrings, databaseStrings)) {
            throw new TestErrorException("Expected " + Arrays.toString(expectedStrings) + " but was " + Arrays.toString(databaseStrings));
        }
        databaseStrings = caseConditionOp.getDatabaseStrings(4);
        expectedStrings = new String[]{"CASE WHEN ", " THEN ", " WHEN ", " THEN ", " END "};
        if (!Arrays.equals(expectedStrings, databaseStrings)) {
            throw new TestErrorException("Expected " + Arrays.toString(expectedStrings) + " but was " + Arrays.toString(databaseStrings));
        }
        databaseStrings = caseConditionOp.getDatabaseStrings(5);
        expectedStrings = new String[]{"CASE WHEN ", " THEN ", " WHEN ", " THEN ", " ELSE ", " END "};
        if (!Arrays.equals(expectedStrings, databaseStrings)) {
            throw new TestErrorException("Expected " + Arrays.toString(expectedStrings) + " but was " + Arrays.toString(databaseStrings));
        }
        databaseStrings = caseConditionOp.getDatabaseStrings(6);
        expectedStrings = new String[]{"CASE WHEN ", " THEN ", " WHEN ", " THEN ", " WHEN ", " THEN ", " END "};
        if (!Arrays.equals(expectedStrings, databaseStrings)) {
            throw new TestErrorException("Expected " + Arrays.toString(expectedStrings) + " but was " + Arrays.toString(databaseStrings));
        }
    }

    public void _testDefaultCoalesceOperatorDatabaseStringsTest() {
        ExpressionOperator coalesceOp = ExpressionOperator.coalesce();
        Object[] databaseStrings = coalesceOp.getDatabaseStrings(0);
        Object[] expectedStrings = new String[]{"COALESCE(", ")"};
        if (!Arrays.equals(expectedStrings, databaseStrings)) {
            throw new TestErrorException("Expected " + Arrays.toString(expectedStrings) + " but was " + Arrays.toString(databaseStrings));
        }
        databaseStrings = coalesceOp.getDatabaseStrings(1);
        expectedStrings = new String[]{"COALESCE(", ")"};
        if (!Arrays.equals(expectedStrings, databaseStrings)) {
            throw new TestErrorException("Expected " + Arrays.toString(expectedStrings) + " but was " + Arrays.toString(databaseStrings));
        }
        databaseStrings = coalesceOp.getDatabaseStrings(2);
        expectedStrings = new String[]{"COALESCE(", ", ", ")"};
        if (!Arrays.equals(expectedStrings, databaseStrings)) {
            throw new TestErrorException("Expected " + Arrays.toString(expectedStrings) + " but was " + Arrays.toString(databaseStrings));
        }
        databaseStrings = coalesceOp.getDatabaseStrings(3);
        expectedStrings = new String[]{"COALESCE(", ", ", ", ", ")"};
        if (!Arrays.equals(expectedStrings, databaseStrings)) {
            throw new TestErrorException("Expected " + Arrays.toString(expectedStrings) + " but was " + Arrays.toString(databaseStrings));
        }
        databaseStrings = coalesceOp.getDatabaseStrings(4);
        expectedStrings = new String[]{"COALESCE(", ", ", ", ", ", ", ")"};
        if (!Arrays.equals(expectedStrings, databaseStrings)) {
            throw new TestErrorException("Expected " + Arrays.toString(expectedStrings) + " but was " + Arrays.toString(databaseStrings));
        }
        databaseStrings = coalesceOp.getDatabaseStrings(5);
        expectedStrings = new String[]{"COALESCE(", ", ", ", ", ", ", ", ", ")"};
        if (!Arrays.equals(expectedStrings, databaseStrings)) {
            throw new TestErrorException("Expected " + Arrays.toString(expectedStrings) + " but was " + Arrays.toString(databaseStrings));
        }
    }

    @Override
    public void addTests() {
        this.setManager(PopulationManager.getDefaultManager());
        this.addTest((Test)new UnitTestCase("Equals$nullTest"));
        this.addTest((Test)new UnitTestCase("Equals$ObjectTest"));
        this.addTest((Test)new UnitTestCase("EqualsTest"));
        this.addTest((Test)new UnitTestCase("EqualsArrayTest"));
        this.addTest((Test)new UnitTestCase("IsComparisonOperatorTest"));
        this.addTest((Test)new UnitTestCase("IsFunctionOperatorTest"));
        this.addTest((Test)new UnitTestCase("IsLogicalOperatorTest"));
        this.addTest((Test)new UnitTestCase("DefaultCaseOperatorDatabaseStringsTest"));
        this.addTest((Test)new UnitTestCase("DefaultCaseConditionOperatorDatabaseStringsTest"));
        this.addTest((Test)new UnitTestCase("DefaultCoalesceOperatorDatabaseStringsTest"));
    }
}

