/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.performance;

import java.io.Serializable;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.persistence.testing.models.performance.Address;
import org.eclipse.persistence.testing.models.performance.EmploymentPeriod;
import org.eclipse.persistence.testing.models.performance.PhoneNumber;
import org.eclipse.persistence.testing.models.performance.Project;

public class Employee
implements Serializable {
    protected long id;
    protected long version;
    protected String firstName = "";
    protected String lastName = "";
    protected String gender;
    protected EmploymentPeriod period;
    protected Address address;
    protected Employee manager;
    protected Collection managedEmployees = new HashSet();
    protected Collection phoneNumbers;
    public Collection projects = new HashSet();
    protected int salary;

    public Employee() {
        this.phoneNumbers = new HashSet();
    }

    public void addManagedEmployee(Employee employee) {
        this.getManagedEmployees().add(employee);
        employee.setManager(this);
    }

    public void addPhoneNumber(PhoneNumber phoneNumber) {
        this.getPhoneNumbers().add(phoneNumber);
        phoneNumber.setOwner(this);
    }

    public void addProject(Project project) {
        this.getProjects().add(project);
    }

    public Address getAddress() {
        return this.address;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getGender() {
        return this.gender;
    }

    public long getId() {
        return this.id;
    }

    public String getLastName() {
        return this.lastName;
    }

    public Collection getManagedEmployees() {
        return this.managedEmployees;
    }

    public Employee getManager() {
        return this.manager;
    }

    public EmploymentPeriod getPeriod() {
        return this.period;
    }

    public Collection getPhoneNumbers() {
        return this.phoneNumbers;
    }

    public Collection getProjects() {
        return this.projects;
    }

    public int getSalary() {
        return this.salary;
    }

    public long getVersion() {
        return this.version;
    }

    public void removeManagedEmployee(Employee employee) {
        this.getManagedEmployees().remove(employee);
        employee.setManager(null);
    }

    public void removePhoneNumber(PhoneNumber phoneNumber) {
        this.getPhoneNumbers().remove(phoneNumber);
    }

    public void removeProject(Project project) {
        this.getProjects().remove(project);
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public void setFemale() {
        this.setGender("Female");
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setMale() {
        this.setGender("Male");
    }

    public void setManagedEmployees(Collection managedEmployees) {
        this.managedEmployees = managedEmployees;
    }

    public void setManager(Employee manager) {
        this.manager = manager;
    }

    public void setPeriod(EmploymentPeriod period) {
        this.period = period;
    }

    public void setPhoneNumbers(Collection phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
    }

    public void setProjects(Collection projects) {
        this.projects = projects;
    }

    public void setSalary(int salary) {
        this.salary = salary;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write("Employee: ");
        writer.write(this.getFirstName());
        writer.write(" ");
        writer.write(this.getLastName());
        return writer.toString();
    }
}

