/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.insurance;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.models.insurance.Address;
import org.eclipse.persistence.testing.models.insurance.BicyclePolicy;
import org.eclipse.persistence.testing.models.insurance.Claim;
import org.eclipse.persistence.testing.models.insurance.HealthClaim;
import org.eclipse.persistence.testing.models.insurance.HealthPolicy;
import org.eclipse.persistence.testing.models.insurance.HouseClaim;
import org.eclipse.persistence.testing.models.insurance.HousePolicy;
import org.eclipse.persistence.testing.models.insurance.InsuranceSystem;
import org.eclipse.persistence.testing.models.insurance.Phone;
import org.eclipse.persistence.testing.models.insurance.Policy;
import org.eclipse.persistence.testing.models.insurance.PolicyHolder;
import org.eclipse.persistence.testing.models.insurance.VehicleClaim;
import org.eclipse.persistence.testing.models.insurance.VehiclePolicy;

public class InsuranceProject
extends Project {
    public InsuranceProject() {
        this.setName("Insurance");
        this.applyLogin();
        this.addDescriptor((ClassDescriptor)this.buildAddressDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildClaimDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildHealthClaimDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildHealthPolicyDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildHouseClaimDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildHousePolicyDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildPhoneDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildPolicyDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildPolicyHolderDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildVehicleClaimDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildVehiclePolicyDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildBicyclePolicyDescriptor());
    }

    public void applyLogin() {
        DatabaseLogin login = new DatabaseLogin();
        this.setLogin(login);
    }

    public RelationalDescriptor buildAddressDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Address.class);
        descriptor.addTableName("INS_ADDR");
        descriptor.addPrimaryKeyFieldName("INS_ADDR.SSN");
        DirectToFieldMapping cityMapping = new DirectToFieldMapping();
        cityMapping.setAttributeName("city");
        cityMapping.setGetMethodName("getCity");
        cityMapping.setSetMethodName("setCity");
        cityMapping.setFieldName("INS_ADDR.CITY");
        descriptor.addMapping((DatabaseMapping)cityMapping);
        DirectToFieldMapping countryMapping = new DirectToFieldMapping();
        countryMapping.setAttributeName("country");
        countryMapping.setGetMethodName("getCountry");
        countryMapping.setSetMethodName("setCountry");
        countryMapping.setFieldName("INS_ADDR.COUNTRY");
        descriptor.addMapping((DatabaseMapping)countryMapping);
        DirectToFieldMapping stateMapping = new DirectToFieldMapping();
        stateMapping.setAttributeName("state");
        stateMapping.setGetMethodName("getState");
        stateMapping.setSetMethodName("setState");
        stateMapping.setFieldName("INS_ADDR.STATE");
        descriptor.addMapping((DatabaseMapping)stateMapping);
        DirectToFieldMapping streetMapping = new DirectToFieldMapping();
        streetMapping.setAttributeName("street");
        streetMapping.setGetMethodName("getStreet");
        streetMapping.setSetMethodName("setStreet");
        streetMapping.setFieldName("INS_ADDR.STREET");
        descriptor.addMapping((DatabaseMapping)streetMapping);
        DirectToFieldMapping zipCodeMapping = new DirectToFieldMapping();
        zipCodeMapping.setAttributeName("zipCode");
        zipCodeMapping.setGetMethodName("getZipCode");
        zipCodeMapping.setSetMethodName("setZipCode");
        zipCodeMapping.setFieldName("INS_ADDR.ZIPCODE");
        descriptor.addMapping((DatabaseMapping)zipCodeMapping);
        OneToOneMapping policyHolderMapping = new OneToOneMapping();
        policyHolderMapping.setAttributeName("policyHolder");
        policyHolderMapping.setGetMethodName("getPolicyHolder");
        policyHolderMapping.setSetMethodName("setPolicyHolder");
        policyHolderMapping.setReferenceClass(PolicyHolder.class);
        policyHolderMapping.dontUseIndirection();
        policyHolderMapping.addForeignKeyFieldName("INS_ADDR.SSN", "HOLDER.SSN");
        descriptor.addMapping((DatabaseMapping)policyHolderMapping);
        return descriptor;
    }

    public RelationalDescriptor buildClaimDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Claim.class);
        descriptor.addTableName("CLAIM");
        descriptor.addPrimaryKeyFieldName("CLAIM.CLM_ID");
        descriptor.getDescriptorInheritancePolicy().setClassIndicatorFieldName("CLAIM.CLM_TYPE");
        descriptor.getDescriptorInheritancePolicy().addClassIndicator(HealthClaim.class, (Object)"E");
        descriptor.getDescriptorInheritancePolicy().addClassIndicator(VehicleClaim.class, (Object)"V");
        descriptor.getDescriptorInheritancePolicy().addClassIndicator(HouseClaim.class, (Object)"H");
        DirectToFieldMapping amountMapping = new DirectToFieldMapping();
        amountMapping.setAttributeName("amount");
        amountMapping.setGetMethodName("getAmount");
        amountMapping.setSetMethodName("setAmount");
        amountMapping.setFieldName("CLAIM.AMOUNT");
        descriptor.addMapping((DatabaseMapping)amountMapping);
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setGetMethodName("getId");
        idMapping.setSetMethodName("setId");
        idMapping.setFieldName("CLAIM.CLM_ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        OneToOneMapping policyMapping = new OneToOneMapping();
        policyMapping.setAttributeName("policy");
        policyMapping.setGetMethodName("getPolicy");
        policyMapping.setSetMethodName("setPolicy");
        policyMapping.setReferenceClass(Policy.class);
        policyMapping.dontUseIndirection();
        policyMapping.addForeignKeyFieldName("CLAIM.POL_ID", "POLICY.POL_ID");
        descriptor.addMapping((DatabaseMapping)policyMapping);
        return descriptor;
    }

    public RelationalDescriptor buildHealthClaimDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(HealthClaim.class);
        descriptor.addTableName("CLAIM");
        descriptor.getDescriptorInheritancePolicy().setParentClass(Claim.class);
        descriptor.getDescriptorQueryManager().checkDatabaseForDoesExist();
        DirectToFieldMapping diseaseMapping = new DirectToFieldMapping();
        diseaseMapping.setAttributeName("disease");
        diseaseMapping.setGetMethodName("getDisease");
        diseaseMapping.setSetMethodName("setDisease");
        diseaseMapping.setFieldName("CLAIM.DISEASE");
        descriptor.addMapping((DatabaseMapping)diseaseMapping);
        return descriptor;
    }

    public RelationalDescriptor buildHealthPolicyDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(HealthPolicy.class);
        descriptor.addTableName("POLICY");
        descriptor.getDescriptorInheritancePolicy().setParentClass(Policy.class);
        descriptor.getDescriptorQueryManager().checkDatabaseForDoesExist();
        DirectToFieldMapping coverageRateMapping = new DirectToFieldMapping();
        coverageRateMapping.setAttributeName("coverageRate");
        coverageRateMapping.setGetMethodName("getCoverageRate");
        coverageRateMapping.setSetMethodName("setCoverageRate");
        coverageRateMapping.setFieldName("POLICY.COV_RATE");
        descriptor.addMapping((DatabaseMapping)coverageRateMapping);
        return descriptor;
    }

    public RelationalDescriptor buildHouseClaimDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(HouseClaim.class);
        descriptor.addTableName("CLAIM");
        descriptor.getDescriptorInheritancePolicy().setParentClass(Claim.class);
        descriptor.getDescriptorQueryManager().checkDatabaseForDoesExist();
        DirectToFieldMapping areaMapping = new DirectToFieldMapping();
        areaMapping.setAttributeName("area");
        areaMapping.setGetMethodName("getArea");
        areaMapping.setSetMethodName("setArea");
        areaMapping.setFieldName("CLAIM.AREA");
        descriptor.addMapping((DatabaseMapping)areaMapping);
        return descriptor;
    }

    public RelationalDescriptor buildHousePolicyDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(HousePolicy.class);
        descriptor.addTableName("POLICY");
        descriptor.getDescriptorInheritancePolicy().setParentClass(Policy.class);
        descriptor.getDescriptorQueryManager().checkDatabaseForDoesExist();
        DirectToFieldMapping dateOfConstructionMapping = new DirectToFieldMapping();
        dateOfConstructionMapping.setAttributeName("dateOfConstruction");
        dateOfConstructionMapping.setGetMethodName("getDateOfConstruction");
        dateOfConstructionMapping.setSetMethodName("setDateOfConstruction");
        dateOfConstructionMapping.setFieldName("POLICY.CNST_DTE");
        descriptor.addMapping((DatabaseMapping)dateOfConstructionMapping);
        return descriptor;
    }

    public RelationalDescriptor buildPhoneDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Phone.class);
        descriptor.addTableName("INS_PHONE");
        descriptor.addPrimaryKeyFieldName("INS_PHONE.HOLDER_SSN");
        descriptor.addPrimaryKeyFieldName("INS_PHONE.TYPE");
        descriptor.setAmendmentClass(InsuranceSystem.class);
        descriptor.setAmendmentMethodName("modifyPhoneDescriptor");
        DirectToFieldMapping areaCodeMapping = new DirectToFieldMapping();
        areaCodeMapping.setAttributeName("areaCode");
        areaCodeMapping.setGetMethodName("getAreaCode");
        areaCodeMapping.setSetMethodName("setAreaCode");
        areaCodeMapping.setFieldName("INS_PHONE.AREACODE");
        descriptor.addMapping((DatabaseMapping)areaCodeMapping);
        DirectToFieldMapping numberMapping = new DirectToFieldMapping();
        numberMapping.setAttributeName("number");
        numberMapping.setGetMethodName("getNumber");
        numberMapping.setSetMethodName("setNumber");
        numberMapping.setFieldName("INS_PHONE.PHONE_NUMBER");
        descriptor.addMapping((DatabaseMapping)numberMapping);
        DirectToFieldMapping typeMapping = new DirectToFieldMapping();
        typeMapping.setAttributeName("type");
        typeMapping.setGetMethodName("getType");
        typeMapping.setSetMethodName("setType");
        typeMapping.setFieldName("INS_PHONE.TYPE");
        descriptor.addMapping((DatabaseMapping)typeMapping);
        descriptor.applyAmendmentMethod();
        return descriptor;
    }

    public RelationalDescriptor buildPolicyDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Policy.class);
        descriptor.addTableName("POLICY");
        descriptor.addPrimaryKeyFieldName("POLICY.POL_ID");
        descriptor.getDescriptorInheritancePolicy().setClassIndicatorFieldName("POLICY.POL_TYPE");
        descriptor.getDescriptorInheritancePolicy().addClassIndicator(HousePolicy.class, (Object)3L);
        descriptor.getDescriptorInheritancePolicy().addClassIndicator(HealthPolicy.class, (Object)2L);
        descriptor.getDescriptorInheritancePolicy().addClassIndicator(VehiclePolicy.class, (Object)1L);
        descriptor.getDescriptorInheritancePolicy().addClassIndicator(BicyclePolicy.class, (Object)0L);
        DirectToFieldMapping policyNumberMapping = new DirectToFieldMapping();
        policyNumberMapping.setAttributeName("policyNumber");
        policyNumberMapping.setGetMethodName("getPolicyNumber");
        policyNumberMapping.setSetMethodName("setPolicyNumber");
        policyNumberMapping.setFieldName("POLICY.POL_ID");
        descriptor.addMapping((DatabaseMapping)policyNumberMapping);
        DirectToFieldMapping maxCoverageMapping = new DirectToFieldMapping();
        maxCoverageMapping.setAttributeName("maxCoverage");
        maxCoverageMapping.setGetMethodName("getMaxCoverage");
        maxCoverageMapping.setSetMethodName("setMaxCoverage");
        maxCoverageMapping.setFieldName("POLICY.MAX_COV");
        descriptor.addMapping((DatabaseMapping)maxCoverageMapping);
        DirectToFieldMapping descriptionMapping = new DirectToFieldMapping();
        descriptionMapping.setAttributeName("description");
        descriptionMapping.setGetMethodName("getDescription");
        descriptionMapping.setSetMethodName("setDescription");
        descriptionMapping.setFieldName("POLICY.DESCRIPT");
        descriptor.addMapping((DatabaseMapping)descriptionMapping);
        OneToOneMapping policyHolderMapping = new OneToOneMapping();
        policyHolderMapping.setAttributeName("policyHolder");
        policyHolderMapping.setGetMethodName("getPolicyHolder");
        policyHolderMapping.setSetMethodName("setPolicyHolder");
        policyHolderMapping.setReferenceClass(PolicyHolder.class);
        policyHolderMapping.dontUseIndirection();
        policyHolderMapping.addForeignKeyFieldName("POLICY.SSN", "HOLDER.SSN");
        descriptor.addMapping((DatabaseMapping)policyHolderMapping);
        OneToManyMapping claimsMapping = new OneToManyMapping();
        claimsMapping.setAttributeName("claims");
        claimsMapping.setGetMethodName("getClaims");
        claimsMapping.setSetMethodName("setClaims");
        claimsMapping.setReferenceClass(Claim.class);
        claimsMapping.dontUseIndirection();
        claimsMapping.privateOwnedRelationship();
        claimsMapping.addTargetForeignKeyFieldName("CLAIM.POL_ID", "POLICY.POL_ID");
        descriptor.addMapping((DatabaseMapping)claimsMapping);
        return descriptor;
    }

    public RelationalDescriptor buildPolicyHolderDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(PolicyHolder.class);
        descriptor.addTableName("HOLDER");
        descriptor.addPrimaryKeyFieldName("HOLDER.SSN");
        descriptor.setAmendmentClass(InsuranceSystem.class);
        descriptor.setAmendmentMethodName("modifyPolicyHolderDescriptor");
        DirectToFieldMapping birthDateMapping = new DirectToFieldMapping();
        birthDateMapping.setAttributeName("birthDate");
        birthDateMapping.setGetMethodName("getBirthDate");
        birthDateMapping.setSetMethodName("setBirthDate");
        birthDateMapping.setFieldName("HOLDER.BDATE");
        descriptor.addMapping((DatabaseMapping)birthDateMapping);
        DirectToFieldMapping firstNameMapping = new DirectToFieldMapping();
        firstNameMapping.setAttributeName("firstName");
        firstNameMapping.setGetMethodName("getFirstName");
        firstNameMapping.setSetMethodName("setFirstName");
        firstNameMapping.setFieldName("HOLDER.F_NAME");
        descriptor.addMapping((DatabaseMapping)firstNameMapping);
        DirectToFieldMapping lastNameMapping = new DirectToFieldMapping();
        lastNameMapping.setAttributeName("lastName");
        lastNameMapping.setGetMethodName("getLastName");
        lastNameMapping.setSetMethodName("setLastName");
        lastNameMapping.setFieldName("HOLDER.L_NAME");
        descriptor.addMapping((DatabaseMapping)lastNameMapping);
        DirectToFieldMapping occupationMapping = new DirectToFieldMapping();
        occupationMapping.setAttributeName("occupation");
        occupationMapping.setGetMethodName("getOccupation");
        occupationMapping.setSetMethodName("setOccupation");
        occupationMapping.setFieldName("HOLDER.OCC");
        descriptor.addMapping((DatabaseMapping)occupationMapping);
        DirectToFieldMapping ssnMapping = new DirectToFieldMapping();
        ssnMapping.setAttributeName("ssn");
        ssnMapping.setGetMethodName("getSsn");
        ssnMapping.setSetMethodName("setSsn");
        ssnMapping.setFieldName("HOLDER.SSN");
        descriptor.addMapping((DatabaseMapping)ssnMapping);
        DirectToFieldMapping sexMapping = new DirectToFieldMapping();
        sexMapping.setAttributeName("sex");
        sexMapping.setGetMethodName("getSex");
        sexMapping.setSetMethodName("setSex");
        sexMapping.setFieldName("HOLDER.SEX");
        ObjectTypeConverter sexConverter = new ObjectTypeConverter();
        sexConverter.addConversionValue((Object)Character.valueOf('F'), (Object)"Female");
        sexConverter.addConversionValue((Object)Character.valueOf('M'), (Object)"Male");
        sexMapping.setConverter((Converter)sexConverter);
        descriptor.addMapping((DatabaseMapping)sexMapping);
        DirectCollectionMapping childrenNamesMapping = new DirectCollectionMapping();
        childrenNamesMapping.setAttributeName("childrenNames");
        childrenNamesMapping.setGetMethodName("getChildrenNames");
        childrenNamesMapping.setSetMethodName("setChildrenNames");
        childrenNamesMapping.dontUseIndirection();
        childrenNamesMapping.setReferenceTableName("CHILDNAM");
        childrenNamesMapping.setDirectFieldName("CHILDNAM.CHILD_NAME");
        childrenNamesMapping.addReferenceKeyFieldName("CHILDNAM.HOLDER_ID", "HOLDER.SSN");
        descriptor.addMapping((DatabaseMapping)childrenNamesMapping);
        OneToOneMapping addressMapping = new OneToOneMapping();
        addressMapping.setAttributeName("address");
        addressMapping.setGetMethodName("getAddress");
        addressMapping.setSetMethodName("internalSetAddress");
        addressMapping.setReferenceClass(Address.class);
        addressMapping.dontUseIndirection();
        addressMapping.privateOwnedRelationship();
        addressMapping.addTargetForeignKeyFieldName("INS_ADDR.SSN", "HOLDER.SSN");
        descriptor.addMapping((DatabaseMapping)addressMapping);
        OneToManyMapping policiesMapping = new OneToManyMapping();
        policiesMapping.setAttributeName("policies");
        policiesMapping.setGetMethodName("getPolicies");
        policiesMapping.setSetMethodName("setPolicies");
        policiesMapping.setReferenceClass(Policy.class);
        policiesMapping.dontUseIndirection();
        policiesMapping.privateOwnedRelationship();
        policiesMapping.addTargetForeignKeyFieldName("POLICY.SSN", "HOLDER.SSN");
        descriptor.addMapping((DatabaseMapping)policiesMapping);
        descriptor.applyAmendmentMethod();
        return descriptor;
    }

    public RelationalDescriptor buildVehicleClaimDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(VehicleClaim.class);
        descriptor.addTableName("VHCL_CLM");
        descriptor.getDescriptorInheritancePolicy().setParentClass(Claim.class);
        descriptor.getDescriptorQueryManager().checkDatabaseForDoesExist();
        DirectToFieldMapping partMapping = new DirectToFieldMapping();
        partMapping.setAttributeName("part");
        partMapping.setGetMethodName("getPart");
        partMapping.setSetMethodName("setPart");
        partMapping.setFieldName("VHCL_CLM.PART");
        descriptor.addMapping((DatabaseMapping)partMapping);
        DirectToFieldMapping partDescriptionMapping = new DirectToFieldMapping();
        partDescriptionMapping.setAttributeName("partDescription");
        partDescriptionMapping.setGetMethodName("getPartDescription");
        partDescriptionMapping.setSetMethodName("setPartDescription");
        partDescriptionMapping.setFieldName("VHCL_CLM.PART_DESC");
        descriptor.addMapping((DatabaseMapping)partDescriptionMapping);
        return descriptor;
    }

    public RelationalDescriptor buildVehiclePolicyDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(VehiclePolicy.class);
        descriptor.addTableName("VHCL_POL");
        descriptor.getDescriptorInheritancePolicy().setParentClass(Policy.class);
        descriptor.getDescriptorQueryManager().checkDatabaseForDoesExist();
        DirectToFieldMapping modelMapping = new DirectToFieldMapping();
        modelMapping.setAttributeName("model");
        modelMapping.setGetMethodName("getModel");
        modelMapping.setSetMethodName("setModel");
        modelMapping.setFieldName("VHCL_POL.MODEL");
        descriptor.addMapping((DatabaseMapping)modelMapping);
        return descriptor;
    }

    public RelationalDescriptor buildBicyclePolicyDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(BicyclePolicy.class);
        descriptor.addTableName("BCCL_POL");
        descriptor.getDescriptorInheritancePolicy().setParentClass(VehiclePolicy.class);
        descriptor.getDescriptorQueryManager().checkDatabaseForDoesExist();
        DirectToFieldMapping colorMapping = new DirectToFieldMapping();
        colorMapping.setAttributeName("model");
        colorMapping.setGetMethodName("getColor");
        colorMapping.setSetMethodName("setColor");
        colorMapping.setFieldName("BCCL_POL.COLOR");
        descriptor.addMapping((DatabaseMapping)colorMapping);
        return descriptor;
    }
}

