/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.api.table.ArrayDefImpl;
import oracle.kv.impl.api.table.EnumDefImpl;
import oracle.kv.impl.api.table.FieldDefFactory;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldDefSerialization;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.MapDefImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.table.FieldDef;

public class TypeManager {
    static final boolean[][] QUANT_SUBTYPE_MATRIX = new boolean[][]{{true, true, true, true}, {false, true, false, true}, {false, false, true, true}, {false, false, false, true}};
    static final ExprType.Quantifier[][] QUANT_UNION_MATRIX = new ExprType.Quantifier[][]{{ExprType.Quantifier.ONE, ExprType.Quantifier.QSTN, ExprType.Quantifier.PLUS, ExprType.Quantifier.STAR}, {ExprType.Quantifier.QSTN, ExprType.Quantifier.QSTN, ExprType.Quantifier.STAR, ExprType.Quantifier.STAR}, {ExprType.Quantifier.PLUS, ExprType.Quantifier.STAR, ExprType.Quantifier.PLUS, ExprType.Quantifier.STAR}, {ExprType.Quantifier.STAR, ExprType.Quantifier.STAR, ExprType.Quantifier.STAR, ExprType.Quantifier.STAR}};
    static final ExprType.Quantifier[][] QUANT_INTERS_MATRIX = new ExprType.Quantifier[][]{{ExprType.Quantifier.ONE, ExprType.Quantifier.ONE, ExprType.Quantifier.ONE, ExprType.Quantifier.ONE}, {ExprType.Quantifier.ONE, ExprType.Quantifier.QSTN, ExprType.Quantifier.ONE, ExprType.Quantifier.QSTN}, {ExprType.Quantifier.ONE, ExprType.Quantifier.ONE, ExprType.Quantifier.PLUS, ExprType.Quantifier.PLUS}, {ExprType.Quantifier.ONE, ExprType.Quantifier.QSTN, ExprType.Quantifier.PLUS, ExprType.Quantifier.STAR}};
    static final ExprType.Quantifier[][] QUANT_CONCAT_MATRIX = new ExprType.Quantifier[][]{{ExprType.Quantifier.PLUS, ExprType.Quantifier.PLUS, ExprType.Quantifier.PLUS, ExprType.Quantifier.PLUS}, {ExprType.Quantifier.PLUS, ExprType.Quantifier.STAR, ExprType.Quantifier.PLUS, ExprType.Quantifier.STAR}, {ExprType.Quantifier.PLUS, ExprType.Quantifier.PLUS, ExprType.Quantifier.PLUS, ExprType.Quantifier.PLUS}, {ExprType.Quantifier.PLUS, ExprType.Quantifier.STAR, ExprType.Quantifier.PLUS, ExprType.Quantifier.STAR}};
    static final boolean[][] SUBTYPE_MATRIX = new boolean[][]{{true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true}, {false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, true, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, true, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, true, true, true, true, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, true, true, true, true, false, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {false, true, true, true, true, false, true, false, true, false, false, false, false, false, false, false, false, false, false, false}, {false, true, true, true, true, false, true, false, false, true, true, false, false, false, false, false, false, false, false, false}, {false, true, true, true, true, false, true, false, false, false, true, false, false, false, false, false, false, false, false, false}, {false, true, true, true, true, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false}, {false, true, true, true, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false}, {false, true, true, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false}, {false, true, true, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false}, {false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false}, {false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false}, {false, true, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, true, false, false}, {false, true, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false}, {false, true, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true}};
    static final boolean[][] COMPARISON_MATRIX = new boolean[][]{{true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true}, {true, true, true, true, true, false, true, true, true, true, true, true, true, true, true, true, true, false, false, false}, {true, true, true, true, true, false, true, true, true, true, true, true, true, false, false, true, false, false, false, false}, {true, true, true, true, true, false, true, true, true, true, true, true, true, false, false, true, false, false, true, true}, {true, true, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, true, false, false}, {true, true, true, true, true, false, true, true, true, true, true, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, false, true, true, true, true, true, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, false, true, true, true, true, true, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, false, true, true, true, true, true, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, false, true, true, true, true, true, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, false, false, false, false, false, false, true, false, false, false, true, false, false, false, false}, {true, true, true, true, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false}, {true, true, true, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false}, {true, true, true, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false}, {true, true, true, false, false, false, false, false, false, false, false, true, false, false, false, true, false, false, false, false}, {true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false}, {true, true, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, true, false, false}, {true, true, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false}, {true, true, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true}};
    static final ExprType[][] BUILTIN_TYPES = new ExprType[][]{{new ExprType(FieldDefImpl.emptyDef, ExprType.Quantifier.QSTN, true)}, {new ExprType(FieldDefImpl.anyDef, ExprType.Quantifier.ONE, true), new ExprType(FieldDefImpl.anyDef, ExprType.Quantifier.QSTN, true), new ExprType(FieldDefImpl.anyDef, ExprType.Quantifier.PLUS, true), new ExprType(FieldDefImpl.anyDef, ExprType.Quantifier.STAR, true)}, {new ExprType(FieldDefImpl.anyAtomicDef, ExprType.Quantifier.ONE, true), new ExprType(FieldDefImpl.anyAtomicDef, ExprType.Quantifier.QSTN, true), new ExprType(FieldDefImpl.anyAtomicDef, ExprType.Quantifier.PLUS, true), new ExprType(FieldDefImpl.anyAtomicDef, ExprType.Quantifier.STAR, true)}, {new ExprType(FieldDefImpl.anyJsonAtomicDef, ExprType.Quantifier.ONE, true), new ExprType(FieldDefImpl.anyJsonAtomicDef, ExprType.Quantifier.QSTN, true), new ExprType(FieldDefImpl.anyJsonAtomicDef, ExprType.Quantifier.PLUS, true), new ExprType(FieldDefImpl.anyJsonAtomicDef, ExprType.Quantifier.STAR, true)}, {new ExprType(FieldDefImpl.jsonDef, ExprType.Quantifier.ONE, true), new ExprType(FieldDefImpl.jsonDef, ExprType.Quantifier.QSTN, true), new ExprType(FieldDefImpl.jsonDef, ExprType.Quantifier.PLUS, true), new ExprType(FieldDefImpl.jsonDef, ExprType.Quantifier.STAR, true)}, {new ExprType(FieldDefImpl.anyRecordDef, ExprType.Quantifier.ONE, true), new ExprType(FieldDefImpl.anyRecordDef, ExprType.Quantifier.QSTN, true), new ExprType(FieldDefImpl.anyRecordDef, ExprType.Quantifier.PLUS, true), new ExprType(FieldDefImpl.anyRecordDef, ExprType.Quantifier.STAR, true)}, {new ExprType(FieldDefImpl.numberDef, ExprType.Quantifier.ONE, true), new ExprType(FieldDefImpl.numberDef, ExprType.Quantifier.QSTN, true), new ExprType(FieldDefImpl.numberDef, ExprType.Quantifier.PLUS, true), new ExprType(FieldDefImpl.numberDef, ExprType.Quantifier.STAR, true)}, {new ExprType(FieldDefImpl.integerDef, ExprType.Quantifier.ONE, true), new ExprType(FieldDefImpl.integerDef, ExprType.Quantifier.QSTN, true), new ExprType(FieldDefImpl.integerDef, ExprType.Quantifier.PLUS, true), new ExprType(FieldDefImpl.integerDef, ExprType.Quantifier.STAR, true)}, {new ExprType(FieldDefImpl.longDef, ExprType.Quantifier.ONE, true), new ExprType(FieldDefImpl.longDef, ExprType.Quantifier.QSTN, true), new ExprType(FieldDefImpl.longDef, ExprType.Quantifier.PLUS, true), new ExprType(FieldDefImpl.longDef, ExprType.Quantifier.STAR, true)}, {new ExprType(FieldDefImpl.floatDef, ExprType.Quantifier.ONE, true), new ExprType(FieldDefImpl.floatDef, ExprType.Quantifier.QSTN, true), new ExprType(FieldDefImpl.floatDef, ExprType.Quantifier.PLUS, true), new ExprType(FieldDefImpl.floatDef, ExprType.Quantifier.STAR, true)}, {new ExprType(FieldDefImpl.doubleDef, ExprType.Quantifier.ONE, true), new ExprType(FieldDefImpl.doubleDef, ExprType.Quantifier.QSTN, true), new ExprType(FieldDefImpl.doubleDef, ExprType.Quantifier.PLUS, true), new ExprType(FieldDefImpl.doubleDef, ExprType.Quantifier.STAR, true)}, {new ExprType(FieldDefImpl.stringDef, ExprType.Quantifier.ONE, true), new ExprType(FieldDefImpl.stringDef, ExprType.Quantifier.QSTN, true), new ExprType(FieldDefImpl.stringDef, ExprType.Quantifier.PLUS, true), new ExprType(FieldDefImpl.stringDef, ExprType.Quantifier.STAR, true)}, {new ExprType(FieldDefImpl.booleanDef, ExprType.Quantifier.ONE, true), new ExprType(FieldDefImpl.booleanDef, ExprType.Quantifier.QSTN, true), new ExprType(FieldDefImpl.booleanDef, ExprType.Quantifier.PLUS, true), new ExprType(FieldDefImpl.booleanDef, ExprType.Quantifier.STAR, true)}, {new ExprType(FieldDefImpl.binaryDef, ExprType.Quantifier.ONE, true), new ExprType(FieldDefImpl.binaryDef, ExprType.Quantifier.QSTN, true), new ExprType(FieldDefImpl.binaryDef, ExprType.Quantifier.PLUS, true), new ExprType(FieldDefImpl.binaryDef, ExprType.Quantifier.STAR, true)}, new ExprType[0], new ExprType[0], {new ExprType(FieldDefImpl.timestampDefs[9], ExprType.Quantifier.ONE, false), new ExprType(FieldDefImpl.timestampDefs[9], ExprType.Quantifier.QSTN, false), new ExprType(FieldDefImpl.timestampDefs[9], ExprType.Quantifier.PLUS, false), new ExprType(FieldDefImpl.timestampDefs[9], ExprType.Quantifier.STAR, false)}};
    public static ExprType ANY_ARRAY_STAR = TypeManager.createArrayType(TypeManager.ANY_ONE(), ExprType.Quantifier.STAR);

    public static ExprType EMPTY() {
        return BUILTIN_TYPES[ExprType.TypeCode.EMPTY.ordinal()][0];
    }

    public static ExprType ANY_ONE() {
        return BUILTIN_TYPES[ExprType.TypeCode.ANY.ordinal()][ExprType.Quantifier.ONE.ordinal()];
    }

    public static ExprType ANY_QSTN() {
        return BUILTIN_TYPES[ExprType.TypeCode.ANY.ordinal()][ExprType.Quantifier.QSTN.ordinal()];
    }

    public static ExprType ANY_PLUS() {
        return BUILTIN_TYPES[ExprType.TypeCode.ANY.ordinal()][ExprType.Quantifier.PLUS.ordinal()];
    }

    public static ExprType ANY_STAR() {
        return BUILTIN_TYPES[ExprType.TypeCode.ANY.ordinal()][ExprType.Quantifier.STAR.ordinal()];
    }

    public static ExprType ANY_ATOMIC_ONE() {
        return BUILTIN_TYPES[ExprType.TypeCode.ANY_ATOMIC.ordinal()][ExprType.Quantifier.ONE.ordinal()];
    }

    public static ExprType ANY_ATOMIC_QSTN() {
        return BUILTIN_TYPES[ExprType.TypeCode.ANY_ATOMIC.ordinal()][ExprType.Quantifier.QSTN.ordinal()];
    }

    public static ExprType ANY_ATOMIC_PLUS() {
        return BUILTIN_TYPES[ExprType.TypeCode.ANY_ATOMIC.ordinal()][ExprType.Quantifier.PLUS.ordinal()];
    }

    public static ExprType ANY_ATOMIC_STAR() {
        return BUILTIN_TYPES[ExprType.TypeCode.ANY_ATOMIC.ordinal()][ExprType.Quantifier.STAR.ordinal()];
    }

    public static ExprType ANY_JATOMIC_ONE() {
        return BUILTIN_TYPES[ExprType.TypeCode.ANY_JSON_ATOMIC.ordinal()][ExprType.Quantifier.ONE.ordinal()];
    }

    public static ExprType ANY_JATOMIC_QSTN() {
        return BUILTIN_TYPES[ExprType.TypeCode.ANY_JSON_ATOMIC.ordinal()][ExprType.Quantifier.QSTN.ordinal()];
    }

    public static ExprType ANY_JATOMIC_PLUS() {
        return BUILTIN_TYPES[ExprType.TypeCode.ANY_JSON_ATOMIC.ordinal()][ExprType.Quantifier.PLUS.ordinal()];
    }

    public static ExprType ANY_JATOMIC_STAR() {
        return BUILTIN_TYPES[ExprType.TypeCode.ANY_JSON_ATOMIC.ordinal()][ExprType.Quantifier.STAR.ordinal()];
    }

    public static ExprType JSON_ONE() {
        return BUILTIN_TYPES[ExprType.TypeCode.JSON.ordinal()][ExprType.Quantifier.ONE.ordinal()];
    }

    public static ExprType JSON_QSTN() {
        return BUILTIN_TYPES[ExprType.TypeCode.JSON.ordinal()][ExprType.Quantifier.QSTN.ordinal()];
    }

    public static ExprType JSON_PLUS() {
        return BUILTIN_TYPES[ExprType.TypeCode.JSON.ordinal()][ExprType.Quantifier.PLUS.ordinal()];
    }

    public static ExprType JSON_STAR() {
        return BUILTIN_TYPES[ExprType.TypeCode.JSON.ordinal()][ExprType.Quantifier.STAR.ordinal()];
    }

    public static ExprType ANY_RECORD_ONE() {
        return BUILTIN_TYPES[ExprType.TypeCode.ANY.ordinal()][ExprType.Quantifier.ONE.ordinal()];
    }

    public static ExprType ANY_RECORD_QSTN() {
        return BUILTIN_TYPES[ExprType.TypeCode.ANY.ordinal()][ExprType.Quantifier.QSTN.ordinal()];
    }

    public static ExprType ANY_RECORD_PLUS() {
        return BUILTIN_TYPES[ExprType.TypeCode.ANY.ordinal()][ExprType.Quantifier.PLUS.ordinal()];
    }

    public static ExprType ANY_RECORD_STAR() {
        return BUILTIN_TYPES[ExprType.TypeCode.ANY.ordinal()][ExprType.Quantifier.STAR.ordinal()];
    }

    public static ExprType NUMBER_ONE() {
        return BUILTIN_TYPES[ExprType.TypeCode.NUMBER.ordinal()][ExprType.Quantifier.ONE.ordinal()];
    }

    public static ExprType NUMBER_QSTN() {
        return BUILTIN_TYPES[ExprType.TypeCode.NUMBER.ordinal()][ExprType.Quantifier.QSTN.ordinal()];
    }

    public static ExprType NUMBER_PLUS() {
        return BUILTIN_TYPES[ExprType.TypeCode.NUMBER.ordinal()][ExprType.Quantifier.PLUS.ordinal()];
    }

    public static ExprType NUMBER_STAR() {
        return BUILTIN_TYPES[ExprType.TypeCode.NUMBER.ordinal()][ExprType.Quantifier.STAR.ordinal()];
    }

    public static ExprType INT_ONE() {
        return BUILTIN_TYPES[ExprType.TypeCode.INT.ordinal()][ExprType.Quantifier.ONE.ordinal()];
    }

    public static ExprType INT_QSTN() {
        return BUILTIN_TYPES[ExprType.TypeCode.INT.ordinal()][ExprType.Quantifier.QSTN.ordinal()];
    }

    public static ExprType INT_PLUS() {
        return BUILTIN_TYPES[ExprType.TypeCode.INT.ordinal()][ExprType.Quantifier.PLUS.ordinal()];
    }

    public static ExprType INT_STAR() {
        return BUILTIN_TYPES[ExprType.TypeCode.INT.ordinal()][ExprType.Quantifier.STAR.ordinal()];
    }

    public static ExprType LONG_ONE() {
        return BUILTIN_TYPES[ExprType.TypeCode.LONG.ordinal()][ExprType.Quantifier.ONE.ordinal()];
    }

    public static ExprType LONG_QSTN() {
        return BUILTIN_TYPES[ExprType.TypeCode.LONG.ordinal()][ExprType.Quantifier.QSTN.ordinal()];
    }

    public static ExprType LONG_PLUS() {
        return BUILTIN_TYPES[ExprType.TypeCode.LONG.ordinal()][ExprType.Quantifier.PLUS.ordinal()];
    }

    public static ExprType LONG_STAR() {
        return BUILTIN_TYPES[ExprType.TypeCode.LONG.ordinal()][ExprType.Quantifier.STAR.ordinal()];
    }

    public static ExprType FLOAT_ONE() {
        return BUILTIN_TYPES[ExprType.TypeCode.FLOAT.ordinal()][ExprType.Quantifier.ONE.ordinal()];
    }

    public static ExprType FLOAT_QSTN() {
        return BUILTIN_TYPES[ExprType.TypeCode.FLOAT.ordinal()][ExprType.Quantifier.QSTN.ordinal()];
    }

    public static ExprType FLOAT_PLUS() {
        return BUILTIN_TYPES[ExprType.TypeCode.FLOAT.ordinal()][ExprType.Quantifier.PLUS.ordinal()];
    }

    public static ExprType FLOAT_STAR() {
        return BUILTIN_TYPES[ExprType.TypeCode.FLOAT.ordinal()][ExprType.Quantifier.STAR.ordinal()];
    }

    public static ExprType DOUBLE_ONE() {
        return BUILTIN_TYPES[ExprType.TypeCode.DOUBLE.ordinal()][ExprType.Quantifier.ONE.ordinal()];
    }

    public static ExprType DOUBLE_QSTN() {
        return BUILTIN_TYPES[ExprType.TypeCode.DOUBLE.ordinal()][ExprType.Quantifier.QSTN.ordinal()];
    }

    public static ExprType DOUBLE_PLUS() {
        return BUILTIN_TYPES[ExprType.TypeCode.DOUBLE.ordinal()][ExprType.Quantifier.PLUS.ordinal()];
    }

    public static ExprType DOUBLE_STAR() {
        return BUILTIN_TYPES[ExprType.TypeCode.DOUBLE.ordinal()][ExprType.Quantifier.STAR.ordinal()];
    }

    public static ExprType STRING_ONE() {
        return BUILTIN_TYPES[ExprType.TypeCode.STRING.ordinal()][ExprType.Quantifier.ONE.ordinal()];
    }

    public static ExprType STRING_QSTN() {
        return BUILTIN_TYPES[ExprType.TypeCode.STRING.ordinal()][ExprType.Quantifier.QSTN.ordinal()];
    }

    public static ExprType STRING_PLUS() {
        return BUILTIN_TYPES[ExprType.TypeCode.STRING.ordinal()][ExprType.Quantifier.PLUS.ordinal()];
    }

    public static ExprType STRING_STAR() {
        return BUILTIN_TYPES[ExprType.TypeCode.STRING.ordinal()][ExprType.Quantifier.STAR.ordinal()];
    }

    public static ExprType BOOLEAN_ONE() {
        return BUILTIN_TYPES[ExprType.TypeCode.BOOLEAN.ordinal()][ExprType.Quantifier.ONE.ordinal()];
    }

    public static ExprType BOOLEAN_QSTN() {
        return BUILTIN_TYPES[ExprType.TypeCode.BOOLEAN.ordinal()][ExprType.Quantifier.QSTN.ordinal()];
    }

    public static ExprType BOOLEAN_PLUS() {
        return BUILTIN_TYPES[ExprType.TypeCode.BOOLEAN.ordinal()][ExprType.Quantifier.PLUS.ordinal()];
    }

    public static ExprType BOOLEAN_STAR() {
        return BUILTIN_TYPES[ExprType.TypeCode.BOOLEAN.ordinal()][ExprType.Quantifier.STAR.ordinal()];
    }

    public static ExprType BINARY_ONE() {
        return BUILTIN_TYPES[ExprType.TypeCode.BINARY.ordinal()][ExprType.Quantifier.ONE.ordinal()];
    }

    public static ExprType BINARY_QSTN() {
        return BUILTIN_TYPES[ExprType.TypeCode.BINARY.ordinal()][ExprType.Quantifier.QSTN.ordinal()];
    }

    public static ExprType BINARY_PLUS() {
        return BUILTIN_TYPES[ExprType.TypeCode.BINARY.ordinal()][ExprType.Quantifier.PLUS.ordinal()];
    }

    public static ExprType BINARY_STAR() {
        return BUILTIN_TYPES[ExprType.TypeCode.BINARY.ordinal()][ExprType.Quantifier.STAR.ordinal()];
    }

    public static ExprType TIMESTAMP_ONE() {
        return BUILTIN_TYPES[ExprType.TypeCode.TIMESTAMP.ordinal()][ExprType.Quantifier.ONE.ordinal()];
    }

    public static ExprType TIMESTAMP_QSTN() {
        return BUILTIN_TYPES[ExprType.TypeCode.TIMESTAMP.ordinal()][ExprType.Quantifier.QSTN.ordinal()];
    }

    public static ExprType TIMESTAMP_PLUS() {
        return BUILTIN_TYPES[ExprType.TypeCode.TIMESTAMP.ordinal()][ExprType.Quantifier.PLUS.ordinal()];
    }

    public static ExprType TIMESTAMP_STAR() {
        return BUILTIN_TYPES[ExprType.TypeCode.TIMESTAMP.ordinal()][ExprType.Quantifier.STAR.ordinal()];
    }

    TypeManager() {
    }

    public static ExprType.Quantifier getIntersectionQuant(ExprType.Quantifier q1, ExprType.Quantifier q2) {
        return QUANT_INTERS_MATRIX[q1.ordinal()][q2.ordinal()];
    }

    public static ExprType.Quantifier getUnionQuant(ExprType.Quantifier q1, ExprType.Quantifier q2) {
        return QUANT_UNION_MATRIX[q1.ordinal()][q2.ordinal()];
    }

    public static ExprType.Quantifier getConcatQuant(ExprType.Quantifier q1, ExprType.Quantifier q2) {
        return QUANT_CONCAT_MATRIX[q1.ordinal()][q2.ordinal()];
    }

    static boolean isSubQuant(ExprType.Quantifier sub, ExprType.Quantifier sup) {
        return QUANT_SUBTYPE_MATRIX[sub.ordinal()][sup.ordinal()];
    }

    static boolean isSubTypeCode(ExprType.TypeCode sub, ExprType.TypeCode sup) {
        return SUBTYPE_MATRIX[sub.ordinal()][sup.ordinal()];
    }

    public static boolean typesIntersect(ExprType t1, ExprType t2) {
        ExprType.TypeCode c1 = t1.getCode();
        ExprType.TypeCode c2 = t2.getCode();
        ExprType.Quantifier q1 = t1.getQuantifier();
        ExprType.Quantifier q2 = t2.getQuantifier();
        if (!(q1 != ExprType.Quantifier.QSTN && q1 != ExprType.Quantifier.STAR || q2 != ExprType.Quantifier.QSTN && q2 != ExprType.Quantifier.STAR)) {
            return true;
        }
        if (c1 == ExprType.TypeCode.EMPTY || c2 == ExprType.TypeCode.EMPTY) {
            return false;
        }
        return TypeManager.isSubTypeCode(c1, c2) || TypeManager.isSubTypeCode(c2, c1);
    }

    static boolean areTypeCodesComparable(ExprType t1, ExprType t2) {
        return COMPARISON_MATRIX[t1.getCode().ordinal()][t2.getCode().ordinal()];
    }

    public static boolean areTypesComparable(ExprType t1, ExprType t2) {
        return TypeManager.areTypeCodesComparable(t1, t2);
    }

    public static boolean areTypesComparable(FieldDefImpl t1, FieldDefImpl t2) {
        ExprType.TypeCode tc1 = ExprType.getTypeCodeForDefCode(t1.getType());
        ExprType.TypeCode tc2 = ExprType.getTypeCodeForDefCode(t2.getType());
        return COMPARISON_MATRIX[tc1.ordinal()][tc2.ordinal()];
    }

    public static ExprType getUnionType(ExprType t1, ExprType t2) {
        ExprType.Quantifier q = TypeManager.getUnionQuant(t1.getQuantifier(), t2.getQuantifier());
        return TypeManager.getUnionOrConcatType(t1, t2, q);
    }

    public static ExprType getConcatType(ExprType t1, ExprType t2) {
        ExprType.Quantifier q = TypeManager.getConcatQuant(t1.getQuantifier(), t2.getQuantifier());
        return TypeManager.getUnionOrConcatType(t1, t2, q);
    }

    private static ExprType getUnionOrConcatType(ExprType t1, ExprType t2, ExprType.Quantifier q) {
        FieldDefImpl def1 = t1.getDef();
        FieldDefImpl def2 = t2.getDef();
        FieldDefImpl union = def1.isEmpty() ? def2 : (def2.isEmpty() ? def1 : def1.getUnionType(def2));
        return TypeManager.createType(union, q);
    }

    public static ExprType createType(ExprType t, ExprType.Quantifier q) {
        if (t.getQuantifier() == q) {
            return t;
        }
        if (t.isBuiltin()) {
            return TypeManager.getBuiltinType(t.getCode(), q);
        }
        ExprType res = new ExprType(t);
        res.setQuant(q);
        return res;
    }

    public static ExprType createType(FieldDefImpl t, ExprType.Quantifier q) {
        ExprType type = TypeManager.getBuiltinType(t, q);
        if (type == null) {
            type = new ExprType(t, q, false);
        }
        return type;
    }

    public static ExprType createTableRecordType(TableImpl table, ExprType.Quantifier q) {
        RecordDefImpl rowType = table.getRowDef();
        return new ExprType(rowType, q, false);
    }

    public static ExprType createArrayType(ExprType elemType, ExprType.Quantifier q) {
        ArrayDefImpl typeDef = FieldDefFactory.createArrayDef(elemType.getDef());
        return TypeManager.createType(typeDef, q);
    }

    public static ExprType createMapType(ExprType elemType, ExprType.Quantifier q) {
        MapDefImpl typeDef = FieldDefFactory.createMapDef(elemType.getDef());
        return TypeManager.createType(typeDef, q);
    }

    public static ExprType createValueType(FieldValueImpl value) {
        if (value.isNull()) {
            throw new QueryStateException("Null values do not have types!: ");
        }
        if (value.isJsonNull()) {
            return TypeManager.JSON_ONE();
        }
        switch (value.getType()) {
            case INTEGER: {
                return TypeManager.INT_ONE();
            }
            case LONG: {
                return TypeManager.LONG_ONE();
            }
            case FLOAT: {
                return TypeManager.FLOAT_ONE();
            }
            case DOUBLE: {
                return TypeManager.DOUBLE_ONE();
            }
            case NUMBER: {
                return TypeManager.NUMBER_ONE();
            }
            case STRING: {
                return TypeManager.STRING_ONE();
            }
            case BOOLEAN: {
                return TypeManager.BOOLEAN_ONE();
            }
            case BINARY: {
                return TypeManager.BINARY_ONE();
            }
            case FIXED_BINARY: 
            case ENUM: 
            case TIMESTAMP: 
            case RECORD: 
            case ARRAY: 
            case MAP: {
                FieldDefImpl type = value.getDefinition();
                return new ExprType(type, false);
            }
        }
        throw new QueryStateException("Unexpected value kind: " + value.getType());
    }

    public static ExprType getBuiltinType(ExprType.TypeCode t, ExprType.Quantifier q) {
        assert (ExprType.isBuiltin(t));
        if (t == ExprType.TypeCode.EMPTY) {
            return TypeManager.EMPTY();
        }
        return BUILTIN_TYPES[t.ordinal()][q.ordinal()];
    }

    private static ExprType getBuiltinType(FieldDefImpl t, ExprType.Quantifier q) {
        switch (t.getType()) {
            case EMPTY: {
                return TypeManager.EMPTY();
            }
            case ANY: 
            case ANY_ATOMIC: 
            case ANY_JSON_ATOMIC: 
            case JSON: 
            case ANY_RECORD: {
                return TypeManager.getBuiltinType(ExprType.getTypeCodeForDefCode(t.getType()), q);
            }
            case INTEGER: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case NUMBER: 
            case STRING: 
            case BOOLEAN: 
            case BINARY: {
                if (!t.hasMin() && !t.hasMax()) {
                    return TypeManager.getBuiltinType(ExprType.getTypeCodeForDefCode(t.getType()), q);
                }
                return null;
            }
            case FIXED_BINARY: 
            case ENUM: 
            case TIMESTAMP: 
            case RECORD: 
            case ARRAY: 
            case MAP: {
                return null;
            }
        }
        throw new QueryStateException("Unexpected type: " + t.getType());
    }

    public static FieldValueImpl promote(FieldValueImpl value, ExprType type) {
        if (type.containsValue(value)) {
            return value;
        }
        FieldValueImpl retValue = null;
        FieldDef.Type valueCode = value.getType();
        ExprType.TypeCode typeCode = type.getCode();
        switch (valueCode) {
            case INTEGER: {
                if (typeCode == ExprType.TypeCode.FLOAT) {
                    return TypeManager.castIntToFloat(value, type);
                }
                if (typeCode != ExprType.TypeCode.DOUBLE) break;
                return TypeManager.castIntToDouble(value, type);
            }
            case LONG: {
                if (typeCode == ExprType.TypeCode.FLOAT) {
                    return TypeManager.castLongToFloat(value, type);
                }
                if (typeCode != ExprType.TypeCode.DOUBLE) break;
                return TypeManager.castLongToDouble(value, type);
            }
            case STRING: {
                if (typeCode != ExprType.TypeCode.ENUM) break;
                return TypeManager.castStringToEnum(value, type);
            }
        }
        return retValue;
    }

    private static FieldValueImpl castIntToFloat(FieldValueImpl value, ExprType type) {
        assert (type.getDef() != null);
        int baseValue = value.getInt();
        try {
            return FieldDefImpl.floatDef.createFloat(baseValue);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static FieldValueImpl castIntToDouble(FieldValueImpl value, ExprType type) {
        assert (type.getDef() != null);
        int baseValue = value.getInt();
        try {
            return FieldDefImpl.doubleDef.createDouble(baseValue);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static FieldValueImpl castLongToFloat(FieldValueImpl value, ExprType type) {
        assert (type.getDef() != null);
        long baseValue = value.getLong();
        try {
            return FieldDefImpl.floatDef.createFloat(baseValue);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static FieldValueImpl castLongToDouble(FieldValueImpl value, ExprType type) {
        assert (type.getDef() != null);
        long baseValue = value.getLong();
        try {
            return FieldDefImpl.doubleDef.createDouble(baseValue);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static FieldValueImpl castStringToEnum(FieldValueImpl value, ExprType type) {
        assert (type.getDef() != null);
        EnumDefImpl typeDef = (EnumDefImpl)type.getDef();
        String baseValue = value.getString();
        try {
            return typeDef.createEnum(baseValue);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void serializeExprType(ExprType type, DataOutput out, short serialVersion) throws IOException {
        if (serialVersion < 13) {
            out.writeByte(type.getCode().ordinal());
            out.writeByte(type.getQuantifier().ordinal());
            boolean builtin = type.isBuiltin();
            out.writeBoolean(builtin);
            if (!builtin) {
                FieldDefSerialization.writeFieldDef(type.getDef(), out, serialVersion);
            }
        } else {
            out.writeByte(type.getQuantifier().ordinal());
            FieldDefSerialization.writeFieldDef(type.getDef(), out, serialVersion);
        }
    }

    public static ExprType deserializeExprType(DataInput in, short serialVersion) throws IOException {
        if (serialVersion < 13) {
            byte ordinal = in.readByte();
            ExprType.TypeCode typeCode = ExprType.TypeCode.values()[ordinal];
            ordinal = in.readByte();
            ExprType.Quantifier quant = ExprType.Quantifier.values()[ordinal];
            boolean builtin = in.readBoolean();
            if (builtin) {
                return TypeManager.getBuiltinType(typeCode, quant);
            }
            FieldDefImpl def = FieldDefSerialization.readFieldDef(in, serialVersion);
            return new ExprType(def, quant, false);
        }
        byte ordinal = in.readByte();
        ExprType.Quantifier quant = ExprType.Quantifier.values()[ordinal];
        FieldDefImpl def = FieldDefSerialization.readFieldDef(in, serialVersion);
        return TypeManager.createType(def, quant);
    }
}

