/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.hadoop.hive.table;

import oracle.kv.table.FieldValue;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableLongObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.LongWritable;

public class TableLongObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements SettableLongObjectInspector {
    private static long DEFAULT_VALUE = 0L;

    TableLongObjectInspector() {
        super(TypeInfoFactory.longTypeInfo);
    }

    public Object getPrimitiveWritableObject(Object o) {
        return o == null ? null : new LongWritable(this.get(o));
    }

    public long get(Object o) {
        if (o == null) {
            return DEFAULT_VALUE;
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof FieldValue) {
            if (((FieldValue)o).isNull()) {
                return DEFAULT_VALUE;
            }
            return ((FieldValue)o).asLong().get();
        }
        throw new IllegalArgumentException("invalid object type: must be Long or LongValue");
    }

    public Object create(long value) {
        return value;
    }

    public Object set(Object o, long value) {
        return value;
    }
}

