/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.util.FastOutputStream;
import com.sleepycat.util.PackedInteger;
import com.sleepycat.util.UtfOps;
import java.math.BigDecimal;
import java.math.BigInteger;

public class TupleOutput
extends FastOutputStream {
    static final int NULL_STRING_UTF_VALUE = -1;

    public TupleOutput() {
    }

    public TupleOutput(byte[] buffer) {
        super(buffer);
    }

    public final TupleOutput writeBytes(String val) {
        this.writeBytes(val.toCharArray());
        return this;
    }

    public final TupleOutput writeChars(String val) {
        this.writeChars(val.toCharArray());
        return this;
    }

    public final TupleOutput writeString(String val) {
        if (val != null) {
            this.writeString(val.toCharArray());
        } else {
            this.writeFast(-1);
        }
        this.writeFast(0);
        return this;
    }

    public final TupleOutput writeChar(int val) {
        this.writeFast((byte)(val >>> 8));
        this.writeFast((byte)val);
        return this;
    }

    public final TupleOutput writeBoolean(boolean val) {
        this.writeFast(val ? 1 : 0);
        return this;
    }

    public final TupleOutput writeByte(int val) {
        this.writeUnsignedByte(val ^ 0x80);
        return this;
    }

    public final TupleOutput writeShort(int val) {
        this.writeUnsignedShort(val ^ 0x8000);
        return this;
    }

    public final TupleOutput writeInt(int val) {
        this.writeUnsignedInt(val ^ Integer.MIN_VALUE);
        return this;
    }

    public final TupleOutput writeLong(long val) {
        this.writeUnsignedLong(val ^ Long.MIN_VALUE);
        return this;
    }

    public final TupleOutput writeFloat(float val) {
        this.writeUnsignedInt(Float.floatToIntBits(val));
        return this;
    }

    public final TupleOutput writeDouble(double val) {
        this.writeUnsignedLong(Double.doubleToLongBits(val));
        return this;
    }

    public final TupleOutput writeSortedFloat(float val) {
        int intVal;
        this.writeUnsignedInt(intVal ^= (intVal = Float.floatToIntBits(val)) < 0 ? -1 : Integer.MIN_VALUE);
        return this;
    }

    public final TupleOutput writeSortedDouble(double val) {
        long longVal;
        this.writeUnsignedLong(longVal ^= (longVal = Double.doubleToLongBits(val)) < 0L ? -1L : Long.MIN_VALUE);
        return this;
    }

    public final TupleOutput writeBytes(char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            this.writeFast((byte)chars[i]);
        }
        return this;
    }

    public final TupleOutput writeChars(char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            this.writeFast((byte)(chars[i] >>> 8));
            this.writeFast((byte)chars[i]);
        }
        return this;
    }

    public final TupleOutput writeString(char[] chars) {
        if (chars.length == 0) {
            return this;
        }
        int utfLength = UtfOps.getByteLength(chars);
        this.makeSpace(utfLength);
        UtfOps.charsToBytes(chars, 0, this.getBufferBytes(), this.getBufferLength(), chars.length);
        this.addSize(utfLength);
        return this;
    }

    public final TupleOutput writeUnsignedByte(int val) {
        this.writeFast(val);
        return this;
    }

    public final TupleOutput writeUnsignedShort(int val) {
        this.writeFast((byte)(val >>> 8));
        this.writeFast((byte)val);
        return this;
    }

    public final TupleOutput writeUnsignedInt(long val) {
        this.writeFast((byte)(val >>> 24));
        this.writeFast((byte)(val >>> 16));
        this.writeFast((byte)(val >>> 8));
        this.writeFast((byte)val);
        return this;
    }

    private final TupleOutput writeUnsignedLong(long val) {
        this.writeFast((byte)(val >>> 56));
        this.writeFast((byte)(val >>> 48));
        this.writeFast((byte)(val >>> 40));
        this.writeFast((byte)(val >>> 32));
        this.writeFast((byte)(val >>> 24));
        this.writeFast((byte)(val >>> 16));
        this.writeFast((byte)(val >>> 8));
        this.writeFast((byte)val);
        return this;
    }

    public final TupleOutput writePackedInt(int val) {
        this.makeSpace(5);
        int oldLen = this.getBufferLength();
        int newLen = PackedInteger.writeInt(this.getBufferBytes(), oldLen, val);
        this.addSize(newLen - oldLen);
        return this;
    }

    public final TupleOutput writePackedLong(long val) {
        this.makeSpace(9);
        int oldLen = this.getBufferLength();
        int newLen = PackedInteger.writeLong(this.getBufferBytes(), oldLen, val);
        this.addSize(newLen - oldLen);
        return this;
    }

    public final TupleOutput writeSortedPackedInt(int val) {
        this.makeSpace(5);
        int oldLen = this.getBufferLength();
        int newLen = PackedInteger.writeSortedInt(this.getBufferBytes(), oldLen, val);
        this.addSize(newLen - oldLen);
        return this;
    }

    public final TupleOutput writeSortedPackedLong(long val) {
        this.makeSpace(9);
        int oldLen = this.getBufferLength();
        int newLen = PackedInteger.writeSortedLong(this.getBufferBytes(), oldLen, val);
        this.addSize(newLen - oldLen);
        return this;
    }

    public final TupleOutput writeBigInteger(BigInteger val) {
        byte[] a = val.toByteArray();
        if (a.length > Short.MAX_VALUE) {
            throw new IllegalArgumentException("BigInteger byte array is larger than 0x7fff bytes");
        }
        byte firstByte = a[0];
        this.writeShort(firstByte < 0 ? -a.length : a.length);
        this.writeByte(firstByte);
        this.writeFast(a, 1, a.length - 1);
        return this;
    }

    public static int getBigIntegerByteLength(BigInteger val) {
        return 2 + (val.bitLength() + 1 + 7) / 8;
    }

    public final TupleOutput writeBigDecimal(BigDecimal val) {
        int scale = val.scale();
        BigInteger unscaledVal = val.unscaledValue();
        this.writePackedInt(scale);
        byte[] a = unscaledVal.toByteArray();
        int len = a.length;
        this.writePackedInt(len);
        this.writeFast(a, 0, len);
        return this;
    }

    public static int getBigDecimalMaxByteLength(BigDecimal val) {
        BigInteger unscaledVal = val.unscaledValue();
        return 10 + unscaledVal.toByteArray().length;
    }

    public final TupleOutput writeSortedBigDecimal(BigDecimal val) {
        BigDecimal valNoTrailZeros = val.stripTrailingZeros();
        int scale = valNoTrailZeros.scale();
        BigInteger unscaledVal = valNoTrailZeros.unscaledValue();
        int sign = valNoTrailZeros.signum();
        String unscaledValStr = unscaledVal.abs().toString();
        int normalizedScale = unscaledValStr.length() - 1;
        BigDecimal normalizedVal = new BigDecimal(unscaledVal, normalizedScale);
        int exponent = (normalizedScale - scale) * sign;
        this.writeByte(sign);
        this.writeSortedPackedInt(exponent);
        this.writeSortedNormalizedBigDecimal(normalizedVal);
        return this;
    }

    private final TupleOutput writeSortedNormalizedBigDecimal(BigDecimal val) {
        int precision = val.precision();
        int scale = val.scale();
        int sign = val.signum();
        String digitsStr = val.abs().toPlainString();
        StringBuilder groupDigits = new StringBuilder();
        int i = 0;
        while (i < digitsStr.length()) {
            char digit;
            if ((digit = digitsStr.charAt(i++)) != '.') {
                groupDigits.append(digit);
            }
            if (i == digitsStr.length() && groupDigits.length() < 9) {
                int insertLen = 9 - groupDigits.length();
                for (int k = 0; k < insertLen; ++k) {
                    groupDigits.append("0");
                }
            }
            if (groupDigits.length() != 9) continue;
            int subVal = Integer.valueOf(groupDigits.toString());
            if (sign < 0) {
                subVal = -subVal;
            }
            subVal = subVal < 0 ? subVal - 1 : subVal;
            this.writeSortedPackedInt(subVal);
            groupDigits.setLength(0);
        }
        this.writeSortedPackedInt(-1);
        return this;
    }

    public static int getSortedBigDecimalMaxByteLength(BigDecimal val) {
        String digitsStr = val.stripTrailingZeros().unscaledValue().abs().toString();
        int numOfGroups = (digitsStr.length() + 8) / 9;
        return 6 + 5 * numOfGroups + 1;
    }
}

