/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.login;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import oracle.kv.impl.security.login.SessionId;
import oracle.kv.impl.util.FastExternalizable;
import oracle.kv.impl.util.SerialVersion;

public final class LoginToken
implements Serializable,
FastExternalizable {
    private static final long serialVersionUID = 1L;
    private long expireAt;
    private SessionId sessionId;

    public LoginToken(SessionId sessionId, long expireTime) {
        this.sessionId = sessionId;
        this.expireAt = expireTime;
    }

    public LoginToken(DataInput in, short serialVersion) throws IOException {
        this.expireAt = in.readLong();
        this.sessionId = new SessionId(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        out.writeLong(this.expireAt);
        this.sessionId.writeFastExternal(out, serialVersion);
    }

    public SessionId getSessionId() {
        return this.sessionId;
    }

    public long getExpireTime() {
        return this.expireAt;
    }

    public byte[] toByteArray() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeShort(SerialVersion.CURRENT);
            this.writeFastExternal(oos, SerialVersion.CURRENT);
            oos.close();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Unabled to encode", ioe);
        }
    }

    public static LoginToken fromByteArray(byte[] bytes) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            short version = ois.readShort();
            assert (version == SerialVersion.CURRENT);
            LoginToken result = new LoginToken(ois, version);
            ois.close();
            return result;
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Unable to decode", ioe);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || other.getClass() != LoginToken.class) {
            return false;
        }
        LoginToken otherToken = (LoginToken)other;
        return this.expireAt == otherToken.expireAt && (this.sessionId == otherToken.sessionId || this.sessionId != null && this.sessionId.equals(otherToken.sessionId));
    }

    public int hashCode() {
        int result = (int)this.expireAt;
        return result += this.hashId();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LoginToken: expires=");
        sb.append(this.expireAt);
        sb.append(", id=");
        sb.append(this.hashId());
        return sb.toString();
    }

    public int hashId() {
        return this.sessionId.hashId();
    }
}

