/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.login;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.security.login.LoginResult;
import oracle.kv.impl.security.login.LoginToken;
import oracle.kv.impl.util.SerializationUtil;

public class KerberosLoginResult
extends LoginResult {
    private static final long serialVersionUID = 1L;
    private byte[] mutualAuthenToken;

    public KerberosLoginResult(byte[] token) {
        super(null);
        this.mutualAuthenToken = token;
    }

    public KerberosLoginResult(LoginToken loginToken, byte[] authenToken) {
        super(loginToken);
        this.mutualAuthenToken = authenToken;
    }

    public KerberosLoginResult(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.mutualAuthenToken = SerializationUtil.readNonNullByteArrayOldShortLength(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        SerializationUtil.writeNonNullByteArrayOldShortLength(out, serialVersion, this.mutualAuthenToken);
    }

    public byte[] getMutualAuthToken() {
        return this.mutualAuthenToken;
    }
}

