/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import oracle.kv.impl.query.compiler.parser.KVQLParser;
import org.antlr.v4.runtime.tree.ParseTreeProperty;

public class JsonCollector
extends ParseTreeProperty<String> {
    public void exitJsonAtom(KVQLParser.JsonAtomContext ctx) {
        this.put(ctx, ctx.getText());
    }

    public void exitJsonObjectValue(KVQLParser.JsonObjectValueContext ctx) {
        this.put(ctx, (String)this.get(ctx.jsobject()));
    }

    public void exitJsonArrayValue(KVQLParser.JsonArrayValueContext ctx) {
        this.put(ctx, (String)this.get(ctx.jsarray()));
    }

    public void exitJsonPair(KVQLParser.JsonPairContext ctx) {
        String tag = ctx.DSTRING().getText();
        KVQLParser.JsvalueContext valuectx = ctx.jsvalue();
        String x = String.format("%s : %s", tag, this.get(valuectx));
        this.put(ctx, x);
    }

    public void exitArrayOfJsonValues(KVQLParser.ArrayOfJsonValuesContext ctx) {
        StringBuilder s = new StringBuilder();
        s.append("[");
        for (KVQLParser.JsvalueContext valuectx : ctx.jsvalue()) {
            s.append((String)this.get(valuectx)).append(", ");
        }
        JsonCollector.dropFinalComma(s);
        s.append("]");
        this.put(ctx, s.toString());
    }

    public void exitEmptyJsonArray(KVQLParser.EmptyJsonArrayContext ctx) {
        this.put(ctx, "[]");
    }

    public void exitJsonObject(KVQLParser.JsonObjectContext ctx) {
        StringBuilder s = new StringBuilder();
        s.append("{");
        for (KVQLParser.JspairContext pairctx : ctx.jspair()) {
            s.append((String)this.get(pairctx)).append(", ");
        }
        JsonCollector.dropFinalComma(s);
        s.append("}");
        this.put(ctx, s.toString());
    }

    public void exitEmptyJsonObject(KVQLParser.EmptyJsonObjectContext ctx) {
        this.put(ctx, "{}");
    }

    public void exitJson_text(KVQLParser.Json_textContext ctx) {
        this.put(ctx, (String)this.get(ctx.getChild(0)));
    }

    private static void dropFinalComma(StringBuilder s) {
        int length = s.length();
        if (length >= 1 && s.charAt(length - 1) == ',') {
            s.delete(s.length() - 1, s.length());
        } else if (length >= 2 && s.charAt(length - 1) == ' ' && s.charAt(length - 2) == ',') {
            s.delete(s.length() - 2, s.length());
        }
    }
}

