/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async;

import java.nio.ByteBuffer;
import java.util.Collection;

public class BytesUtil {
    public static final int NUM_BYTES_PER_LINE = 16;

    public static String bytesToHex(byte[] array, int offset, int len) {
        char[] hexArray = new char[len * 3];
        for (int i = 0; i < len; ++i) {
            int v = array[i + offset] & 0xFF;
            hexArray[i * 3] = Character.forDigit(v >>> 4, 16);
            hexArray[i * 3 + 1] = Character.forDigit(v & 0xF, 16);
            hexArray[i * 3 + 2] = (i + 1) % 16 == 0 ? 10 : 32;
        }
        return new String(hexArray);
    }

    public static int bytesToInt(byte[] array, int offset) {
        return (array[offset] << 24) + ((array[offset + 1] & 0xFF) << 16) + ((array[offset + 2] & 0xFF) << 8) + (array[offset + 3] & 0xFF);
    }

    public static String bytebufToHex(ByteBuffer buf, int offset, int len) {
        char[] hexArray = new char[len * 3];
        for (int i = 0; i < len; ++i) {
            int v = buf.get(i + offset) & 0xFF;
            hexArray[i * 3] = Character.forDigit(v >>> 4, 16);
            hexArray[i * 3 + 1] = Character.forDigit(v & 0xF, 16);
            hexArray[i * 3 + 2] = (i + 1) % 16 == 0 ? 10 : 32;
        }
        return new String(hexArray);
    }

    public static String toString(byte[] array, int offset, int len) {
        if (array == null) {
            return "[/]";
        }
        len = Math.min(len, array.length - offset);
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("(").append(offset).append(",").append(len).append(")");
        if (offset > 0) {
            builder.append("...");
        }
        builder.append(BytesUtil.bytesToHex(array, offset, len));
        if (offset + len < array.length) {
            builder.append("...");
        }
        builder.append("]");
        return builder.toString();
    }

    public static String toString(ByteBuffer buf, int len) {
        if (buf == null) {
            return "[/]";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        int pos = buf.position();
        int lim = buf.limit();
        int cap = buf.capacity();
        builder.append("(").append(pos).append(",").append(lim).append(",").append(cap).append(")");
        int lenZero = Math.min(pos, len);
        int lenPos = Math.min(lim - pos, len);
        builder.append(BytesUtil.bytebufToHex(buf, 0, lenZero));
        if (lenZero < pos) {
            builder.append("...");
        }
        builder.append(BytesUtil.bytebufToHex(buf, pos, lenPos));
        if (lenPos < lim - pos) {
            builder.append("...");
        }
        builder.append("]");
        return builder.toString();
    }

    public static String toString(ByteBuffer[] buffers, int offset, int nbufs, int len) {
        if (buffers == null) {
            return "{/}";
        }
        nbufs = Math.min(buffers.length - offset, nbufs);
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append("(").append(offset).append(")");
        if (offset > 0) {
            builder.append("...");
        }
        for (int i = offset; i < offset + nbufs; ++i) {
            builder.append(BytesUtil.toString(buffers[i], len));
        }
        if (offset + nbufs < buffers.length) {
            builder.append("...");
        }
        builder.append("}");
        return builder.toString();
    }

    public static String toString(Collection<ByteBuffer> bufs, int offset, int nbufs, int len) {
        if (bufs == null) {
            return "{/}";
        }
        int cnt0 = offset;
        int cnt1 = Math.min(bufs.size(), nbufs);
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append("(").append(offset).append(")");
        if (offset > 0) {
            builder.append("...");
        }
        for (ByteBuffer buf : bufs) {
            if (--cnt0 > 0) continue;
            builder.append(BytesUtil.toString(buf, len));
            if (--cnt1 > 0) continue;
            break;
        }
        if (offset + nbufs < bufs.size()) {
            builder.append("...");
        }
        builder.append("}");
        return builder.toString();
    }
}

