/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.math.BigDecimal;
import java.util.Arrays;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.NumberDefImpl;
import oracle.kv.impl.api.table.NumberUtils;
import oracle.kv.impl.util.SizeOf;
import oracle.kv.impl.util.SortableString;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.NumberValue;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.DecimalNode;

public class NumberValueImpl
extends FieldValueImpl
implements NumberValue {
    private static final long serialVersionUID = 1L;
    private byte[] value;

    NumberValueImpl(long value) {
        this.value = NumberUtils.serialize(value);
    }

    NumberValueImpl(BigDecimal value) {
        this.value = NumberUtils.serialize(value);
    }

    public NumberValueImpl(byte[] value) {
        this.value = value;
    }

    NumberValueImpl(String keyValue) {
        this.value = SortableString.bytesFromSortable(keyValue);
    }

    @Override
    public NumberValueImpl clone() {
        return new NumberValueImpl(this.value);
    }

    @Override
    public long sizeof() {
        return SizeOf.OBJECT_OVERHEAD + SizeOf.OBJECT_REF_OVERHEAD + SizeOf.byteArraySize(this.value.length);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public boolean equals(Object other) {
        if (other instanceof NumberValueImpl) {
            return Arrays.equals(this.value, ((NumberValueImpl)other).value);
        }
        return false;
    }

    @Override
    public int compareTo(FieldValue other) {
        if (other instanceof NumberValueImpl) {
            return IndexImpl.compareUnsignedBytes(this.value, ((NumberValueImpl)other).value);
        }
        if (other.isNumeric()) {
            BigDecimal otherVal = null;
            switch (other.getType()) {
                case INTEGER: {
                    otherVal = BigDecimal.valueOf(other.asInteger().get());
                    break;
                }
                case LONG: {
                    otherVal = BigDecimal.valueOf(other.asLong().get());
                    break;
                }
                case FLOAT: {
                    otherVal = BigDecimal.valueOf(other.asFloat().get());
                    break;
                }
                case DOUBLE: {
                    otherVal = BigDecimal.valueOf(other.asDouble().get());
                    break;
                }
            }
            assert (otherVal != null);
            return this.get().compareTo(otherVal);
        }
        throw new ClassCastException("Object is not a numeric type");
    }

    public String toString() {
        return this.get().toString();
    }

    @Override
    public FieldDef.Type getType() {
        return FieldDef.Type.NUMBER;
    }

    @Override
    public NumberDefImpl getDefinition() {
        return FieldDefImpl.numberDef;
    }

    @Override
    public NumberValue asNumber() {
        return this;
    }

    @Override
    public boolean isNumber() {
        return true;
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public BigDecimal get() {
        return this.getDecimal();
    }

    @Override
    public BigDecimal getDecimal() {
        Object val = this.getNumericValue();
        if (val instanceof Integer) {
            return BigDecimal.valueOf(((Integer)val).intValue());
        }
        if (val instanceof Long) {
            return BigDecimal.valueOf((Long)val);
        }
        assert (val instanceof BigDecimal);
        return (BigDecimal)val;
    }

    @Override
    public void setDecimal(BigDecimal v) {
        this.value = NumberUtils.serialize(v);
    }

    @Override
    public int castAsInt() {
        Object val = this.getNumericValue();
        if (val instanceof Integer) {
            return (Integer)val;
        }
        if (val instanceof Long) {
            return ((Long)val).intValue();
        }
        assert (val instanceof BigDecimal);
        return ((BigDecimal)val).intValue();
    }

    @Override
    public long castAsLong() {
        Object val = this.getNumericValue();
        if (val instanceof Integer) {
            return ((Integer)val).longValue();
        }
        if (val instanceof Long) {
            return (Long)val;
        }
        assert (val instanceof BigDecimal);
        return this.getDecimal().longValue();
    }

    @Override
    public float castAsFloat() {
        Object val = this.getNumericValue();
        if (val instanceof Integer) {
            return ((Integer)val).floatValue();
        }
        if (val instanceof Long) {
            return ((Long)val).floatValue();
        }
        assert (val instanceof BigDecimal);
        return ((BigDecimal)val).floatValue();
    }

    @Override
    public double castAsDouble() {
        Object val = this.getNumericValue();
        if (val instanceof Integer) {
            return ((Integer)val).doubleValue();
        }
        if (val instanceof Long) {
            return ((Long)val).doubleValue();
        }
        assert (val instanceof BigDecimal);
        return ((BigDecimal)val).doubleValue();
    }

    @Override
    public BigDecimal castAsDecimal() {
        return this.getDecimal();
    }

    @Override
    public String castAsString() {
        Object val = this.getNumericValue();
        return val.toString();
    }

    private Object getNumericValue() {
        return NumberUtils.deserialize(this.value);
    }

    @Override
    public String formatForKey(FieldDef field1, int storageSize) {
        return NumberValueImpl.toKeyString(this.value);
    }

    @Override
    FieldValueImpl getNextValue() {
        return new NumberValueImpl(NumberUtils.nextUp(this.value));
    }

    @Override
    FieldValueImpl getMinimumValue() {
        return new NumberValueImpl(NumberUtils.getNegativeInfinity());
    }

    @Override
    public JsonNode toJsonNode() {
        return new DecimalNode(this.getDecimal());
    }

    @Override
    public void toStringBuilder(StringBuilder sb) {
        sb.append(this.toString());
    }

    @Override
    public byte[] getBytes() {
        return this.value;
    }

    static String toKeyString(byte[] bytes) {
        return SortableString.toSortable(bytes);
    }

    @Override
    public byte[] getNumberBytes() {
        return this.getBytes();
    }
}

