/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.api.table.ArrayDefImpl;
import oracle.kv.impl.api.table.EnumDefImpl;
import oracle.kv.impl.api.table.FieldDefFactory;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldMap;
import oracle.kv.impl.api.table.FieldMapEntry;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.FieldValueSerialization;
import oracle.kv.impl.api.table.FixedBinaryDefImpl;
import oracle.kv.impl.api.table.MapDefImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.TimestampDefImpl;
import oracle.kv.impl.util.SerializationUtil;
import oracle.kv.table.ArrayDef;
import oracle.kv.table.EnumDef;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FixedBinaryDef;
import oracle.kv.table.MapDef;
import oracle.kv.table.TimestampDef;

public class FieldDefSerialization {
    public static void writeFieldDef(FieldDef def, DataOutput out, short serialVersion) throws IOException {
        def.getType().writeFastExternal(out, serialVersion);
        switch (def.getType()) {
            case INTEGER: 
            case LONG: 
            case DOUBLE: 
            case FLOAT: 
            case STRING: 
            case BINARY: 
            case BOOLEAN: 
            case NUMBER: 
            case ANY: 
            case ANY_ATOMIC: 
            case ANY_RECORD: 
            case EMPTY: 
            case JSON: 
            case ANY_JSON_ATOMIC: {
                break;
            }
            case FIXED_BINARY: {
                FieldDefSerialization.writeFixedBinary(def.asFixedBinary(), out, serialVersion);
                break;
            }
            case ENUM: {
                FieldDefSerialization.writeEnum(def.asEnum(), out, serialVersion);
                break;
            }
            case TIMESTAMP: {
                FieldDefSerialization.writeTimestamp(def.asTimestamp(), out, serialVersion);
                break;
            }
            case RECORD: {
                FieldDefSerialization.writeRecord((RecordDefImpl)def, out, serialVersion);
                break;
            }
            case MAP: {
                FieldDefSerialization.writeMap(def.asMap(), out, serialVersion);
                break;
            }
            case ARRAY: {
                FieldDefSerialization.writeArray(def.asArray(), out, serialVersion);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public static void writeFixedBinary(FixedBinaryDef def, DataOutput out, short serialVersion) throws IOException {
        int size = def.getSize();
        SerializationUtil.writeNonNullSequenceLength(out, size);
    }

    public static void writeRecord(RecordDefImpl def, DataOutput out, short serialVersion) throws IOException {
        SerializationUtil.writeString(out, serialVersion, def.getName());
        SerializationUtil.writeNonNullSequenceLength(out, def.getNumFields());
        for (FieldMapEntry fme : def.getFieldProperties()) {
            String fname = fme.getFieldName();
            FieldDefImpl fdef = fme.getFieldDef();
            SerializationUtil.writeString(out, serialVersion, fname);
            FieldDefSerialization.writeFieldDef(fdef, out, serialVersion);
            boolean nullable = fme.isNullable();
            out.writeBoolean(nullable);
            if (nullable) continue;
            FieldValueImpl defVal = fme.getDefaultValue();
            assert (defVal != null);
            FieldValueSerialization.writeFieldValue(defVal, fdef.isWildcard(), out, serialVersion);
        }
    }

    public static void writeMap(MapDef def, DataOutput out, short serialVersion) throws IOException {
        FieldDefSerialization.writeFieldDef(def.getElement(), out, serialVersion);
    }

    public static void writeArray(ArrayDef def, DataOutput out, short serialVersion) throws IOException {
        FieldDefSerialization.writeFieldDef(def.getElement(), out, serialVersion);
    }

    public static void writeEnum(EnumDef def, DataOutput out, short serialVersion) throws IOException {
        String[] values = def.getValues();
        SerializationUtil.writeNonNullSequenceLength(out, values.length);
        for (String value : values) {
            SerializationUtil.writeString(out, serialVersion, value);
        }
    }

    public static void writeTimestamp(TimestampDef def, DataOutput out, short serialVersion) throws IOException {
        SerializationUtil.writePackedInt(out, def.getPrecision());
    }

    public static FieldDefImpl readFieldDef(DataInput in, short serialVersion) throws IOException {
        FieldDef.Type type = FieldDef.Type.readFastExternal(in, serialVersion);
        switch (type) {
            case INTEGER: {
                return FieldDefImpl.integerDef;
            }
            case LONG: {
                return FieldDefImpl.longDef;
            }
            case DOUBLE: {
                return FieldDefImpl.doubleDef;
            }
            case FLOAT: {
                return FieldDefImpl.floatDef;
            }
            case STRING: {
                return FieldDefImpl.stringDef;
            }
            case BINARY: {
                return FieldDefImpl.binaryDef;
            }
            case BOOLEAN: {
                return FieldDefImpl.booleanDef;
            }
            case NUMBER: {
                return FieldDefImpl.numberDef;
            }
            case FIXED_BINARY: {
                int size = SerializationUtil.readNonNullSequenceLength(in);
                return new FixedBinaryDefImpl(size, null);
            }
            case ENUM: {
                return FieldDefSerialization.readEnum(in, serialVersion);
            }
            case TIMESTAMP: {
                return FieldDefSerialization.readTimestamp(in, serialVersion);
            }
            case RECORD: {
                return FieldDefSerialization.readRecord(in, serialVersion);
            }
            case MAP: {
                return FieldDefSerialization.readMap(in, serialVersion);
            }
            case ARRAY: {
                return FieldDefSerialization.readArray(in, serialVersion);
            }
            case ANY: {
                return FieldDefImpl.anyDef;
            }
            case ANY_ATOMIC: {
                return FieldDefImpl.anyAtomicDef;
            }
            case ANY_JSON_ATOMIC: {
                return FieldDefImpl.anyJsonAtomicDef;
            }
            case ANY_RECORD: {
                return FieldDefImpl.anyRecordDef;
            }
            case EMPTY: {
                return FieldDefImpl.emptyDef;
            }
            case JSON: {
                return FieldDefImpl.jsonDef;
            }
        }
        throw new IllegalStateException("Unknown type code: " + type);
    }

    static RecordDefImpl readRecord(DataInput in, short serialVersion) throws IOException {
        String name = SerializationUtil.readString(in, serialVersion);
        int size = SerializationUtil.readNonNullSequenceLength(in);
        FieldMap fieldMap = new FieldMap();
        for (int i = 0; i < size; ++i) {
            String fname = SerializationUtil.readString(in, serialVersion);
            FieldDefImpl fdef = FieldDefSerialization.readFieldDef(in, serialVersion);
            boolean nullable = in.readBoolean();
            FieldValueImpl defVal = null;
            if (!nullable) {
                defVal = (FieldValueImpl)FieldValueSerialization.readFieldValue(fdef.isWildcard() ? null : fdef, in, serialVersion);
            }
            fieldMap.put(fname, fdef, nullable, defVal);
        }
        if (name == null) {
            return new RecordDefImpl(fieldMap, null);
        }
        return new RecordDefImpl(name, fieldMap);
    }

    static MapDefImpl readMap(DataInput in, short serialVersion) throws IOException {
        return FieldDefFactory.createMapDef(FieldDefSerialization.readFieldDef(in, serialVersion));
    }

    static ArrayDefImpl readArray(DataInput in, short serialVersion) throws IOException {
        return FieldDefFactory.createArrayDef(FieldDefSerialization.readFieldDef(in, serialVersion));
    }

    static EnumDefImpl readEnum(DataInput in, short serialVersion) throws IOException {
        int numValues = SerializationUtil.readNonNullSequenceLength(in);
        String[] values = new String[numValues];
        for (int i = 0; i < numValues; ++i) {
            values[i] = SerializationUtil.readString(in, serialVersion);
        }
        return new EnumDefImpl(values, null);
    }

    static TimestampDefImpl readTimestamp(DataInput in, short serialVersion) throws IOException {
        return new TimestampDefImpl(SerializationUtil.readPackedInt(in));
    }
}

