/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.util.FastExternalizable;
import oracle.kv.impl.util.ObjectUtil;
import oracle.kv.impl.util.SerializationUtil;

public class ResultKey
implements FastExternalizable {
    private final byte[] keyBytes;
    private final long expirationTime;

    public ResultKey(byte[] keyBytes, long expirationTime) {
        ObjectUtil.checkNull("keyBytes", keyBytes);
        this.keyBytes = keyBytes;
        this.expirationTime = expirationTime;
    }

    public ResultKey(byte[] keyBytes) {
        this(keyBytes, 0L);
    }

    public ResultKey(DataInput in, short serialVersion) throws IOException {
        this.keyBytes = SerializationUtil.readNonNullByteArrayOldShortLength(in, serialVersion);
        this.expirationTime = Result.readExpirationTime(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        SerializationUtil.writeNonNullByteArrayOldShortLength(out, serialVersion, this.keyBytes);
        Result.writeExpirationTime(out, this.expirationTime, serialVersion);
    }

    public byte[] getKeyBytes() {
        return this.keyBytes;
    }

    public boolean hasExpirationTime() {
        return this.expirationTime != 0L;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }
}

