/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.workbenchintegration;

import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.factories.XMLProjectReader;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class ProjectXMLStoredFunctionCallTest
extends TestCase {
    private DatabaseQuery query;
    private ClassDescriptor employeeDescriptor;
    private Object result;

    public ProjectXMLStoredFunctionCallTest() {
        this.setDescription("Tests that sepecified stored function can read from XML and execute correctly.");
    }

    public void reset() {
    }

    public void setup() {
        if (!this.getSession().getPlatform().isOracle()) {
            throw new TestWarningException("This test can only be run in Oracle");
        }
        Project project = null;
        try {
            project = XMLProjectReader.read((String)"MWIntegrationCustomSQLEmployeeProject.xml", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (Exception e) {
            throw new TestErrorException("The stored function was read from or written to XML incorrectly", (Throwable)e);
        }
        this.employeeDescriptor = project.getDescriptor(Employee.class);
        this.query = this.employeeDescriptor.getQueryManager().getQuery("StoredFunctionCallInNamedQuery");
        if (this.query == null) {
            throw new TestErrorException("The query was incorrectly either read from or write to XML. Expected: [StoredFunctionCallInNamedQuery]");
        }
    }

    public void test() {
        Vector<Long> parameters = new Vector<Long>();
        Long p_inout = 99L;
        Long p_in = 100L;
        parameters.add(p_inout);
        parameters.add(p_in);
        this.result = this.getSession().executeQuery(this.query, parameters);
    }

    public void verify() {
        DatabaseRecord row = (DatabaseRecord)((Vector)this.result).firstElement();
        Long p_inout = (Long)row.get("P_INOUT");
        if (!p_inout.equals(100L)) {
            throw new TestErrorException("The stored function did not execute correctly. Expected: [P_INOUT = 100]");
        }
        Long p_out = (Long)row.get("P_OUT");
        if (!p_out.equals(99L)) {
            throw new TestErrorException("The stored function did not execute correctly. Expected: [P_OUT = 99]");
        }
        Long returnValue = (Long)row.getValues().firstElement();
        if (!returnValue.equals(99L)) {
            throw new TestErrorException("The stored function did not execute correctly. Expected: [return value = 99]");
        }
        throw new TestWarningException("The stored function did not convert returned results correctly. Expected: [Long], Actual: [Integer]");
    }
}

