/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.workbenchintegration;

import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.PessimisticLockingPolicy;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.factories.XMLProjectReader;
import org.eclipse.persistence.sessions.factories.XMLProjectWriter;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeProject;

public class CMPDescriptorPessimisticLockingTest
extends AutoVerifyTestCase {
    public static final String PROJECT_FILE = "CustomCMPDescriptorWithPessLockingProject.xml";

    public CMPDescriptorPessimisticLockingTest() {
        this.setDescription("Validate bean-level pessimistic locking configured with the CMPDescriptor");
    }

    protected void setup() {
        EmployeeProject project = new EmployeeProject();
        ClassDescriptor employeeDescriptor = (ClassDescriptor)project.getDescriptors().get(Employee.class);
        ClassDescriptor addressDescriptor = (ClassDescriptor)project.getDescriptors().get(Address.class);
        employeeDescriptor.setCMPPolicy(new CMPPolicy());
        addressDescriptor.setCMPPolicy(new CMPPolicy());
        employeeDescriptor.getCMPPolicy().setPessimisticLockingPolicy(new PessimisticLockingPolicy());
        addressDescriptor.getCMPPolicy().setPessimisticLockingPolicy(new PessimisticLockingPolicy());
        employeeDescriptor.getCMPPolicy().getPessimisticLockingPolicy().setLockingMode((short)1);
        addressDescriptor.getCMPPolicy().getPessimisticLockingPolicy().setLockingMode((short)2);
        XMLProjectWriter.write((String)PROJECT_FILE, (Project)project);
    }

    protected void test() {
        Project project = XMLProjectReader.read((String)PROJECT_FILE, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        ClassDescriptor employeeDescriptor = (ClassDescriptor)project.getDescriptors().get(Employee.class);
        ClassDescriptor addressDescriptor = (ClassDescriptor)project.getDescriptors().get(Address.class);
        if (!employeeDescriptor.hasPessimisticLockingPolicy()) {
            throw new TestErrorException("'Employee descriptor was not written or read correctly");
        }
        if (employeeDescriptor.getCMPPolicy().getPessimisticLockingPolicy().getLockingMode() != 1) {
            throw new TestErrorException("'Employee descriptor was not written or read correctly with pessimistic locking LOCK mode");
        }
        if (!addressDescriptor.hasPessimisticLockingPolicy()) {
            throw new TestErrorException("'Address descriptor was not written or read correctly");
        }
        if (addressDescriptor.getCMPPolicy().getPessimisticLockingPolicy().getLockingMode() != 2) {
            throw new TestErrorException("'Address descriptor was not written or read correctly with pessimistic locking LOCK_NOWAIT mode");
        }
    }

    public static void main(String[] args) {
        try {
            CMPDescriptorPessimisticLockingTest test = new CMPDescriptorPessimisticLockingTest();
            test.setup();
            test.test();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

