/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.remote;

import junit.framework.Test;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeSystem;
import org.eclipse.persistence.testing.models.inheritance.InheritanceSystem;
import org.eclipse.persistence.testing.models.insurance.InsuranceSystem;
import org.eclipse.persistence.testing.models.mapping.MappingSystem;
import org.eclipse.persistence.testing.models.ownership.OwnershipSystem;
import org.eclipse.persistence.testing.models.readonly.DefaultReadOnlyTestClass;
import org.eclipse.persistence.testing.models.readonly.ReadOnlySystem;
import org.eclipse.persistence.testing.models.transparentindirection.IndirectListSystem;
import org.eclipse.persistence.testing.models.transparentindirection.IndirectMapSystem;
import org.eclipse.persistence.testing.tests.employee.EmployeeBasicTestModel;
import org.eclipse.persistence.testing.tests.feature.PrintIdentityMapTest;
import org.eclipse.persistence.testing.tests.insurance.InsuranceBasicTestModel;
import org.eclipse.persistence.testing.tests.queries.CascadingAllCacheTest;
import org.eclipse.persistence.testing.tests.queries.CascadingAllNoCacheTest;
import org.eclipse.persistence.testing.tests.queries.CascadingNoneCacheTest;
import org.eclipse.persistence.testing.tests.queries.CascadingNoneNoCacheTest;
import org.eclipse.persistence.testing.tests.queries.CascadingPrivateCacheTest;
import org.eclipse.persistence.testing.tests.queries.CascadingPrivateNoCacheTest;
import org.eclipse.persistence.testing.tests.queries.CursoredStreamTest;
import org.eclipse.persistence.testing.tests.queries.PessimisticLockTest;
import org.eclipse.persistence.testing.tests.queries.PredefinedInQueryReadAllTest;
import org.eclipse.persistence.testing.tests.queries.PredefinedQueryReadObjectTest;
import org.eclipse.persistence.testing.tests.queries.QueryCacheTest;
import org.eclipse.persistence.testing.tests.queries.RefreshTest;
import org.eclipse.persistence.testing.tests.queries.ScrollableCursorAPITest;
import org.eclipse.persistence.testing.tests.queries.ScrollableCursorBackwardReadingTest;
import org.eclipse.persistence.testing.tests.queries.ScrollableCursorNavigationAPITest;
import org.eclipse.persistence.testing.tests.queries.ScrollableCursorTest;
import org.eclipse.persistence.testing.tests.queries.options.QueryOptionSystem;
import org.eclipse.persistence.testing.tests.queries.report.ReportQuerySystem;
import org.eclipse.persistence.testing.tests.queries.report.ReportQueryTestSuite;
import org.eclipse.persistence.testing.tests.remote.BatchReadingForDirectCollectionMapping;
import org.eclipse.persistence.testing.tests.remote.CacheExpiryRemoteTest;
import org.eclipse.persistence.testing.tests.remote.CascadeWithoutIMOnRemote;
import org.eclipse.persistence.testing.tests.remote.DefaultReadOnlyClassTest;
import org.eclipse.persistence.testing.tests.remote.DescriptorRefreshCacheOnRemoteTest;
import org.eclipse.persistence.testing.tests.remote.MasterSlaveSystem;
import org.eclipse.persistence.testing.tests.remote.PredefinedQueryFromRemoteSessionTest;
import org.eclipse.persistence.testing.tests.remote.QueryCacheHitEnabledAndDescriptorDisabledOnRemoteTest;
import org.eclipse.persistence.testing.tests.remote.QueryCacheHitUndefinedAndDescriptorDisabledOnRemoteTest;
import org.eclipse.persistence.testing.tests.remote.QueryCacheHitUndefinedAndDescriptorEnabledOnRemoteTest;
import org.eclipse.persistence.testing.tests.remote.ReadingThroughRemoteScrollableCursor;
import org.eclipse.persistence.testing.tests.remote.RefreshCascadeNonPrivateTest;
import org.eclipse.persistence.testing.tests.remote.RefreshMaintainIdentityTest;
import org.eclipse.persistence.testing.tests.remote.RefreshObjectTest;
import org.eclipse.persistence.testing.tests.remote.RefreshRemoteIdentityMapResultsTest;
import org.eclipse.persistence.testing.tests.remote.RemoteSessionReadTimeTransferTest;
import org.eclipse.persistence.testing.tests.remote.RemoteValueHolderGarbageCollectedOriginalTest;
import org.eclipse.persistence.testing.tests.transparentindirection.IndirectListTestDatabaseRemote;
import org.eclipse.persistence.testing.tests.transparentindirection.IndirectMapTestDatabaseRemote;
import org.eclipse.persistence.testing.tests.transparentindirection.RemoteDataReadQueryTest;
import org.eclipse.persistence.testing.tests.transparentindirection.ZTestSuite;
import org.eclipse.persistence.testing.tests.unitofwork.UOWSystem;
import org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkEventTestSuite;
import org.eclipse.persistence.testing.tests.writing.ComplexUpdateAndUnitOfWorkTestModel;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public abstract class RemoteModel
extends TestModel {
    public static Session originalSession;
    protected static Session serverSession;

    public RemoteModel() {
        this.setDescription("It tests TopLink three tier model.");
    }

    public void addRequiredSystems() {
        this.addRequiredSystem(new EmployeeSystem());
        this.addRequiredSystem(new InsuranceSystem());
        this.addRequiredSystem(new UOWSystem());
        this.addRequiredSystem(new MappingSystem());
        this.addRequiredSystem(new OwnershipSystem());
        this.addRequiredSystem(new InheritanceSystem());
        this.addRequiredSystem(new IndirectListSystem());
        this.addRequiredSystem(new IndirectMapSystem());
        this.addRequiredSystem(new MasterSlaveSystem());
        this.addRequiredSystem(new ReadOnlySystem());
        this.addRequiredSystem(new QueryOptionSystem());
        this.addRequiredSystem(new ReportQuerySystem());
    }

    public void addTests() {
        this.addTest((Test)RemoteModel.getBasicReadTestSuite());
        this.addTest((Test)RemoteModel.getBasicUnitOfWorkTestSuite());
        this.addTest((Test)this.getUnitOfWorkEventTestSuite());
        this.addTest((Test)RemoteModel.getFeatureTestSuite());
        this.addTest((Test)RemoteModel.getQueryTestSuite());
        this.addTest((Test)RemoteModel.getRefreshObjectTestSuite());
        this.addTest((Test)new ReportQueryTestSuite());
        this.addTest((Test)RemoteModel.getTransparentIndirectionTestSuite());
        this.addTest((Test)new RemoteValueHolderGarbageCollectedOriginalTest(this.getSession()));
    }

    public Session buildServerSession() {
        ServerSession server = (ServerSession)this.getSession().getProject().clone().createServerSession();
        server.setSessionLog(this.getSession().getSessionLog());
        server.login();
        this.getSession().getProject().addDefaultReadOnlyClass(DefaultReadOnlyTestClass.class);
        serverSession = server.acquireClientSession();
        return serverSession;
    }

    public static TestSuite getBasicReadTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("BasicReadTestSuite");
        suite.setDescription("This suite tests the reading of objects remotely.");
        suite.addTest((Test)EmployeeBasicTestModel.getReadObjectTestSuite());
        suite.addTest((Test)EmployeeBasicTestModel.getReadAllTestSuite());
        suite.addTest((Test)InsuranceBasicTestModel.getReadObjectTestSuite());
        suite.addTest((Test)InsuranceBasicTestModel.getReadAllTestSuite());
        return suite;
    }

    public static TestSuite getBasicUnitOfWorkTestSuite() {
        return ComplexUpdateAndUnitOfWorkTestModel.getUnitOfWorkTestSuite();
    }

    public static TestSuite getFeatureTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("FeatureTestSuite");
        suite.setDescription("This suite tests the features on the remote model.");
        suite.addTest((Test)new CursoredStreamTest(Employee.class, new ExpressionBuilder().get("address").get("city").notEqual((Object)"Tuck chu")));
        suite.addTest((Test)new ScrollableCursorTest(Employee.class, new ExpressionBuilder().get("firstName").like("B%")));
        suite.addTest((Test)new ScrollableCursorTest(LargeProject.class, new ExpressionBuilder().get("teamLeader").get("firstName").like("Sarah%")));
        suite.addTest((Test)new ScrollableCursorAPITest());
        suite.addTest((Test)new ScrollableCursorBackwardReadingTest());
        suite.addTest((Test)new ScrollableCursorNavigationAPITest());
        suite.addTest((Test)new PredefinedQueryReadObjectTest(PopulationManager.getDefaultManager().getObject(Employee.class, "0001")));
        suite.addTest((Test)new PredefinedInQueryReadAllTest(Employee.class, 1));
        suite.addTest((Test)new PessimisticLockTest(1));
        suite.addTest((Test)new PessimisticLockTest(2));
        suite.addTest((Test)new PrintIdentityMapTest(Employee.class));
        suite.addTest((Test)new PrintIdentityMapTest());
        suite.addTest((Test)new DefaultReadOnlyClassTest());
        suite.addTest((Test)new RemoteSessionReadTimeTransferTest());
        suite.addTest((Test)new CacheExpiryRemoteTest());
        return suite;
    }

    public static TestSuite getQueryTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("QueryTestSuite");
        suite.setDescription("This suite tests features of queries (cascading, cache updating).");
        suite.addTest((Test)new RefreshTest());
        suite.addTest((Test)new RefreshCascadeNonPrivateTest());
        suite.addTest((Test)new CascadeWithoutIMOnRemote());
        suite.addTest((Test)new CascadingAllCacheTest());
        suite.addTest((Test)new CascadingAllNoCacheTest());
        suite.addTest((Test)new CascadingNoneCacheTest());
        suite.addTest((Test)new CascadingNoneNoCacheTest());
        suite.addTest((Test)new CascadingPrivateCacheTest());
        suite.addTest((Test)new CascadingPrivateNoCacheTest());
        suite.addTest((Test)new ReadingThroughRemoteScrollableCursor());
        suite.addTest((Test)new BatchReadingForDirectCollectionMapping());
        suite.addTest((Test)new PredefinedQueryFromRemoteSessionTest());
        suite.addTest((Test)new QueryCacheHitEnabledAndDescriptorDisabledOnRemoteTest());
        suite.addTest((Test)new QueryCacheHitUndefinedAndDescriptorEnabledOnRemoteTest());
        suite.addTest((Test)new QueryCacheHitUndefinedAndDescriptorDisabledOnRemoteTest());
        suite.addTest((Test)new QueryCacheTest());
        return suite;
    }

    public static TestSuite getRefreshObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("RefreshObjectTestSuite");
        suite.setDescription("This suite tests remote refreshing: Checks if null pointer exception is thrown.");
        suite.addTest((Test)new RefreshObjectTest());
        suite.addTest((Test)new DescriptorRefreshCacheOnRemoteTest());
        suite.addTest((Test)new RefreshMaintainIdentityTest());
        suite.addTest((Test)new RefreshRemoteIdentityMapResultsTest());
        return suite;
    }

    public static Session getServerSession() {
        return serverSession;
    }

    public static TestSuite getTransparentIndirectionTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("TransparentIndirectionTestSuite");
        suite.setDescription("Test remote Transparent Indirection");
        suite.addTest((Test)new ZTestSuite(IndirectListTestDatabaseRemote.class));
        suite.addTest((Test)new ZTestSuite(IndirectMapTestDatabaseRemote.class));
        suite.addTest((Test)new RemoteDataReadQueryTest());
        return suite;
    }

    public TestSuite getUnitOfWorkEventTestSuite() {
        UnitOfWorkEventTestSuite suite = new UnitOfWorkEventTestSuite();
        return suite;
    }

    public void reset() {
        if (originalSession != null) {
            this.getExecutor().getSession().release();
            this.getExecutor().setSession(originalSession);
        }
        RemoteModel.getServerSession().release();
        ((ClientSession)RemoteModel.getServerSession()).getParent().logout();
    }

    public static void setServerSession(Session session) {
        serverSession = session;
    }

    public abstract void setup();
}

