/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.readonly;

import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.readonly.Country;

public class DeleteReadOnlyDescriptorTestCase
extends AutoVerifyTestCase {
    public UnitOfWork uow;
    Country aCountry;

    public void reset() {
        this.rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    protected void setup() {
        this.beginTransaction();
        this.uow = this.getSession().acquireUnitOfWork();
        this.uow.getDescriptor(Country.class).setReadOnly();
    }

    protected void test() {
        this.aCountry = (Country)this.uow.readObject(Country.class);
        boolean caught = false;
        try {
            this.uow.deleteObject((Object)this.aCountry);
            this.uow.commit();
        }
        catch (QueryException ex) {
            this.getSession().logMessage("Delete of a read-only object threw an exception. OK.");
            caught = true;
        }
        if (!caught) {
            throw new TestErrorException("No exception was thrown when we illegally tried to delete a read-only object");
        }
    }

    protected void verify() {
        ExpressionBuilder xBuilder = new ExpressionBuilder();
        Expression exp = xBuilder.get("name").equal((Object)this.aCountry.name);
        Country dbCountry = (Country)this.getSession().readObject(Country.class, exp);
        if (dbCountry == null) {
            throw new TestErrorException("The Country object was deleted! It should not have been");
        }
    }
}

