/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.optimization;

import java.util.Vector;
import org.eclipse.persistence.annotations.BatchFetchType;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.legacy.Shipment;

public class OneToOneBatchReadingTest
extends TestCase {
    public Vector v;
    BatchFetchType batchType;

    public OneToOneBatchReadingTest(BatchFetchType batchType) {
        this.setDescription("Tests batch reading using 1 to 1 mapping and composite primary key");
        this.batchType = batchType;
        this.setName(this.getName() + batchType);
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.getAbstractSession().beginTransaction();
        if (this.batchType == BatchFetchType.IN && !this.getSession().getPlatform().isOracle()) {
            this.throwWarning("Nested arrays not supported on this database");
        }
    }

    public void test() {
        ReadAllQuery q = new ReadAllQuery();
        q.setBatchFetchType(this.batchType);
        q.setReferenceClass(Shipment.class);
        q.addBatchReadAttribute("employee");
        q.setSelectionCriteria(q.getExpressionBuilder().get("employee").get("address").equal(q.getExpressionBuilder().getParameter("ADDRESS")));
        q.addArgument("ADDRESS");
        Vector<String> r = new Vector<String>();
        r.addElement("885 Meadowlands Dr.");
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.v = (Vector)uow.executeQuery((DatabaseQuery)q, r);
    }

    public void verify() {
        Shipment s = (Shipment)this.v.firstElement();
        if (s.employee == null) {
            throw new TestWarningException("Test failed. Batched objects were not read");
        }
    }
}

