/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.inmemory;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class UnitOfWorkConformWithoutRegisteringTest
extends TestCase {
    protected int expected;
    protected UnitOfWork uow;
    protected Vector result;
    protected Object result2;
    protected Object result3;
    protected ReadAllQuery query;
    protected int numberOfOntarioAddresses;
    protected Employee emigrant;
    protected Employee emigrant2;
    protected Employee immigrant;
    protected Employee outsider2;

    public UnitOfWorkConformWithoutRegisteringTest() {
        this.setDescription("Test that the query conforms to changes but does not register objects.");
    }

    public void reset() {
        this.uow.release();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    protected void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.uow = this.getSession().acquireUnitOfWork();
        Expression expression = new ExpressionBuilder(Employee.class).get("address").get("province").equal((Object)"ONT");
        Vector ontarioEmployees = this.getSession().readAllObjects(Employee.class, expression);
        this.numberOfOntarioAddresses = ontarioEmployees.size();
        expression = new ExpressionBuilder(Employee.class).get("address").get("province").equal((Object)"ONT").not();
        Vector nonOntarioEmployees = this.getSession().readAllObjects(Employee.class, expression);
        Employee insider = (Employee)ontarioEmployees.elementAt(0);
        this.emigrant = (Employee)this.uow.registerExistingObject((Object)insider);
        this.emigrant.getAddress().setProvince("ICN");
        this.emigrant2 = (Employee)ontarioEmployees.elementAt(1);
        Address incheonAddress = (Address)this.uow.registerExistingObject((Object)this.emigrant2.getAddress());
        incheonAddress.setProvince("ICN");
        Employee outsider = (Employee)nonOntarioEmployees.elementAt(0);
        this.immigrant = (Employee)this.uow.registerExistingObject((Object)outsider);
        this.immigrant.getAddress().setProvince("ONT");
        this.query = new ReadAllQuery(Employee.class);
        expression = new ExpressionBuilder(Employee.class).get("address").get("province").equal((Object)"ONT");
        this.query.setSelectionCriteria(expression);
        this.query.setShouldRegisterResultsInUnitOfWork(false);
        this.query.conformResultsInUnitOfWork();
        this.query.getInMemoryQueryIndirectionPolicy().triggerIndirection();
    }

    public void test() {
        this.result = (Vector)this.uow.executeQuery((DatabaseQuery)this.query);
        ReadObjectQuery emigrantQuery = new ReadObjectQuery(Employee.class);
        ExpressionBuilder builder = new ExpressionBuilder(Employee.class);
        Expression expression = builder.get("address").get("province").equal((Object)"ONT");
        expression = expression.and(builder.get("firstName").equal((Object)this.emigrant.getFirstName()));
        emigrantQuery.setSelectionCriteria(expression);
        emigrantQuery.setShouldRegisterResultsInUnitOfWork(false);
        emigrantQuery.conformResultsInUnitOfWork();
        this.result2 = this.uow.executeQuery((DatabaseQuery)emigrantQuery);
        emigrantQuery = new ReadObjectQuery(Employee.class);
        builder = new ExpressionBuilder(Employee.class);
        expression = builder.get("address").get("province").equal((Object)"ONT");
        expression = expression.and(builder.equal((Object)this.emigrant));
        emigrantQuery.setSelectionCriteria(expression);
        emigrantQuery.setShouldRegisterResultsInUnitOfWork(false);
        emigrantQuery.conformResultsInUnitOfWork();
        this.result3 = this.uow.executeQuery((DatabaseQuery)emigrantQuery);
    }

    protected void verify() {
        Employee unregistered;
        if (this.result.contains(this.emigrant)) {
            throw new TestErrorException("An employee no longer in Ontario was returned.");
        }
        if (!this.result.contains(this.immigrant)) {
            throw new TestErrorException("An employee that now lives in Ontario was not returned.");
        }
        if (this.result.size() != this.numberOfOntarioAddresses) {
            throw new TestErrorException("Expecting: " + this.numberOfOntarioAddresses + " retrieved: " + this.result.size());
        }
        Vector registeredAddresses = this.uow.getIdentityMapAccessor().getAllFromIdentityMap(null, Address.class, null, null);
        if (registeredAddresses.size() != 3) {
            throw new TestErrorException("Should be only three addresses registered in UOW cache, not: " + registeredAddresses.size());
        }
        Vector registeredEmployees = this.uow.getIdentityMapAccessor().getAllFromIdentityMap(null, Employee.class, null, null);
        if (registeredEmployees.size() != 2) {
            throw new TestErrorException("Should be only two employees registered in UOW cache, not: " + registeredEmployees.size());
        }
        Enumeration enumtr = this.result.elements();
        while (enumtr.hasMoreElements()) {
            unregistered = (Employee)enumtr.nextElement();
            if (unregistered == this.immigrant || !registeredAddresses.contains(unregistered.getAddress())) continue;
            throw new TestErrorException("An unregistered object references a registered object.");
        }
        if (this.result2 != null) {
            throw new TestErrorException("A no longer conforming object was returned by a read object query: " + this.result2 + ", emigrant: " + this.emigrant2);
        }
        if (this.result3 != null) {
            throw new TestErrorException("A no longer conforming object was returned by a read object query: " + this.result3 + ", emigrant: " + this.emigrant);
        }
        enumtr = this.result.elements();
        while (enumtr.hasMoreElements()) {
            unregistered = (Employee)enumtr.nextElement();
            Employee registeredEmp = (Employee)this.uow.registerExistingObject((Object)unregistered);
            Vector unregisteredAddresses = this.getSession().getIdentityMapAccessor().getAllFromIdentityMap(null, Address.class, null, null);
            if (!unregisteredAddresses.contains(registeredEmp.getAddress()) && (registeredEmp.getAddress().getProvince().equals("ONT") || registeredEmp.getFirstName().equals(this.emigrant2.getFirstName()))) continue;
            throw new TestErrorException("Unregistered objects could not be properly registered later.");
        }
    }
}

