/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.inmemory;

import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.queries.inmemory.QueryAndDescriptorCacheHitTest;

public class QueryCacheHitDisabledAndDescriptorDisabledTest
extends QueryAndDescriptorCacheHitTest {
    public QueryCacheHitDisabledAndDescriptorDisabledTest() {
        this.setDescription("Test when cache hit is disabled in both query and descriptor, cache is not checked");
    }

    @Override
    protected void setup() {
        super.setup();
        this.descriptor.setShouldDisableCacheHits(true);
    }

    @Override
    protected Object readObject(ReadObjectQuery query) {
        query.setCacheUsage(0);
        query.refreshIdentityMapResult();
        return this.getSession().executeQuery((DatabaseQuery)query);
    }

    @Override
    protected void verify() {
        if (((Employee)this.objectRead).getFirstName().equals(this.firstName)) {
            throw new TestErrorException("Object read match but should not.");
        }
        if (this.tempStream.toString().length() == 0) {
            throw new TestErrorException("The read did not go to the database, but should have");
        }
    }
}

