/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.proxyindirection;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.proxyindirection.AddressImpl;
import org.eclipse.persistence.testing.tests.proxyindirection.Employee;

public class ReadWithProxyEqualityExpression
extends AutoVerifyTestCase {
    Employee employee;

    public ReadWithProxyEqualityExpression() {
        this.setDescription("Tests ReadObject using an Expression using Proxy Indirection and equality to a proxy object.");
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        ReadObjectQuery q = new ReadObjectQuery();
        q.setReferenceClass(Employee.class);
        ExpressionBuilder employeeBuilder = new ExpressionBuilder();
        Expression exp = employeeBuilder.get("firstName").equal((Object)"James");
        exp = exp.and(employeeBuilder.get("lastName").equal((Object)"Sutherland"));
        q.setSelectionCriteria(exp);
        this.employee = (Employee)this.getSession().executeQuery((DatabaseQuery)q);
        q = new ReadObjectQuery();
        q.setReferenceClass(Employee.class);
        q.setSelectionCriteria(new ExpressionBuilder().get("address").equal((Object)this.employee.getAddress()));
        this.employee = (Employee)this.getSession().executeQuery((DatabaseQuery)q);
    }

    public void verify() {
        if (this.employee == null) {
            throw new TestErrorException("Employee not returned when searched by address");
        }
        if (((AbstractSession)this.getSession()).getIdentityMapAccessorInstance().getIdentityMap(AddressImpl.class).getSize() == 0) {
            throw new TestErrorException("ProxyIndirection did not work - Address was not read when triggered");
        }
        if (!this.employee.getFirstName().equals("James") || !this.employee.getLastName().equals("Sutherland")) {
            throw new TestErrorException("The incorrect employee was read in a query based on equality to a proxy object.");
        }
    }
}

