/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.descriptors.invalidation.CacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.TimeToLiveCacheInvalidationPolicy;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.CacheExpiryTest;

public class CacheExpiryReadAllQueryTest
extends CacheExpiryTest {
    protected boolean shouldExpire = false;
    protected Vector employeeNames = null;
    protected Vector queriedEmployees = null;

    public CacheExpiryReadAllQueryTest(boolean shouldExpire) {
        this.setDescription("Test Cache Expiry a read Object Query.");
        this.shouldExpire = shouldExpire;
    }

    @Override
    public void setup() {
        super.setup();
        this.getSession().getDescriptor(Employee.class).setCacheInvalidationPolicy((CacheInvalidationPolicy)new TimeToLiveCacheInvalidationPolicy(100000L));
        this.employeeNames = new Vector();
    }

    public void test() {
        Enumeration employees = this.getSession().readAllObjects(Employee.class).elements();
        while (employees.hasMoreElements()) {
            this.employeeNames.addElement(((Employee)employees.nextElement()).getFirstName());
        }
        Enumeration employeeMap = ((AbstractSession)this.getSession()).getIdentityMapAccessorInstance().getIdentityMap(Employee.class).keys();
        while (employeeMap.hasMoreElements()) {
            Employee employee = (Employee)((CacheKey)employeeMap.nextElement()).getObject();
            employee.setFirstName(employee.getFirstName() + "-mutated");
        }
        if (this.shouldExpire) {
            this.getAbstractSession().getIdentityMapAccessor().invalidateClass(Employee.class);
        }
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        this.queriedEmployees = (Vector)this.getSession().executeQuery((DatabaseQuery)query);
    }

    public void verify() {
        Enumeration queriedResults = this.queriedEmployees.elements();
        while (queriedResults.hasMoreElements()) {
            Employee employee = (Employee)queriedResults.nextElement();
            if (this.shouldExpire && !this.employeeNames.contains(employee.getFirstName())) {
                throw new TestErrorException("Expiring Read All Query did not properly cache results.  Please ensure this system is not running with a heavy load prior to filing a bug since the cache expiry tests rely to a certain degree on timing.");
            }
            if (!this.shouldExpire && this.employeeNames.contains(employee.getFirstName())) {
                throw new TestErrorException("Non-Expiring Read All Query did not properly cache results.  Please ensure this system is not running with a heavy load prior to filing a bug since the cache expiry tests rely to a certain degree on timing.");
            }
            this.employeeNames.remove(employee.getFirstName());
        }
    }
}

