/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.identitymaps.HardCacheWeakIdentityMap;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class HardCacheWeakIdentityMapTest
extends TestCase {
    protected Class originalIdentityMapClass = null;
    protected int originalIdentityMapSize = 0;
    protected Employee firstEmployee = null;
    protected Employee secondEmployee = null;
    protected boolean firstEmployeeDropped = false;
    protected boolean referenceCacheSizeMaintained = false;
    public static final int REFERENCE_CACHE_SIZE = 10;

    public void setup() {
        this.originalIdentityMapClass = this.getSession().getDescriptor(Employee.class).getIdentityMapClass();
        this.originalIdentityMapSize = this.getSession().getDescriptor(Employee.class).getIdentityMapSize();
        this.getSession().getDescriptor(Employee.class).setIdentityMapClass(HardCacheWeakIdentityMap.class);
        this.getSession().getDescriptor(Employee.class).setIdentityMapSize(10);
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.beginTransaction();
    }

    public void reset() {
        this.rollbackTransaction();
        this.getSession().getDescriptor(Employee.class).setIdentityMapClass(this.originalIdentityMapClass);
        this.getSession().getDescriptor(Employee.class).setIdentityMapSize(this.originalIdentityMapSize);
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.firstEmployee = new Employee();
        this.firstEmployee.setFirstName("Test0");
        this.firstEmployee.setLastName("Employee");
        uow.registerObject((Object)this.firstEmployee);
        uow.commit();
        uow = this.getSession().acquireUnitOfWork();
        Employee secondEmployee = new Employee();
        secondEmployee.setFirstName("Test1");
        secondEmployee.setLastName("Employee");
        uow.registerObject((Object)secondEmployee);
        uow.commit();
        for (int i = 2; i < 11; ++i) {
            uow = this.getSession().acquireUnitOfWork();
            Employee employee = (Employee)uow.registerObject((Object)new Employee());
            employee.setFirstName("Test" + i);
            employee.setLastName("Employee");
            uow.commit();
        }
        HardCacheWeakIdentityMap map = (HardCacheWeakIdentityMap)this.getAbstractSession().getIdentityMapAccessorInstance().getIdentityMap(Employee.class);
        this.referenceCacheSizeMaintained = map.getReferenceCache().size() == 10;
        this.firstEmployeeDropped = !map.getReferenceCache().contains((Object)this.firstEmployee);
        ReadObjectQuery query = new ReadObjectQuery();
        query.setReferenceClass(Employee.class);
        ExpressionBuilder employee = new ExpressionBuilder();
        Expression exp = employee.get("firstName").equal((Object)"Test0");
        query.setSelectionCriteria(exp);
        Employee queryResult = (Employee)this.getSession().executeQuery((DatabaseQuery)query);
        this.referenceCacheSizeMaintained = this.referenceCacheSizeMaintained && map.getReferenceCache().size() == 10;
    }

    public void verify() {
        HardCacheWeakIdentityMap map = (HardCacheWeakIdentityMap)this.getAbstractSession().getIdentityMapAccessorInstance().getIdentityMap(Employee.class);
        if (!this.referenceCacheSizeMaintained) {
            throw new TestErrorException("The HardCacheWeakIdentityMap sub-cache was not correctly maintained.  The reference cache size was not correctly maintained.");
        }
        if (!this.firstEmployeeDropped) {
            throw new TestErrorException("The HardCacheWeakIdentityMap sub-cache was not correctly maintained.  An object was not correctly dropped when the sub-cache was filled.");
        }
        if (!map.getReferenceCache().contains((Object)this.firstEmployee)) {
            throw new TestErrorException("The HardCacheWeakIdentityMap sub-cache was not correctly maintained.  An object was not correctly replaced when reread after being removed.");
        }
        if (map.getReferenceCache().contains((Object)this.secondEmployee)) {
            throw new TestErrorException("The HardCacheWeakIdentityMap sub-cache was not correctly maintained.  An object was not correctly removed when an object was reread.");
        }
    }
}

