/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.expressions;

import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.ReportQueryResult;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class LiteralExpressionTest
extends TestCase {
    protected EclipseLinkException exception;
    protected Vector<ReportQueryResult> results;

    public LiteralExpressionTest() {
        this.setDescription("Test using a LiteralExpression through ExpressionBuilder.literal()");
    }

    public void test() {
        ClassDescriptor descriptor = this.getSession().getDescriptor(Employee.class);
        DatabaseMapping genderMapping = descriptor.getMappingForAttributeName("gender");
        String genderFieldName = genderMapping.getField().getName();
        ReportQuery query = new ReportQuery(Employee.class, new ExpressionBuilder());
        ExpressionBuilder builder = query.getExpressionBuilder();
        query.addAttribute("id", builder.get("id"));
        query.addAttribute("gender", builder.literal(genderFieldName));
        query.addAttribute("firstName", builder.get("firstName"));
        query.addAttribute("lastName", builder.get("lastName"));
        try {
            this.results = (Vector)this.getSession().executeQuery((DatabaseQuery)query);
        }
        catch (EclipseLinkException ex) {
            this.exception = ex;
        }
    }

    public void verify() {
        if (this.exception != null) {
            throw new TestErrorException("An exception occurred executing a ReportQuery with a literal expression", (Throwable)this.exception);
        }
        if (this.results == null || this.results.isEmpty()) {
            throw new TestErrorException("Unexpected error - no ReportQuery results returned");
        }
        for (int i = 0; i < this.results.size(); ++i) {
            ReportQueryResult rqr = this.results.get(i);
            Object gender = rqr.get("gender");
            if (gender != null) continue;
            throw new TestErrorException("ReportQueryResult does not contain entries for 'gender', literal not added");
        }
    }
}

