/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.directmap;

import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TransactionalTestCase;
import org.eclipse.persistence.testing.models.directmap.DirectMapMappings;

public class MergeChangeSetWithIndirectDirectMapMappingTest
extends TransactionalTestCase {
    boolean m_exceptionCaught;
    DirectMapMappings mapsQueryResult;

    public MergeChangeSetWithIndirectDirectMapMappingTest() {
        this.setDescription("Tests the merge change set over a distributed cache using a indirect direct map mapping");
    }

    public void setup() {
        this.m_exceptionCaught = false;
        super.setup();
    }

    public void test() throws Exception {
        UnitOfWork uow1 = this.getSession().acquireUnitOfWork();
        DirectMapMappings maps = (DirectMapMappings)uow1.registerObject((Object)new DirectMapMappings());
        maps.indirectionDirectMap.put(1, "bogus");
        maps.indirectionDirectMap.put(3, "third");
        uow1.commit();
        UnitOfWork uow2 = this.getSession().acquireUnitOfWork();
        DirectMapMappings mapsClone = (DirectMapMappings)uow2.registerObject((Object)maps);
        mapsClone.indirectionDirectMap.put(2, "axemen");
        mapsClone.indirectionDirectMap.put(1, "guy");
        UnitOfWorkChangeSet changes = (UnitOfWorkChangeSet)uow2.getCurrentChanges();
        this.getSession().refreshObject((Object)mapsClone);
        uow2.commit();
        ReadObjectQuery query = new ReadObjectQuery((Object)mapsClone);
        query.shouldCheckCacheOnly();
        this.mapsQueryResult = (DirectMapMappings)this.getSession().executeQuery((DatabaseQuery)query);
    }

    public void verify() throws Exception {
        if (this.m_exceptionCaught) {
            throw new TestErrorException("Merge change set into distributed cache failed with direct-map mapping");
        }
        if (!this.mapsQueryResult.indirectionDirectMap.containsKey(1)) {
            throw new TestErrorException("Change set did not merge into cache properly");
        }
        if (!this.mapsQueryResult.indirectionDirectMap.get(1).equals("guy")) {
            throw new TestErrorException("Change set did not merge into cache properly");
        }
        if (!this.mapsQueryResult.indirectionDirectMap.containsKey(2)) {
            throw new TestErrorException("Change set did not merge into cache properly");
        }
        if (!this.mapsQueryResult.indirectionDirectMap.get(2).equals("axemen")) {
            throw new TestErrorException("Change set did not merge into cache properly");
        }
        if (!this.mapsQueryResult.indirectionDirectMap.containsKey(3)) {
            throw new TestErrorException("Change set did not merge into cache properly");
        }
    }
}

