/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.customsqlstoredprocedures;

import java.sql.Date;
import java.util.Vector;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.insurance.Address;

public class StoredProcedureObjectRelationalParameters
extends TestCase {
    Object result = null;
    Vector results2;
    Vector results3 = null;
    Address originalAddress;
    Long policyHolderIdToUse = 12345L;
    boolean useCustomSQL;

    public StoredProcedureObjectRelationalParameters() {
        this.useCustomSQL = false;
    }

    public StoredProcedureObjectRelationalParameters(boolean useCustomSQL) {
        this.useCustomSQL = useCustomSQL;
        this.setName(this.getName() + " useCustomSQL = " + useCustomSQL);
    }

    public void setup() {
        if (!this.getSession().getPlatform().isOracle9()) {
            throw new TestWarningException("This test can only be run in Oracle9");
        }
        try {
            this.getSession().executeNonSelectingSQL("Delete from PolicyHolders where (ssn = " + this.policyHolderIdToUse + " )");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.originalAddress = new Address();
        this.originalAddress.setCountry("Canada");
        this.originalAddress.setCity("Ottawa");
        this.originalAddress.setState("On");
        this.originalAddress.setStreet("mystreet");
        this.originalAddress.setZipCode("Zip");
    }

    public void test() {
        Vector<Object> args = new Vector<Object>();
        args.addElement(this.policyHolderIdToUse);
        args.addElement(null);
        args.addElement(Character.valueOf('M'));
        args.addElement("Chris");
        args.addElement(null);
        args.addElement("Random");
        args.addElement(this.originalAddress);
        args.addElement(null);
        args.addElement(null);
        this.result = this.getSession().executeQuery(this.getInsertQuery(), args);
        Vector<Long> args2 = new Vector<Long>();
        args2.addElement(this.policyHolderIdToUse);
        this.results2 = (Vector)this.getSession().executeQuery(this.getReadQuery(), args2);
        this.results3 = (Vector)this.getSession().executeQuery(this.getDeleteQuery(), args);
    }

    public void verify() {
        if (this.results2.size() != 1 && this.results3.size() != 1) {
            throw new TestErrorException("Collections returned did not contain expected number of results");
        }
        Address addressRead = (Address)((DatabaseRecord)this.results2.get(0)).get("address");
        if (!this.originalAddress.getStreet().equals(addressRead.getStreet())) {
            throw new TestErrorException("Address in did not equal the address returned out by SProc_Read_PHolders");
        }
        Address addressRemoved = (Address)((DatabaseRecord)this.results3.get(0)).get("address");
        if (!this.originalAddress.getStreet().equals(addressRemoved.getStreet())) {
            throw new TestErrorException("Address in did not equal the address returned out by SProc_Delete_PHolders");
        }
    }

    public DatabaseCall getInsertCall() {
        SQLCall call = null;
        if (this.useCustomSQL) {
            String sqlString = "BEGIN SProc_Insert_PHolders(#ssn, #occupation, #sex, #firstName, #birthDate, #lastName, #address, #childrenNames, #phones); END;";
            SQLCall sqlcall = new SQLCall(sqlString);
            sqlcall.setCustomSQLArgumentType("ssn", Long.class);
            sqlcall.setCustomSQLArgumentType("occupation", String.class);
            sqlcall.setCustomSQLArgumentType("sex", Character.class);
            sqlcall.setCustomSQLArgumentType("firstName", String.class);
            sqlcall.setCustomSQLArgumentType("birthDate", Date.class);
            sqlcall.setCustomSQLArgumentType("lastName", String.class);
            sqlcall.setCustomSQLArgumentType("address", 2002, "ADDRESS_TYPE");
            sqlcall.setCustomSQLArgumentType("childrenNames", 2003, "NAMELIST_TYPE");
            sqlcall.setCustomSQLArgumentType("phones", 2003, "PHONELIST_TYPE");
            call = sqlcall;
        } else {
            StoredProcedureCall spcall = new StoredProcedureCall();
            spcall.setProcedureName("SProc_Insert_PHolders");
            spcall.addUnamedArgument("ssn", Long.class);
            spcall.addUnamedArgument("occupation", String.class);
            spcall.addUnamedArgument("sex", Character.class);
            spcall.addUnamedArgument("firstName", String.class);
            spcall.addUnamedArgument("birthDate", Date.class);
            spcall.addUnamedArgument("lastName", String.class);
            spcall.addUnamedArgument("address", 2002, "ADDRESS_TYPE");
            spcall.addUnamedArgument("childrenNames", 2003, "NAMELIST_TYPE");
            spcall.addUnamedArgument("phones", 2003, "PHONELIST_TYPE");
            call = spcall;
        }
        return call;
    }

    public DatabaseQuery getInsertQuery() {
        DataModifyQuery query = new DataModifyQuery();
        query.setShouldBindAllParameters(true);
        query.bindAllParameters();
        query.setCall((Call)this.getInsertCall());
        query.addArgument("ssn");
        query.addArgument("occupation");
        query.addArgument("sex");
        query.addArgument("firstName");
        query.addArgument("birthDate");
        query.addArgument("lastName");
        query.addArgument("address");
        query.addArgument("childrenNames");
        query.addArgument("phones");
        return query;
    }

    public DatabaseCall getReadCall() {
        SQLCall call = null;
        if (this.useCustomSQL) {
            String sqlString = "BEGIN SProc_Read_PHolders(####ssn, ###occupation, ###sex, ###firstName, ###birthDate, ###lastName, ###address, ###childrenNames, ###phones); END;";
            SQLCall sqlcall = new SQLCall(sqlString);
            sqlcall.setCustomSQLArgumentType("ssn", Long.class);
            sqlcall.setCustomSQLArgumentType("occupation", String.class);
            sqlcall.setCustomSQLArgumentType("sex", Character.class);
            sqlcall.setCustomSQLArgumentType("firstName", String.class);
            sqlcall.setCustomSQLArgumentType("birthDate", Date.class);
            sqlcall.setCustomSQLArgumentType("lastName", String.class);
            sqlcall.setCustomSQLArgumentType("address", 2002, "ADDRESS_TYPE", Address.class);
            sqlcall.setCustomSQLArgumentType("childrenNames", 2003, "NAMELIST_TYPE");
            sqlcall.setCustomSQLArgumentType("phones", 2003, "PHONELIST_TYPE");
            call = sqlcall;
        } else {
            StoredProcedureCall spcall = new StoredProcedureCall();
            spcall.setProcedureName("SProc_Read_PHolders");
            spcall.addUnamedInOutputArgument("ssn", Long.class);
            spcall.addUnamedOutputArgument("occupation", String.class);
            spcall.addUnamedOutputArgument("sex", Character.class);
            spcall.addUnamedOutputArgument("firstName", String.class);
            spcall.addUnamedOutputArgument("birthDate", Date.class);
            spcall.addUnamedOutputArgument("lastName", String.class);
            spcall.addUnamedOutputArgument("address", 2002, "ADDRESS_TYPE", Address.class);
            spcall.addUnamedOutputArgument("childrenNames", 2003, "NAMELIST_TYPE");
            spcall.addUnamedOutputArgument("phones", 2003, "PHONELIST_TYPE");
            call = spcall;
        }
        return call;
    }

    public DatabaseQuery getReadQuery() {
        DataReadQuery query = new DataReadQuery();
        query.setShouldBindAllParameters(true);
        query.bindAllParameters();
        query.setCall((Call)this.getReadCall());
        query.addArgument("ssn");
        return query;
    }

    public DatabaseCall getDeleteCall() {
        SQLCall call = null;
        if (this.useCustomSQL) {
            String sqlString = "BEGIN SProc_Delete_PHolders(####ssn, ####occupation, ####sex, ####firstName, ####birthDate, ####lastName, ####address, ####childrenNames, ####phones); END;";
            SQLCall sqlcall = new SQLCall(sqlString);
            sqlcall.setCustomSQLArgumentType("ssn", Long.class);
            sqlcall.setCustomSQLArgumentType("occupation", String.class);
            sqlcall.setCustomSQLArgumentType("sex", Character.class);
            sqlcall.setCustomSQLArgumentType("firstName", String.class);
            sqlcall.setCustomSQLArgumentType("birthDate", Date.class);
            sqlcall.setCustomSQLArgumentType("lastName", String.class);
            sqlcall.setCustomSQLArgumentType("address", 2002, "ADDRESS_TYPE", Address.class);
            sqlcall.setCustomSQLArgumentType("childrenNames", 2003, "NAMELIST_TYPE");
            sqlcall.setCustomSQLArgumentType("phones", 2003, "PHONELIST_TYPE");
            call = sqlcall;
        } else {
            StoredProcedureCall sqlcall = new StoredProcedureCall();
            sqlcall.setProcedureName("SProc_Delete_PHolders");
            sqlcall.addUnamedInOutputArgument("ssn", Long.class);
            sqlcall.addUnamedInOutputArgument("occupation", String.class);
            sqlcall.addUnamedInOutputArgument("sex", Character.class);
            sqlcall.addUnamedInOutputArgument("firstName", String.class);
            sqlcall.addUnamedInOutputArgument("birthDate", Date.class);
            sqlcall.addUnamedInOutputArgument("lastName", String.class);
            sqlcall.addUnamedInOutputArgument("address", "address", 2002, "ADDRESS_TYPE", Address.class);
            sqlcall.addUnamedInOutputArgument("childrenNames", "childrenNames", 2003, "NAMELIST_TYPE", Vector.class);
            sqlcall.addUnamedInOutputArgument("phones", "phones", 2003, "PHONELIST_TYPE");
            call = sqlcall;
        }
        return call;
    }

    public DatabaseQuery getDeleteQuery() {
        DataReadQuery query3 = new DataReadQuery();
        query3.setShouldBindAllParameters(true);
        query3.bindAllParameters();
        query3.setCall((Call)this.getDeleteCall());
        query3.addArgument("ssn");
        query3.addArgument("occupation");
        query3.addArgument("sex");
        query3.addArgument("firstName");
        query3.addArgument("birthDate");
        query3.addArgument("lastName");
        query3.addArgument("address");
        query3.addArgument("childrenNames");
        query3.addArgument("phones");
        return query3;
    }
}

