/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.aggregate;

import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.aggregate.House;
import org.eclipse.persistence.testing.models.aggregate.RoomSellingPoint;
import org.eclipse.persistence.testing.models.aggregate.SellingPoint;
import org.eclipse.persistence.testing.tests.aggregate.AgentBuilderHelper;

public class NestedAggregateCollectionTest
extends AutoVerifyTestCase {
    private Class cls;
    private String errorMessage = null;
    private UnitOfWork uow = null;
    private Object object = null;
    private House house = null;

    public NestedAggregateCollectionTest(Class cls) {
        this.cls = cls;
        this.setName(this.getName() + AgentBuilderHelper.getNameInBrackets(cls));
    }

    public void reset() {
        this.rollbackTransaction();
    }

    public void setup() {
        this.beginTransaction();
    }

    public void test() {
        DatabaseSession session = (DatabaseSession)this.getSession();
        SellingPoint sellingPoint = RoomSellingPoint.example3();
        Object databaseSellingPoint = null;
        int index = -1;
        this.readAHouse();
        this.house.getSellingPoints().add(sellingPoint);
        this.uow.commit();
        this.readAHouse();
        index = this.house.getSellingPoints().indexOf(sellingPoint);
        if (index == -1) {
            this.errorMessage = "Selling point was not added to aggregate collection.";
            return;
        }
        sellingPoint = (SellingPoint)this.house.getSellingPoints().elementAt(index);
        sellingPoint.setDescription("Small, dark, and dingy area.");
        this.uow.commit();
        this.readAHouse();
        index = this.house.getSellingPoints().indexOf(sellingPoint);
        if (index == -1) {
            this.errorMessage = "Selling point was not updated in the aggregate collection.";
            return;
        }
        this.house.getSellingPoints().remove(index);
        this.uow.commit();
        this.readAHouse();
        index = this.house.getSellingPoints().indexOf(sellingPoint);
        if (index != -1) {
            this.errorMessage = "Selling point was not deleted from the aggregate collection.";
            return;
        }
    }

    public void verify() {
        if (this.errorMessage != null) {
            throw new TestErrorException(this.errorMessage);
        }
    }

    private void readAHouse() {
        DatabaseSession session = (DatabaseSession)this.getSession();
        session.getIdentityMapAccessor().initializeIdentityMaps();
        this.uow = session.acquireUnitOfWork();
        this.object = this.uow.readObject(this.cls);
        this.house = (House)AgentBuilderHelper.getHouses(this.object).get(0);
    }
}

