/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.xml.merge.inherited;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.xml.merge.inherited.Alpine;
import org.eclipse.persistence.testing.models.jpa.xml.merge.inherited.Beer;
import org.eclipse.persistence.testing.models.jpa.xml.merge.inherited.BeerConsumer;
import org.eclipse.persistence.testing.models.jpa.xml.merge.inherited.BeerListener;
import org.eclipse.persistence.testing.models.jpa.xml.merge.inherited.Canadian;
import org.eclipse.persistence.testing.models.jpa.xml.merge.inherited.Certification;
import org.eclipse.persistence.testing.models.jpa.xml.merge.inherited.EmbeddedSerialNumber;
import org.eclipse.persistence.testing.models.jpa.xml.merge.inherited.TelephoneNumber;

public class EntityMappingsMergeInheritedJUnitTestCase
extends JUnitTestCase {
    private static Integer beerConsumerId;
    private static Integer canadianId;
    private static Integer alpineId;
    private static EmbeddedSerialNumber embeddedSerialNumber;

    public EntityMappingsMergeInheritedJUnitTestCase() {
    }

    public EntityMappingsMergeInheritedJUnitTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Inherited Model");
        suite.addTest((Test)new EntityMappingsMergeInheritedJUnitTestCase("testSetup"));
        suite.addTest((Test)new EntityMappingsMergeInheritedJUnitTestCase("testOneToManyRelationships"));
        suite.addTest((Test)new EntityMappingsMergeInheritedJUnitTestCase("testVerifyOneToManyRelationships"));
        suite.addTest((Test)new EntityMappingsMergeInheritedJUnitTestCase("testCreateBeerConsumer"));
        suite.addTest((Test)new EntityMappingsMergeInheritedJUnitTestCase("testReadBeerConsumer"));
        suite.addTest((Test)new EntityMappingsMergeInheritedJUnitTestCase("testNamedNativeQueryBeerConsumers"));
        suite.addTest((Test)new EntityMappingsMergeInheritedJUnitTestCase("testNamedNativeQueryCertifications"));
        suite.addTest((Test)new EntityMappingsMergeInheritedJUnitTestCase("testMappedSuperclassTransientField"));
        suite.addTest((Test)new EntityMappingsMergeInheritedJUnitTestCase("testTransientField"));
        suite.addTest((Test)new EntityMappingsMergeInheritedJUnitTestCase("testUpdateBeerConsumer"));
        suite.addTest((Test)new EntityMappingsMergeInheritedJUnitTestCase("testDeleteBeerConsumer"));
        suite.addTest((Test)new EntityMappingsMergeInheritedJUnitTestCase("testBeerLifeCycleMethodAnnotationIgnored"));
        suite.addTest((Test)new EntityMappingsMergeInheritedJUnitTestCase("testMappedSuperclassEntityListener"));
        suite.addTest((Test)new EntityMappingsMergeInheritedJUnitTestCase("testMappedSuperclassEmbeddedXMLElement"));
        return suite;
    }

    public void testSetup() {
        ServerSession session = JUnitTestCase.getServerSession();
        EntityMappingsMergeInheritedJUnitTestCase.clearCache((String)"ddlGeneration");
    }

    public void testCreateBeerConsumer() {
        EntityManager em = EntityMappingsMergeInheritedJUnitTestCase.createEntityManager((String)"ddlGeneration");
        try {
            this.beginTransaction(em);
            BeerConsumer consumer = new BeerConsumer();
            consumer.setName("Joe Black");
            em.persist((Object)consumer);
            beerConsumerId = consumer.getId();
            Alpine alpine1 = new Alpine();
            alpine1.setAlcoholContent(5.0);
            alpine1.setBestBeforeDate((Date)new java.sql.Date(System.currentTimeMillis() + 10000000L));
            alpine1.setLocalTransientString("This should never be persisted");
            em.persist((Object)alpine1);
            alpineId = alpine1.getId();
            consumer.addAlpineBeerToConsume(alpine1);
            embeddedSerialNumber = new EmbeddedSerialNumber();
            EntityMappingsMergeInheritedJUnitTestCase.embeddedSerialNumber.number = 123456;
            embeddedSerialNumber.setBreweryCode("MOLSON");
            Canadian canadian1 = new Canadian();
            canadian1.setAlcoholContent(5.5);
            canadian1.setBeerConsumer(consumer);
            canadian1.setBornOnDate((Date)new java.sql.Date(System.currentTimeMillis() - 30000000L));
            canadian1.setTransientString("This should never be persisted");
            canadian1.setEmbeddedSerialNumber(embeddedSerialNumber);
            em.persist((Object)canadian1);
            canadianId = canadian1.getId();
            consumer.getCanadianBeersToConsume().put(canadian1.getId(), canadian1);
            Canadian canadian2 = new Canadian();
            canadian2.setAlcoholContent(5.0);
            canadian2.setBeerConsumer(consumer);
            canadian2.setBornOnDate((Date)new java.sql.Date(System.currentTimeMillis() - 23000000L));
            em.persist((Object)canadian2);
            consumer.getCanadianBeersToConsume().put(canadian2.getId(), canadian2);
            Certification cert1 = new Certification();
            cert1.setDescription("Value brand beer consumption certified");
            cert1.setBeerConsumer(consumer);
            em.persist((Object)cert1);
            consumer.getCertifications().put(cert1.getId(), cert1);
            Certification cert2 = new Certification();
            cert2.setDescription("Premium brand beer consumption certified");
            cert2.setBeerConsumer(consumer);
            em.persist((Object)cert2);
            consumer.getCertifications().put(cert2.getId(), cert2);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
    }

    public void testNamedNativeQueryBeerConsumers() {
        List consumers = EntityMappingsMergeInheritedJUnitTestCase.createEntityManager((String)"ddlGeneration").createNamedQuery("findAnyMergeSQLBeerConsumer").getResultList();
        EntityMappingsMergeInheritedJUnitTestCase.assertTrue((String)"Error executing native query 'findAnyMergeSQLBeerConsumer'", (consumers != null ? 1 : 0) != 0);
    }

    public void testNamedNativeQueryCertifications() {
        List certifications = EntityMappingsMergeInheritedJUnitTestCase.createEntityManager((String)"ddlGeneration").createNamedQuery("findAllMergeSQLCertifications").getResultList();
        EntityMappingsMergeInheritedJUnitTestCase.assertTrue((String)"Error executing native query 'findAllMergeSQLCertifications'", (certifications != null ? 1 : 0) != 0);
    }

    public void testDeleteBeerConsumer() {
        EntityManager em = EntityMappingsMergeInheritedJUnitTestCase.createEntityManager((String)"ddlGeneration");
        this.beginTransaction(em);
        try {
            em.remove(em.find(BeerConsumer.class, (Object)beerConsumerId));
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        EntityMappingsMergeInheritedJUnitTestCase.assertTrue((String)"Error deleting BeerConsumer", (em.find(BeerConsumer.class, (Object)beerConsumerId) == null ? 1 : 0) != 0);
    }

    public void testReadBeerConsumer() {
        BeerConsumer consumer = (BeerConsumer)EntityMappingsMergeInheritedJUnitTestCase.createEntityManager((String)"ddlGeneration").find(BeerConsumer.class, (Object)beerConsumerId);
        EntityMappingsMergeInheritedJUnitTestCase.assertTrue((String)"Error reading BeerConsumer", (consumer.getId() == beerConsumerId ? 1 : 0) != 0);
    }

    public void testUpdateBeerConsumer() {
        EntityManager em = EntityMappingsMergeInheritedJUnitTestCase.createEntityManager((String)"ddlGeneration");
        this.beginTransaction(em);
        try {
            BeerConsumer beerConsumer = (BeerConsumer)em.find(BeerConsumer.class, (Object)beerConsumerId);
            beerConsumer.setName("Joe White");
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        EntityMappingsMergeInheritedJUnitTestCase.clearCache((String)"ddlGeneration");
        BeerConsumer newBeerConsumer = (BeerConsumer)em.find(BeerConsumer.class, (Object)beerConsumerId);
        this.closeEntityManager(em);
        EntityMappingsMergeInheritedJUnitTestCase.assertTrue((String)"Error updating BeerConsumer name", (boolean)newBeerConsumer.getName().equals("Joe White"));
    }

    public void testOneToManyRelationships() {
        EntityManager em = EntityMappingsMergeInheritedJUnitTestCase.createEntityManager((String)"ddlGeneration");
        try {
            this.beginTransaction(em);
            BeerConsumer consumer = new BeerConsumer();
            consumer.setName("Joe Black");
            TelephoneNumber homeNumber = new TelephoneNumber();
            homeNumber.setAreaCode("555");
            homeNumber.setType("Home");
            homeNumber.setNumber("123-1234");
            TelephoneNumber workNumber = new TelephoneNumber();
            workNumber.setAreaCode("555");
            workNumber.setType("Work");
            workNumber.setNumber("987-9876");
            consumer.addTelephoneNumber(homeNumber);
            consumer.addTelephoneNumber(workNumber);
            em.persist((Object)consumer);
            beerConsumerId = consumer.getId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
    }

    public void testVerifyOneToManyRelationships() {
        EntityManager em = EntityMappingsMergeInheritedJUnitTestCase.createEntityManager((String)"ddlGeneration");
        try {
            this.beginTransaction(em);
            BeerConsumer cm = (BeerConsumer)em.find(BeerConsumer.class, (Object)beerConsumerId);
            Collection phones = cm.getTelephoneNumbers().values();
            EntityMappingsMergeInheritedJUnitTestCase.assertTrue((String)"Wrong phonenumbers associated with BeerConsumer", (phones.size() == 2 ? 1 : 0) != 0);
            for (TelephoneNumber phone : phones) {
                EntityMappingsMergeInheritedJUnitTestCase.assertTrue((String)"Wrong owner of the telephone", (phone.getBeerConsumer().getId() == beerConsumerId ? 1 : 0) != 0);
            }
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
    }

    public void testMappedSuperclassTransientField() {
        EntityMappingsMergeInheritedJUnitTestCase.clearCache((String)"ddlGeneration");
        Canadian canadianBeer = (Canadian)EntityMappingsMergeInheritedJUnitTestCase.createEntityManager((String)"ddlGeneration").find(Canadian.class, (Object)canadianId);
        EntityMappingsMergeInheritedJUnitTestCase.assertTrue((String)"Error reading Canadian", (boolean)canadianBeer.getId().equals(canadianId));
        EntityMappingsMergeInheritedJUnitTestCase.assertTrue((String)"Mapped superclass transientString was persisted to the database", (canadianBeer.getTransientString() == null ? 1 : 0) != 0);
    }

    public void testTransientField() {
        EntityMappingsMergeInheritedJUnitTestCase.clearCache((String)"ddlGeneration");
        Alpine alpineBeer = (Alpine)EntityMappingsMergeInheritedJUnitTestCase.createEntityManager((String)"ddlGeneration").find(Alpine.class, (Object)alpineId);
        EntityMappingsMergeInheritedJUnitTestCase.assertTrue((String)"Error reading Alpine", (boolean)alpineBeer.getId().equals(alpineId));
        EntityMappingsMergeInheritedJUnitTestCase.assertTrue((String)"localTransientString was persisted to the database", (alpineBeer.getLocalTransientString() == null ? 1 : 0) != 0);
    }

    public void testBeerLifeCycleMethodAnnotationIgnored() {
        int beerPrePersistCount = Beer.BEER_PRE_PERSIST_COUNT;
        EntityManager em = EntityMappingsMergeInheritedJUnitTestCase.createEntityManager((String)"ddlGeneration");
        BeerConsumer consumer = (BeerConsumer)EntityMappingsMergeInheritedJUnitTestCase.createEntityManager((String)"ddlGeneration").find(BeerConsumer.class, (Object)beerConsumerId);
        try {
            this.beginTransaction(em);
            Canadian canadian1 = new Canadian();
            canadian1.setAlcoholContent(5.5);
            canadian1.setBeerConsumer(consumer);
            canadian1.setBornOnDate((Date)new java.sql.Date(System.currentTimeMillis() - 30000000L));
            em.persist((Object)canadian1);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        EntityMappingsMergeInheritedJUnitTestCase.assertTrue((String)"The callback method [PrePersist] was called.", (beerPrePersistCount == Beer.BEER_PRE_PERSIST_COUNT ? 1 : 0) != 0);
    }

    public void testMappedSuperclassEntityListener() {
        int listenerPostPersistCount = BeerListener.POST_PERSIST_COUNT;
        EntityManager em = EntityMappingsMergeInheritedJUnitTestCase.createEntityManager((String)"ddlGeneration");
        BeerConsumer consumer = (BeerConsumer)EntityMappingsMergeInheritedJUnitTestCase.createEntityManager((String)"ddlGeneration").find(BeerConsumer.class, (Object)beerConsumerId);
        try {
            this.beginTransaction(em);
            Canadian canadian1 = new Canadian();
            canadian1.setAlcoholContent(5.5);
            canadian1.setBeerConsumer(consumer);
            canadian1.setBornOnDate((Date)new java.sql.Date(System.currentTimeMillis() - 30000000L));
            em.persist((Object)canadian1);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        EntityMappingsMergeInheritedJUnitTestCase.assertFalse((String)"The listener callback method [PostPersist] was not called.", (listenerPostPersistCount == BeerListener.POST_PERSIST_COUNT ? 1 : 0) != 0);
    }

    public void testMappedSuperclassEmbeddedXMLElement() {
    }
}

