/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.partitioned;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.descriptors.partitioning.CustomPartitioningPolicy;
import org.eclipse.persistence.descriptors.partitioning.PartitioningPolicy;
import org.eclipse.persistence.descriptors.partitioning.RangePartitioningPolicy;
import org.eclipse.persistence.descriptors.partitioning.RoundRobinPartitioningPolicy;
import org.eclipse.persistence.descriptors.partitioning.UnionPartitioningPolicy;
import org.eclipse.persistence.descriptors.partitioning.ValuePartitioningPolicy;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCaseHelper;
import org.eclipse.persistence.testing.models.jpa.partitioned.Employee;
import org.eclipse.persistence.testing.models.jpa.partitioned.EmployeePK;
import org.eclipse.persistence.testing.models.jpa.partitioned.EmployeePartitioningPolicy;
import org.eclipse.persistence.testing.models.jpa.partitioned.EmployeePopulator;
import org.eclipse.persistence.testing.models.jpa.partitioned.Office;
import org.eclipse.persistence.testing.models.jpa.partitioned.PartitionedTableCreator;
import org.eclipse.persistence.testing.models.jpa.partitioned.Project;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class PartitionedTestSuite
extends JUnitTestCase {
    public static boolean validDatabase = true;
    public static boolean isRAC = false;

    public static Test suite() {
        TestSuite suite = new TestSuite("PartitioningTests");
        suite.addTest((Test)new PartitionedTestSuite("testSetup"));
        suite.addTest((Test)new PartitionedTestSuite("testReadEmployee"));
        suite.addTest((Test)new PartitionedTestSuite("testReadAllEmployee"));
        suite.addTest((Test)new PartitionedTestSuite("testPersistEmployee"));
        suite.addTest((Test)new PartitionedTestSuite("testRemoveEmployee"));
        suite.addTest((Test)new PartitionedTestSuite("testUpdateEmployee"));
        suite.addTest((Test)new PartitionedTestSuite("testReadProject"));
        suite.addTest((Test)new PartitionedTestSuite("testReadAllProject"));
        suite.addTest((Test)new PartitionedTestSuite("testPersistProject"));
        suite.addTest((Test)new PartitionedTestSuite("testRemoveProject"));
        suite.addTest((Test)new PartitionedTestSuite("testUpdateProject"));
        suite.addTest((Test)new PartitionedTestSuite("testPartitioning"));
        suite.addTest((Test)new PartitionedTestSuite("testPersistPartitioning"));
        suite.addTest((Test)new PartitionedTestSuite("testPersistOfficeWithLongName"));
        return suite;
    }

    public PartitionedTestSuite(String name) {
        super(name);
    }

    public String getPersistenceUnitName() {
        return "partitioned";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetup() {
        HashMap<String, String> properties = new HashMap<String, String>(JUnitTestCaseHelper.getDatabaseProperties());
        if (PartitionedTestSuite.getServerSession().getPlatform().isDerby()) {
            properties.put("eclipselink.connection-pool.node2.min", "2");
            properties.put("eclipselink.connection-pool.node2.url", "jdbc:derby:node2;create=true");
            properties.put("eclipselink.connection-pool.node3.url", "jdbc:derby:node3;create=true");
            properties.put("eclipselink.connection-pool.node3.max", "8");
            properties.put("eclipselink.connection-pool.node3.failover", "node2, node1");
        } else if (PartitionedTestSuite.getServerSession().getPlatform().isH2()) {
            properties.put("eclipselink.connection-pool.node2.min", "2");
            properties.put("eclipselink.connection-pool.node2.url", "jdbc:h2:test2");
            properties.put("eclipselink.connection-pool.node3.url", "jdbc:h2:test3");
            properties.put("eclipselink.connection-pool.node3.max", "8");
        } else if (PartitionedTestSuite.getServerSession().getPlatform().isHSQL()) {
            properties.put("eclipselink.connection-pool.node2.min", "2");
            properties.put("eclipselink.connection-pool.node2.url", "jdbc:hsqldb:file:test2");
            properties.put("eclipselink.connection-pool.node3.url", "jdbc:hsqldb:file:test3");
            properties.put("eclipselink.connection-pool.node3.max", "8");
        } else if (!PartitionedTestSuite.isOnServer() && PartitionedTestSuite.getServerSession().getPlatform().isOracle() && PartitionedTestSuite.getServerSession().getLogin().getURL().indexOf("ems56442") != -1) {
            isRAC = true;
            String url = PartitionedTestSuite.getServerSession().getLogin().getURL();
            properties.put("eclipselink.connection-pool.node2.min", "2");
            properties.put("eclipselink.connection-pool.node2.url", url.substring(0, url.length() - 1) + "3");
            properties.put("eclipselink.connection-pool.node3.url", url);
            properties.put("eclipselink.connection-pool.node3.max", "8");
        } else if (!PartitionedTestSuite.isOnServer() && PartitionedTestSuite.getServerSession().getPlatform().isOracle() && PartitionedTestSuite.getServerSession().getLogin().getURL().indexOf("@(DESCRIPTION") != -1) {
            isRAC = true;
            properties.put("eclipselink.partitioning.callback", "org.eclipse.persistence.platform.database.oracle.ucp.UCPDataPartitioningCallback");
        } else if (PartitionedTestSuite.isOnServer()) {
            isRAC = true;
            try {
                Class.forName("weblogic.jdbc.common.internal.DataSourceManager");
            }
            catch (Exception notWebLogic) {
                PartitionedTestSuite.warning((String)"Partitioning tests only run on WebLogic with GridLink.");
                return;
            }
        } else {
            if (PartitionedTestSuite.getServerSession().getPlatform().isSybase()) {
                validDatabase = false;
                return;
            }
            isRAC = true;
            properties.put("eclipselink.connection-pool.node2.min", "2");
            properties.put("eclipselink.connection-pool.node2.url", PartitionedTestSuite.getServerSession().getLogin().getURL());
            properties.put("eclipselink.connection-pool.node3.url", PartitionedTestSuite.getServerSession().getLogin().getURL());
            properties.put("eclipselink.connection-pool.node3.max", "8");
        }
        PartitionedTestSuite.getEntityManagerFactory((String)this.getPersistenceUnitName(), properties);
        if (isRAC) {
            PartitioningPolicy policy2;
            for (PartitioningPolicy policy2 : this.getDatabaseSession().getProject().getPartitioningPolicies().values()) {
                if (policy2 instanceof RoundRobinPartitioningPolicy) {
                    ((RoundRobinPartitioningPolicy)policy2).setReplicateWrites(false);
                    continue;
                }
                if (policy2 instanceof UnionPartitioningPolicy) {
                    ((UnionPartitioningPolicy)policy2).setReplicateWrites(false);
                    continue;
                }
                if (policy2 instanceof CustomPartitioningPolicy) {
                    ((EmployeePartitioningPolicy)((CustomPartitioningPolicy)policy2).getPolicy()).setReplicate(false);
                    continue;
                }
                if (policy2 instanceof RangePartitioningPolicy) {
                    ((RangePartitioningPolicy)policy2).setUnionUnpartitionableQueries(false);
                    continue;
                }
                if (!(policy2 instanceof ValuePartitioningPolicy)) continue;
                ((ValuePartitioningPolicy)policy2).setUnionUnpartitionableQueries(false);
            }
            CollectionMapping mapping = (CollectionMapping)this.getDatabaseSession().getDescriptor(Employee.class).getMappingForAttributeName("projects");
            policy2 = this.getDatabaseSession().getProject().getPartitioningPolicy("defaut");
            mapping.setPartitioningPolicy(policy2);
            mapping.getSelectionQuery().setPartitioningPolicy(policy2);
            mapping = (CollectionMapping)this.getDatabaseSession().getDescriptor(Employee.class).getMappingForAttributeName("managedEmployees");
            mapping.setPartitioningPolicy(policy2);
            mapping.getSelectionQuery().setPartitioningPolicy(policy2);
        }
        new PartitionedTableCreator().replaceTables((DatabaseSession)this.getDatabaseSession());
        EntityManager em = this.createEntityManager();
        try {
            PopulationManager.resetDefaultManager();
            this.beginTransaction(em);
            new EmployeePopulator().persistExample(em);
            this.commitTransaction(em);
        }
        finally {
            this.closeEntityManagerAndTransaction(em);
        }
        this.clearCache();
    }

    public void testReadEmployee() {
        if (!validDatabase) {
            return;
        }
        EntityManager em = this.createEntityManager();
        try {
            int index;
            this.beginTransaction(em);
            Query query = em.createQuery("Select e from Employee e where e.firstName = :name");
            query.setParameter("name", (Object)"Bob");
            Employee employee = (Employee)query.getSingleResult();
            for (index = 0; index < 3; ++index) {
                if (((Employee)query.getSingleResult()).getFirstName().equals("Bob")) continue;
                PartitionedTestSuite.fail((String)"Employee not correct.");
            }
            this.commitTransaction(em);
            this.closeEntityManager(em);
            for (index = 0; index < 3; ++index) {
                this.clearCache();
                em = this.createEntityManager();
                if (!((Employee)em.find(Employee.class, (Object)employee.pk())).getFirstName().equals("Bob")) {
                    PartitionedTestSuite.fail((String)"Employee not correct.");
                }
                this.closeEntityManager(em);
            }
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.verifyObject(new EmployeePopulator().employeeExample1());
        this.verifyObject(new EmployeePopulator().employeeExample2());
        this.verifyObject(new EmployeePopulator().employeeExample3());
    }

    public void testReadProject() {
        if (!validDatabase) {
            return;
        }
        EntityManager em = this.createEntityManager();
        try {
            int index;
            this.beginTransaction(em);
            Query query = em.createQuery("Select p from Project p where p.name = :name");
            query.setParameter("name", (Object)"Sales Reporting");
            Project project = (Project)query.getSingleResult();
            for (index = 0; index < 3; ++index) {
                if (((Project)query.getSingleResult()).getName().equals("Sales Reporting")) continue;
                PartitionedTestSuite.fail((String)"Project not correct.");
            }
            this.commitTransaction(em);
            this.closeEntityManager(em);
            for (index = 0; index < 3; ++index) {
                this.clearCache();
                em = this.createEntityManager();
                if (!((Project)em.find(Project.class, (Object)project.getId())).getName().equals("Sales Reporting")) {
                    PartitionedTestSuite.fail((String)"Project not correct.");
                }
                this.closeEntityManager(em);
            }
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.verifyObject(new EmployeePopulator().largeProjectExample1());
        this.verifyObject(new EmployeePopulator().largeProjectExample2());
        this.verifyObject(new EmployeePopulator().smallProjectExample1());
    }

    public void testReadAllEmployee() {
        if (!validDatabase) {
            return;
        }
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            int size = em.createQuery("Select e from Employee e").getResultList().size();
            for (int index = 0; index < 3; ++index) {
                if (size == em.createQuery("Select e from Employee e").getResultList().size()) continue;
                PartitionedTestSuite.fail((String)"Query result size does not match.");
            }
            this.commitTransaction(em);
            this.closeEntityManager(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testReadAllProject() {
        if (!validDatabase) {
            return;
        }
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            int size = em.createQuery("Select p from Project p").getResultList().size();
            for (int index = 0; index < 3; ++index) {
                if (size == em.createQuery("Select p from Project p").getResultList().size()) continue;
                PartitionedTestSuite.fail((String)"Query result size does not match.");
            }
            this.commitTransaction(em);
            this.closeEntityManager(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testRemoveEmployee() {
        if (!validDatabase) {
            return;
        }
        for (int index = 0; index < 3; ++index) {
            this.verifyPersistAndRemove(new EmployeePopulator().basicEmployeeExample1());
        }
    }

    public void testRemoveProject() {
        if (!validDatabase) {
            return;
        }
        for (int index = 0; index < 3; ++index) {
            this.verifyPersistAndRemove(new EmployeePopulator().basicLargeProjectExample2());
        }
    }

    public void testPersistEmployee() {
        if (!validDatabase) {
            return;
        }
        for (int index = 0; index < 3; ++index) {
            this.verifyPersist(new EmployeePopulator().basicEmployeeExample2());
        }
    }

    public void testPersistOfficeWithLongName() {
        if (!validDatabase) {
            return;
        }
        for (int index = 0; index < 25; ++index) {
            String longName = "Office with a very, very, very long name indeed";
            longName = longName + String.valueOf(UUID.randomUUID());
            this.verifyPersist(new Office(longName, index + 1));
        }
    }

    public void testPersistProject() {
        if (!validDatabase) {
            return;
        }
        for (int index = 0; index < 3; ++index) {
            this.verifyPersist(new EmployeePopulator().basicLargeProjectExample1());
            this.verifyPersist(new EmployeePopulator().basicSmallProjectExample3());
        }
    }

    public void testUpdateEmployee() {
        if (!validDatabase) {
            return;
        }
        for (int index = 0; index < 3; ++index) {
            EntityManager em = this.createEntityManager();
            try {
                this.beginTransaction(em);
                List employees = em.createQuery("Select e from Employee e").getResultList();
                for (Employee employee : employees) {
                    employee.setLastName(employee.getLastName() + "2");
                    employee.addResponsibility("new" + index);
                    employee.getAddress().setStreet(employee.getAddress().getStreet() + "2");
                }
                this.commitTransaction(em);
                for (Employee employee : employees) {
                    this.verifyObject(employee);
                    this.verifyObject(employee.getAddress());
                }
                this.clearCache();
                for (Employee employee : employees) {
                    this.verifyObject(employee);
                    this.verifyObject(employee.getAddress());
                }
                this.closeEntityManager(em);
                continue;
            }
            catch (RuntimeException e) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
                throw e;
            }
        }
    }

    public void testUpdateProject() {
        if (!validDatabase) {
            return;
        }
        for (int index = 0; index < 3; ++index) {
            EntityManager em = this.createEntityManager();
            try {
                this.beginTransaction(em);
                List projects = em.createQuery("Select p from Project p").getResultList();
                for (Project project : projects) {
                    project.setDescription(project.getDescription() + "2");
                }
                this.commitTransaction(em);
                for (Project project : projects) {
                    this.verifyObject(project);
                }
                this.clearCache();
                for (Project project : projects) {
                    this.verifyObject(project);
                }
                this.closeEntityManager(em);
                continue;
            }
            catch (RuntimeException e) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
                throw e;
            }
        }
    }

    public void testPartitioning() throws Exception {
        if (!validDatabase) {
            return;
        }
        boolean found = false;
        EntityManager em = this.createEntityManager();
        try {
            Project project = (Project)em.createQuery("Select p from Project p").getResultList().get(0);
            for (int index = 0; index < 3; ++index) {
                this.beginTransaction(em);
                Query query = em.createNativeQuery("Select * from PART_PROJECT where PROJ_ID = ?");
                query.setParameter(1, (Object)project.getId());
                List results = query.getResultList();
                if (!results.isEmpty()) {
                    if (found && !isRAC) {
                        PartitionedTestSuite.fail((String)"Data found in more than one partition.");
                    }
                    found = true;
                } else if (isRAC) {
                    PartitionedTestSuite.fail((String)"Data not found in all partitions.");
                }
                this.commitTransaction(em);
            }
            if (!found) {
                PartitionedTestSuite.fail((String)"Data not found in any partition.");
            }
        }
        catch (Exception e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPersistPartitioning() throws Exception {
        if (!validDatabase) {
            return;
        }
        if (PartitionedTestSuite.isOnServer()) {
            return;
        }
        for (int count = 0; count < 2; ++count) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("eclipselink.jdbc.exclusive-connection.mode", "Always");
            EntityManager em = this.createEntityManager(properties);
            try {
                this.beginTransaction(em);
                Employee employee1 = new Employee();
                employee1.setLocation("Ottawa");
                em.persist((Object)employee1);
                this.commitTransaction(em);
                this.closeEntityManager(em);
                this.clearCache();
                em = this.createEntityManager(properties);
                this.beginTransaction(em);
                Employee employee2 = new Employee();
                employee2.setLocation("Ottawa");
                em.persist((Object)employee2);
                Employee result = (Employee)em.find(Employee.class, (Object)new EmployeePK(employee1.getId().intValue(), "Toronto"));
                if (result != null) {
                    PartitionedTestSuite.fail((String)"Employee should not exist.");
                }
                result = (Employee)em.find(Employee.class, (Object)new EmployeePK(employee1.getId().intValue(), "Ottawa"));
                this.rollbackTransaction(em);
                if (result == null) {
                    if (count == 1) {
                        PartitionedTestSuite.fail((String)"Employee not found, wrong partition used.");
                    }
                    continue;
                }
                return;
            }
            finally {
                this.closeEntityManagerAndTransaction(em);
            }
        }
    }
}

