/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.fieldaccess.advanced;

import java.util.HashMap;
import java.util.Vector;
import javax.persistence.EntityManager;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionMath;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.queries.UpdateAllQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.UpdateAllQueryTestHelper;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Department;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.EmployeePopulator;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Project;

public class UpdateAllQueryAdvancedJunitTest
extends JUnitTestCase {
    protected static Class[] classes = new Class[]{Employee.class, Address.class, PhoneNumber.class, Project.class};
    protected static Vector[] objectVectors = new Vector[]{null, null, null, null};
    protected static EmployeePopulator populator = new EmployeePopulator();

    public UpdateAllQueryAdvancedJunitTest() {
    }

    public UpdateAllQueryAdvancedJunitTest(String name) {
        super(name);
    }

    public void setUp() {
        if (UpdateAllQueryAdvancedJunitTest.getServerSession((String)"fieldaccess").getPlatform().isSymfoware()) {
            UpdateAllQueryAdvancedJunitTest.warning((String)"UpdateAllQueryAdvancedJunitTest skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        UpdateAllQueryAdvancedJunitTest.clearCache((String)"fieldaccess");
        super.setUp();
        if (!UpdateAllQueryAdvancedJunitTest.compare()) {
            UpdateAllQueryAdvancedJunitTest.clear();
            UpdateAllQueryAdvancedJunitTest.populate();
        }
    }

    protected static DatabaseSession getDbSession() {
        return UpdateAllQueryAdvancedJunitTest.getServerSession((String)"fieldaccess");
    }

    protected static UnitOfWork acquireUnitOfWork() {
        return UpdateAllQueryAdvancedJunitTest.getDbSession().acquireUnitOfWork();
    }

    protected static void clear() {
        UnitOfWork uow = UpdateAllQueryAdvancedJunitTest.acquireUnitOfWork();
        UpdateAllQuery updateEmployees = new UpdateAllQuery(Employee.class);
        updateEmployees.addUpdate("manager", null);
        updateEmployees.addUpdate("address", null);
        uow.executeQuery((DatabaseQuery)updateEmployees);
        UpdateAllQuery updateProjects = new UpdateAllQuery(Project.class);
        updateProjects.addUpdate("teamLeader", null);
        uow.executeQuery((DatabaseQuery)updateProjects);
        UpdateAllQuery updateDepartment = new UpdateAllQuery(Employee.class);
        updateDepartment.addUpdate("department", null);
        uow.executeQuery((DatabaseQuery)updateDepartment);
        uow.executeQuery((DatabaseQuery)new DeleteAllQuery(PhoneNumber.class));
        uow.executeQuery((DatabaseQuery)new DeleteAllQuery(Address.class));
        uow.executeQuery((DatabaseQuery)new DeleteAllQuery(Department.class));
        uow.executeQuery((DatabaseQuery)new DeleteAllQuery(Employee.class));
        uow.executeQuery((DatabaseQuery)new DeleteAllQuery(Project.class));
        uow.commit();
        UpdateAllQueryAdvancedJunitTest.clearCache((String)"fieldaccess");
    }

    protected static void populate() {
        populator.buildExamples();
        populator.persistExample((Session)UpdateAllQueryAdvancedJunitTest.getDbSession());
        UpdateAllQueryAdvancedJunitTest.clearCache((String)"fieldaccess");
        for (int i = 0; i < classes.length; ++i) {
            UpdateAllQueryAdvancedJunitTest.objectVectors[i] = UpdateAllQueryAdvancedJunitTest.getDbSession().readAllObjects(classes[i]);
        }
        UpdateAllQueryAdvancedJunitTest.clearCache((String)"fieldaccess");
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("UpdateAllQueryAdvancedJunitTest (fieldaccess)");
        suite.addTest((Test)new UpdateAllQueryAdvancedJunitTest("testSetup"));
        suite.addTest((Test)new UpdateAllQueryAdvancedJunitTest("testFirstNamePrefixBLAForAll"));
        suite.addTest((Test)new UpdateAllQueryAdvancedJunitTest("testFirstNamePrefixBLAForSalary"));
        suite.addTest((Test)new UpdateAllQueryAdvancedJunitTest("testDoubleSalaryForAll"));
        suite.addTest((Test)new UpdateAllQueryAdvancedJunitTest("testDoubleSalaryForSalary"));
        suite.addTest((Test)new UpdateAllQueryAdvancedJunitTest("testFirstNamePrefixBLADoubleSalaryForAll"));
        suite.addTest((Test)new UpdateAllQueryAdvancedJunitTest("testFirstNamePrefixBLADoubleSalaryForSalary"));
        suite.addTest((Test)new UpdateAllQueryAdvancedJunitTest("testFirstNamePrefixBLADoubleSalaryForSalaryForFirstName"));
        suite.addTest((Test)new UpdateAllQueryAdvancedJunitTest("testAssignManagerName"));
        suite.addTest((Test)new UpdateAllQueryAdvancedJunitTest("testAssignNullToAddress"));
        suite.addTest((Test)new UpdateAllQueryAdvancedJunitTest("testAssignObjectToAddress"));
        suite.addTest((Test)new UpdateAllQueryAdvancedJunitTest("testAssignExpressionToAddress"));
        suite.addTest((Test)new UpdateAllQueryAdvancedJunitTest("testAggregate"));
        return suite;
    }

    public void testSetup() {
        if (UpdateAllQueryAdvancedJunitTest.getServerSession((String)"fieldaccess").getPlatform().isSymfoware()) {
            UpdateAllQueryAdvancedJunitTest.warning((String)"UpdateAllQueryAdvancedJunitTest skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        new AdvancedTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession((String)"fieldaccess"));
        UpdateAllQueryAdvancedJunitTest.clearCache((String)"fieldaccess");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFirstNamePrefixBLAForAll() {
        if (UpdateAllQueryAdvancedJunitTest.getServerSession((String)"fieldaccess").getPlatform().isSymfoware()) {
            UpdateAllQueryAdvancedJunitTest.warning((String)"UpdateAllQueryAdvancedJunitTest skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        EntityManager em = UpdateAllQueryAdvancedJunitTest.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            ExpressionBuilder builder = new ExpressionBuilder();
            UpdateAllQuery updateQuery = new UpdateAllQuery(Employee.class);
            updateQuery.addUpdate("firstName", Expression.fromLiteral((String)"'BLA'", null).concat((Object)builder.get("firstName")));
            UpdateAllQueryAdvancedJunitTest.updateAllQueryInternal(updateQuery);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFirstNamePrefixBLAForSalary() {
        if (UpdateAllQueryAdvancedJunitTest.getServerSession((String)"fieldaccess").getPlatform().isSymfoware()) {
            UpdateAllQueryAdvancedJunitTest.warning((String)"UpdateAllQueryAdvancedJunitTest skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        EntityManager em = UpdateAllQueryAdvancedJunitTest.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression selectionExpression = builder.get("salary").lessThan(20000);
            UpdateAllQuery updateQuery = new UpdateAllQuery(Employee.class, selectionExpression);
            updateQuery.addUpdate("firstName", Expression.fromLiteral((String)"'BLA'", null).concat((Object)builder.get("firstName")));
            UpdateAllQueryAdvancedJunitTest.updateAllQueryInternal(updateQuery);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDoubleSalaryForAll() {
        if (UpdateAllQueryAdvancedJunitTest.getServerSession((String)"fieldaccess").getPlatform().isSymfoware()) {
            UpdateAllQueryAdvancedJunitTest.warning((String)"UpdateAllQueryAdvancedJunitTest skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        EntityManager em = UpdateAllQueryAdvancedJunitTest.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            ExpressionBuilder builder = new ExpressionBuilder();
            UpdateAllQuery updateQuery = new UpdateAllQuery(Employee.class);
            updateQuery.addUpdate("salary", ExpressionMath.multiply((Expression)builder.get("salary"), (Object)2));
            UpdateAllQueryAdvancedJunitTest.updateAllQueryInternal(updateQuery);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDoubleSalaryForSalary() {
        if (UpdateAllQueryAdvancedJunitTest.getServerSession((String)"fieldaccess").getPlatform().isSymfoware()) {
            UpdateAllQueryAdvancedJunitTest.warning((String)"UpdateAllQueryAdvancedJunitTest skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        EntityManager em = UpdateAllQueryAdvancedJunitTest.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression selectionExpression = builder.get("salary").lessThan(20000);
            UpdateAllQuery updateQuery = new UpdateAllQuery(Employee.class, selectionExpression);
            updateQuery.addUpdate("salary", ExpressionMath.multiply((Expression)builder.get("salary"), (Object)2));
            UpdateAllQueryAdvancedJunitTest.updateAllQueryInternal(updateQuery);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFirstNamePrefixBLADoubleSalaryForAll() {
        if (UpdateAllQueryAdvancedJunitTest.getServerSession((String)"fieldaccess").getPlatform().isSymfoware()) {
            UpdateAllQueryAdvancedJunitTest.warning((String)"UpdateAllQueryAdvancedJunitTest skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        EntityManager em = UpdateAllQueryAdvancedJunitTest.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            ExpressionBuilder builder = new ExpressionBuilder();
            UpdateAllQuery updateQuery = new UpdateAllQuery(Employee.class);
            updateQuery.addUpdate("firstName", Expression.fromLiteral((String)"'BLA'", null).concat((Object)builder.get("firstName")));
            updateQuery.addUpdate("salary", ExpressionMath.multiply((Expression)builder.get("salary"), (Object)2));
            UpdateAllQueryAdvancedJunitTest.updateAllQueryInternal(updateQuery);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFirstNamePrefixBLADoubleSalaryForSalary() {
        if (UpdateAllQueryAdvancedJunitTest.getServerSession((String)"fieldaccess").getPlatform().isSymfoware()) {
            UpdateAllQueryAdvancedJunitTest.warning((String)"UpdateAllQueryAdvancedJunitTest skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        EntityManager em = UpdateAllQueryAdvancedJunitTest.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression selectionExpression = builder.get("salary").lessThan(20000);
            UpdateAllQuery updateQuery = new UpdateAllQuery(Employee.class, selectionExpression);
            updateQuery.addUpdate("firstName", Expression.fromLiteral((String)"'BLA'", null).concat((Object)builder.get("firstName")));
            updateQuery.addUpdate("salary", ExpressionMath.multiply((Expression)builder.get("salary"), (Object)2));
            UpdateAllQueryAdvancedJunitTest.updateAllQueryInternal(updateQuery);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFirstNamePrefixBLADoubleSalaryForSalaryForFirstName() {
        if (UpdateAllQueryAdvancedJunitTest.getServerSession((String)"fieldaccess").getPlatform().isSymfoware()) {
            UpdateAllQueryAdvancedJunitTest.warning((String)"UpdateAllQueryAdvancedJunitTest skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        EntityManager em = UpdateAllQueryAdvancedJunitTest.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression selectionExpression = builder.get("salary").lessThan(20000).and(builder.get("firstName").like("J%"));
            UpdateAllQuery updateQuery = new UpdateAllQuery(Employee.class, selectionExpression);
            updateQuery.addUpdate("firstName", Expression.fromLiteral((String)"'BLA'", null).concat((Object)builder.get("firstName")));
            updateQuery.addUpdate("salary", ExpressionMath.multiply((Expression)builder.get("salary"), (Object)2));
            UpdateAllQueryAdvancedJunitTest.updateAllQueryInternal(updateQuery);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAssignManagerName() {
        if (UpdateAllQueryAdvancedJunitTest.getServerSession((String)"fieldaccess").getPlatform().isSymfoware()) {
            UpdateAllQueryAdvancedJunitTest.warning((String)"UpdateAllQueryAdvancedJunitTest skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        EntityManager em = UpdateAllQueryAdvancedJunitTest.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression selectionExpression = builder.get("manager").notNull();
            UpdateAllQuery updateQuery = new UpdateAllQuery(Employee.class, selectionExpression);
            updateQuery.addUpdate("firstName", builder.get("manager").get("firstName"));
            UpdateAllQueryAdvancedJunitTest.updateAllQueryInternal(updateQuery);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    public void testAssignNullToAddress() {
        if (UpdateAllQueryAdvancedJunitTest.getServerSession((String)"fieldaccess").getPlatform().isSymfoware()) {
            UpdateAllQueryAdvancedJunitTest.warning((String)"UpdateAllQueryAdvancedJunitTest skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        EntityManager em = UpdateAllQueryAdvancedJunitTest.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            UpdateAllQuery updateQuery = new UpdateAllQuery(Employee.class);
            updateQuery.addUpdate("address", null);
            UpdateAllQueryAdvancedJunitTest.updateAllQueryInternal(updateQuery);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAssignObjectToAddress() {
        if (UpdateAllQueryAdvancedJunitTest.getServerSession((String)"fieldaccess").getPlatform().isSymfoware()) {
            UpdateAllQueryAdvancedJunitTest.warning((String)"UpdateAllQueryAdvancedJunitTest skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        EntityManager em = UpdateAllQueryAdvancedJunitTest.createEntityManager((String)"fieldaccess");
        if (UpdateAllQueryAdvancedJunitTest.isOnServer()) {
            UpdateAllQueryAdvancedJunitTest.warning((String)"Warning: The test uses UnitOfWork directly, not JPA, so will not work correctly with JTA. For details, see https://bugs.eclipse.org/bugs/show_bug.cgi?id=305040");
            return;
        }
        this.beginTransaction(em);
        try {
            Address address = new Address();
            address.setCountry("Canada");
            address.setProvince("Ontario");
            address.setCity("Ottawa");
            address.setStreet("O'Connor");
            UnitOfWork uow = UpdateAllQueryAdvancedJunitTest.acquireUnitOfWork();
            uow.registerNewObject((Object)address);
            uow.commit();
            UpdateAllQuery updateQuery = new UpdateAllQuery(Employee.class);
            updateQuery.addUpdate("address", (Object)address);
            UpdateAllQueryAdvancedJunitTest.updateAllQueryInternal(updateQuery);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAssignExpressionToAddress() {
        if (UpdateAllQueryAdvancedJunitTest.getServerSession((String)"fieldaccess").getPlatform().isSymfoware()) {
            UpdateAllQueryAdvancedJunitTest.warning((String)"UpdateAllQueryAdvancedJunitTest skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        EntityManager em = UpdateAllQueryAdvancedJunitTest.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression selectionExpression = builder.get("manager").notNull();
            UpdateAllQuery updateQuery = new UpdateAllQuery(Employee.class, selectionExpression);
            updateQuery.addUpdate("address", builder.get("manager").get("address"));
            UpdateAllQueryAdvancedJunitTest.updateAllQueryInternal(updateQuery);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAggregate() {
        if (UpdateAllQueryAdvancedJunitTest.getServerSession((String)"fieldaccess").getPlatform().isSymfoware()) {
            UpdateAllQueryAdvancedJunitTest.warning((String)"UpdateAllQueryAdvancedJunitTest skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        EntityManager em = UpdateAllQueryAdvancedJunitTest.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression selectionExpression = builder.get("manager").notNull();
            UpdateAllQuery updateQuery = new UpdateAllQuery(Employee.class, selectionExpression);
            updateQuery.addUpdate(builder.get("period").get("startDate"), builder.get("period").get("endDate"));
            updateQuery.addUpdate(builder.get("period").get("endDate"), builder.get("period").get("startDate"));
            UpdateAllQueryAdvancedJunitTest.updateAllQueryInternal(updateQuery);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    protected static void updateAllQueryInternal(Class referenceClass, HashMap updateClauses, Expression selectionExpression) {
        String errorMsg = UpdateAllQueryTestHelper.execute((Session)UpdateAllQueryAdvancedJunitTest.getDbSession(), (Class)referenceClass, (HashMap)updateClauses, (Expression)selectionExpression);
        if (errorMsg != null) {
            UpdateAllQueryAdvancedJunitTest.fail((String)errorMsg);
        }
    }

    protected static void updateAllQueryInternal(UpdateAllQuery uq) {
        String errorMsg = UpdateAllQueryTestHelper.execute((Session)UpdateAllQueryAdvancedJunitTest.getDbSession(), (UpdateAllQuery)uq);
        if (errorMsg != null) {
            UpdateAllQueryAdvancedJunitTest.fail((String)errorMsg);
        }
    }

    protected static boolean compare() {
        for (int i = 0; i < classes.length; ++i) {
            if (UpdateAllQueryAdvancedJunitTest.compare(i)) continue;
            return false;
        }
        return true;
    }

    protected static boolean compare(int i) {
        if (objectVectors[i] == null) {
            return false;
        }
        Vector currentVector = UpdateAllQueryAdvancedJunitTest.getDbSession().readAllObjects(classes[i]);
        if (currentVector.size() != objectVectors[i].size()) {
            return false;
        }
        ClassDescriptor descriptor = UpdateAllQueryAdvancedJunitTest.getDbSession().getDescriptor(classes[i]);
        for (int j = 0; j < currentVector.size(); ++j) {
            Object obj1 = objectVectors[i].elementAt(j);
            Object obj2 = currentVector.elementAt(j);
            if (descriptor.getObjectBuilder().compareObjects(obj1, obj2, (AbstractSession)UpdateAllQueryAdvancedJunitTest.getDbSession())) continue;
            return false;
        }
        return true;
    }
}

