/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.internal.jpa.deployment.ArchiveFactoryImpl;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.jpa.ArchiveFactory;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.junit.Assert;

public class PersistenceUnitProcessorTest
extends JUnitTestCase {
    public static Test suite() {
        return new TestSuite(PersistenceUnitProcessorTest.class);
    }

    public static void testComputePURootURLForZipFile() throws Exception {
        URLStreamHandler dummyZipHandler = new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL u) throws IOException {
                return null;
            }
        };
        Assert.assertEquals((Object)"file:/C:/Oracle/Middleware/Oracle_Home/wlserver/samples/domains/mydomain/servers/myserver/tmp/_WL_user/eclipselink-advanced-model/y986my/eclipselink-advanced-model_ejb.jar", (Object)PersistenceUnitProcessor.computePURootURL((URL)new URL("zip", "", -1, "/C:/Oracle/Middleware/Oracle_Home/wlserver/samples/domains/mydomain/servers/myserver/tmp/_WL_user/eclipselink-advanced-model/y986my/eclipselink-advanced-model_ejb.jar!/META-INF/persistence.xml", dummyZipHandler), (String)"META-INF/persistence.xml").toString());
        Assert.assertEquals((Object)"file:/C:/Program Files/Middleware/Oracle_Home/wlserver/samples/domains/mydomain/servers/myserver/tmp/_WL_user/eclipselink-advanced-model/y986my/eclipselink-advanced-model_ejb.jar", (Object)PersistenceUnitProcessor.computePURootURL((URL)new URL("zip", "", -1, "/C:/Program Files/Middleware/Oracle_Home/wlserver/samples/domains/mydomain/servers/myserver/tmp/_WL_user/eclipselink-advanced-model/y986my/eclipselink-advanced-model_ejb.jar!/META-INF/persistence.xml", dummyZipHandler), (String)"META-INF/persistence.xml").toString());
        Assert.assertEquals((Object)"file:/C:/Program.Files/Middleware/Oracle_Home/wlserver/samples/domains/mydomain/servers/myserver/tmp/_WL_user/eclipselink-advanced-model/y986my/eclipselink-advanced-model_ejb.jar", (Object)PersistenceUnitProcessor.computePURootURL((URL)new URL("zip", "", -1, "/C:/Program.Files/Middleware/Oracle_Home/wlserver/samples/domains/mydomain/servers/myserver/tmp/_WL_user/eclipselink-advanced-model/y986my/eclipselink-advanced-model_ejb.jar!/META-INF/persistence.xml", dummyZipHandler), (String)"META-INF/persistence.xml").toString());
    }

    public void testGetArchiveFactory() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("eclipselink.archive.factory", AF1.class.getName());
        ArchiveFactory af = PersistenceUnitProcessor.getArchiveFactory((ClassLoader)PersistenceUnitProcessorTest.class.getClassLoader(), props);
        Assert.assertTrue((String)"Property should be used", (boolean)(af instanceof AF1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetArchiveFactoryOverride() {
        Object emf = null;
        String orig = System.getProperty("eclipselink.archive.factory", "--noval--");
        try {
            System.setProperty("eclipselink.archive.factory", AF2.class.getName());
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("eclipselink.archive.factory", AF1.class.getName());
            ArchiveFactory af = PersistenceUnitProcessor.getArchiveFactory((ClassLoader)PersistenceUnitProcessorTest.class.getClassLoader(), props);
            Assert.assertTrue((String)"System property should be used", (boolean)(af instanceof AF2));
        }
        finally {
            if ("--noval--".equals(orig)) {
                System.clearProperty("eclipselink.archive.factory");
            } else {
                System.setProperty("eclipselink.archive.factory", orig);
            }
        }
    }

    public static class AF2
    extends ArchiveFactoryImpl {
    }

    public static class AF1
    extends ArchiveFactoryImpl {
    }
}

