/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.ModelExamples;
import org.eclipse.persistence.testing.models.jpa.advanced.PhoneNumber;
import org.eclipse.persistence.testing.tests.jpa.CMP3TestModel;
import org.eclipse.persistence.testing.tests.jpa.EntityContainerTestBase;

public class EMCascadingModifyAndMergeTest
extends EntityContainerTestBase {
    public Integer[] empIDs = new Integer[2];
    Employee employee;

    public EMCascadingModifyAndMergeTest() {
        this.setDescription("Test cascading modify and merge in EntityManager");
    }

    @Override
    public void setup() {
        super.setup();
        this.employee = ModelExamples.employeeExample1();
        this.employee.addPhoneNumber(ModelExamples.phoneExample3());
        try {
            this.beginTransaction();
            this.getEntityManager().persist((Object)this.employee);
            this.commitTransaction();
        }
        catch (Exception ex) {
            this.rollbackTransaction();
            ex.printStackTrace();
            throw new TestErrorException("Exception thrown durring persist and flush" + ex);
        }
        this.empIDs[0] = this.employee.getId();
    }

    public void test() {
        this.employee.setFirstName("Ivy");
        PhoneNumber phone = (PhoneNumber)this.employee.getPhoneNumbers().iterator().next();
        phone.setAreaCode("519");
        phone.setNumber("9876543");
        try {
            CMP3TestModel.createEntityManager();
            this.beginTransaction();
            Employee emp = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[0]);
            emp.setFirstName("Tobin");
            PhoneNumber phon = (PhoneNumber)emp.getPhoneNumbers().iterator().next();
            phon.setAreaCode("416");
            phon.setNumber("7654321");
            this.getEntityManager().merge((Object)this.employee);
            this.commitTransaction();
        }
        catch (Exception ex) {
            this.rollbackTransaction();
            ex.printStackTrace();
            throw new TestErrorException("Exception thrown durring persist and flush" + ex);
        }
    }

    public void verify() {
        this.employee = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[0]);
        if (!this.employee.getFirstName().equals("Ivy")) {
            throw new TestErrorException("Employee ID :" + this.empIDs[0] + " first name was not merged");
        }
        if (this.employee.getPhoneNumbers().size() > 1) {
            throw new TestErrorException("Employee ID :" + this.empIDs[0] + " phone number added after merge");
        }
        PhoneNumber phone = (PhoneNumber)this.employee.getPhoneNumbers().iterator().next();
        if (!phone.getAreaCode().equals("519")) {
            throw new TestErrorException("Employee ID :" + this.empIDs[0] + " phone number areacode was not merged");
        }
        if (!phone.getNumber().equals("9876543")) {
            throw new TestErrorException("Employee ID :" + this.empIDs[0] + " phone number was not merged");
        }
        ((JpaEntityManager)this.getEntityManager()).getActiveSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.employee = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[0]);
        if (!this.employee.getFirstName().equals("Ivy")) {
            throw new TestErrorException("Employee ID :" + this.empIDs[0] + " first name was not merged");
        }
        if (this.employee.getPhoneNumbers().size() > 1) {
            throw new TestErrorException("Employee ID :" + this.empIDs[0] + " phone number added after merge");
        }
        phone = (PhoneNumber)this.employee.getPhoneNumbers().iterator().next();
        if (!phone.getAreaCode().equals("519")) {
            throw new TestErrorException("Employee ID :" + this.empIDs[0] + " phone number areacode was not merged");
        }
        if (!phone.getNumber().equals("9876543")) {
            throw new TestErrorException("Employee ID :" + this.empIDs[0] + " phone number was not merged");
        }
    }
}

