/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.localization;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class EclipseLinkLocalization {
    private static final String NO_TRANSLATION_MESSAGE = ResourceBundle.getBundle("org.eclipse.persistence.internal.localization.i18n.EclipseLinkLocalizationResource", Locale.getDefault()).getString("NoTranslationForThisLocale");

    public static String buildMessage(String localizationClassName, String key, Object[] arguments) {
        return EclipseLinkLocalization.buildMessage(localizationClassName, key, arguments, true);
    }

    public static String buildMessage(String localizationClassName, String key, Object[] arguments, boolean translate) {
        String message;
        block7: {
            message = key;
            ResourceBundle bundle = null;
            if (arguments != null) {
                int i = 0;
                while (i < arguments.length) {
                    if (arguments[i] == null) {
                        arguments[i] = "null";
                    }
                    ++i;
                }
            }
            try {
                bundle = ResourceBundle.getBundle("org.eclipse.persistence.internal.localization.i18n." + localizationClassName + "Resource", Locale.getDefault());
                message = bundle.getString(key);
            }
            catch (MissingResourceException mre) {
                if (!translate) break block7;
                if (arguments == null) {
                    return String.valueOf(message) + NO_TRANSLATION_MESSAGE;
                }
                return String.valueOf(MessageFormat.format(message, arguments)) + NO_TRANSLATION_MESSAGE;
            }
        }
        if (arguments == null) {
            return message;
        }
        return MessageFormat.format(message, arguments);
    }
}

