/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.remoteserviceadmin;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.Activator;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class EndpointDescriptionParser {
    private static List<String> multiValueTypes = Arrays.asList("String", "Long", "long", "Double", "double", "float", "Float", "int", "Integer", "byte", "Byte", "char", "Character", "boolean", "Boolean", "short", "Short");
    private static final String ENDPOINT_DESCRIPTIONS = "endpoint-descriptions";
    private static final String ENDPOINT_DESCRIPTION = "endpoint-description";
    private static final String ENDPOINT_PROPERTY = "property";
    private static final String ENDPOINT_PROPERTY_NAME = "name";
    private static final String ENDPOINT_PROPERTY_VALUE = "value";
    private static final String ENDPOINT_PROPERTY_VALUETYPE = "value-type";
    private static final String ENDPOINT_PROPERTY_ARRAY = "array";
    private static final String ENDPOINT_PROPERTY_LIST = "list";
    private static final String ENDPOINT_PROPERTY_SET = "set";
    private static final String ENDPOINT_PROPERTY_XML = "xml";
    public static String[] noAttributes = new String[0];
    private XMLReader xmlReader;
    private List<EndpointDescription> endpointDescriptions;

    SAXParser getParser() throws ParserConfigurationException, SAXException {
        Activator a = Activator.getDefault();
        if (a == null) {
            return null;
        }
        SAXParserFactory factory = a.getSAXParserFactory();
        if (factory == null) {
            throw new SAXException("Unable to acquire sax parser");
        }
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            factory.setFeature("http://xml.org/sax/features/string-interning", true);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        SAXParser theParser = factory.newSAXParser();
        if (theParser == null) {
            throw new SAXException("Unable to create sax parser");
        }
        this.xmlReader = theParser.getXMLReader();
        return theParser;
    }

    private Object createValue(String valueType, String value) {
        if (value == null) {
            return null;
        }
        if (valueType.equals("String")) {
            return value;
        }
        if (valueType.equals("long") || valueType.equals("Long")) {
            return Long.valueOf(value);
        }
        if (valueType.equals("double") || valueType.equals("Double")) {
            return Double.valueOf(value);
        }
        if (valueType.equals("float") || valueType.equals("Float")) {
            return Float.valueOf(value);
        }
        if (valueType.equals("int") || valueType.equals("Integer")) {
            return Integer.valueOf(value);
        }
        if (valueType.equals("byte") || valueType.equals("Byte")) {
            return Byte.valueOf(value);
        }
        if (valueType.equals("char") || valueType.equals("Character")) {
            char[] chars = new char[1];
            value.getChars(0, 1, chars, 0);
            return Character.valueOf(chars[0]);
        }
        if (valueType.equals("boolean") || valueType.equals("Boolean")) {
            return Boolean.valueOf(value);
        }
        if (valueType.equals("short") || valueType.equals("Short")) {
            return Short.valueOf(value);
        }
        return null;
    }

    public synchronized void parse(InputStream input) throws IOException {
        try {
            try {
                this.getParser();
                EndpointDescriptionsHandler endpointDescriptionsHandler = new EndpointDescriptionsHandler();
                this.xmlReader.setContentHandler(new EndpointDescriptionDocHandler(ENDPOINT_DESCRIPTIONS, endpointDescriptionsHandler));
                this.xmlReader.parse(new InputSource(input));
                this.endpointDescriptions = endpointDescriptionsHandler.getEndpointDescriptions();
            }
            catch (SAXException e) {
                throw new IOException(e.getMessage());
            }
            catch (ParserConfigurationException e) {
                throw new IOException(e.getMessage());
            }
        }
        finally {
            input.close();
        }
    }

    public static String makeSimpleName(String localName, String qualifiedName) {
        if (localName != null && localName.length() > 0) {
            return localName;
        }
        int nameSpaceIndex = qualifiedName.indexOf(":");
        return nameSpaceIndex == -1 ? qualifiedName : qualifiedName.substring(nameSpaceIndex + 1);
    }

    public void unexpectedElement(AbstractHandler handler, String element, Attributes attributes) {
    }

    public void unexpectedCharacterData(AbstractHandler handler, String cdata) {
    }

    public void unexpectedAttribute(String element, String attribute, String value) {
    }

    static int indexOf(String[] array, String value) {
        int i = 0;
        while (i < array.length) {
            if (value == null ? array[i] == null : value.equals(array[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void checkRequiredAttribute(String element, String name, Object value) {
    }

    public void duplicateElement(AbstractHandler handler, String element, Attributes attributes) {
        new IgnoringHandler(handler);
    }

    public List<EndpointDescription> getEndpointDescriptions() {
        return this.endpointDescriptions;
    }

    abstract class AbstractHandler
    extends DefaultHandler {
        protected ContentHandler parentHandler = null;
        protected String elementHandled = null;
        protected StringBuffer characters = null;

        public AbstractHandler() {
        }

        public AbstractHandler(ContentHandler parentHandler) {
            this.parentHandler = parentHandler;
            EndpointDescriptionParser.this.xmlReader.setContentHandler(this);
        }

        public AbstractHandler(ContentHandler parentHandler, String elementHandled) {
            this.parentHandler = parentHandler;
            EndpointDescriptionParser.this.xmlReader.setContentHandler(this);
            this.elementHandled = elementHandled;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.finishCharacters();
            String name = EndpointDescriptionParser.makeSimpleName(localName, qName);
            this.startElement(name, attributes);
        }

        public abstract void startElement(String var1, Attributes var2) throws SAXException;

        public void invalidElement(String name, Attributes attributes) {
            EndpointDescriptionParser.this.unexpectedElement(this, name, attributes);
            new IgnoringHandler(this);
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) {
            this.finishCharacters();
            this.finished();
            EndpointDescriptionParser.this.xmlReader.setContentHandler(this.parentHandler);
        }

        protected void noSubElements(String name, Attributes attributes) {
            EndpointDescriptionParser.this.unexpectedElement(this, name, attributes);
            new IgnoringHandler(this);
        }

        @Override
        public void characters(char[] chars, int start, int length) {
            if (this.characters == null) {
                this.characters = new StringBuffer();
            }
            this.characters.append(chars, start, length);
        }

        private String finishCharacters() {
            if (this.characters == null || this.characters.length() == 0) {
                return null;
            }
            if (this.allWhiteSpace(this.characters)) {
                this.characters.setLength(0);
                return null;
            }
            try {
                String trimmedChars = this.characters.toString().trim();
                if (trimmedChars.length() == 0) {
                    System.err.println("Unexpected non-whitespace characters: " + trimmedChars);
                    return null;
                }
                this.processCharacters(trimmedChars);
                String string = trimmedChars;
                return string;
            }
            finally {
                this.characters.setLength(0);
            }
        }

        protected void processCharacters(String data) {
            if (data.length() > 0) {
                EndpointDescriptionParser.this.unexpectedCharacterData(this, data);
            }
        }

        private boolean allWhiteSpace(StringBuffer sb) {
            int length = sb.length();
            int i = 0;
            while (i < length) {
                if (!Character.isWhitespace(sb.charAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        protected void finished() {
        }

        public String getName() {
            return this.elementHandled != null ? this.elementHandled : "NoName";
        }

        protected String[] parseRequiredAttributes(Attributes attributes, String[] required) {
            return this.parseAttributes(attributes, required, noAttributes);
        }

        protected String parseOptionalAttribute(Attributes attributes, String name) {
            return this.parseAttributes(attributes, noAttributes, new String[]{name})[0];
        }

        protected String[] parseAttributes(Attributes attributes, String[] required, String[] optional) {
            String[] result = new String[required.length + optional.length];
            int i = 0;
            while (i < attributes.getLength()) {
                String name = attributes.getLocalName(i);
                String value = attributes.getValue(i).trim();
                int j = EndpointDescriptionParser.indexOf(required, name);
                if (j >= 0) {
                    result[j] = value;
                } else {
                    j = EndpointDescriptionParser.indexOf(optional, name);
                    if (j >= 0) {
                        result[required.length + j] = value;
                    } else {
                        EndpointDescriptionParser.this.unexpectedAttribute(this.elementHandled, name, value);
                    }
                }
                ++i;
            }
            i = 0;
            while (i < required.length) {
                EndpointDescriptionParser.this.checkRequiredAttribute(this.elementHandled, required[i], result[i]);
                ++i;
            }
            return result;
        }
    }

    class ArrayMultiValueHandler
    extends MultiValueHandler {
        private List<Object> values;

        public ArrayMultiValueHandler(ContentHandler parentHandler, String elementHandled, String valueType) {
            super(parentHandler, elementHandled, valueType);
            this.values = new ArrayList<Object>();
        }

        protected Object[] createEmptyArrayOfType() {
            if (this.valueType.equals("String")) {
                return new String[0];
            }
            if (this.valueType.equals("long") || this.valueType.equals("Long")) {
                return new Long[0];
            }
            if (this.valueType.equals("double") || this.valueType.equals("Double")) {
                return new Double[0];
            }
            if (this.valueType.equals("float") || this.valueType.equals("Float")) {
                return new Double[0];
            }
            if (this.valueType.equals("int") || this.valueType.equals("Integer")) {
                return new Integer[0];
            }
            if (this.valueType.equals("byte") || this.valueType.equals("Byte")) {
                return new Byte[0];
            }
            if (this.valueType.equals("char") || this.valueType.equals("Character")) {
                return new Character[0];
            }
            if (this.valueType.equals("boolean") || this.valueType.equals("Boolean")) {
                return new Boolean[0];
            }
            if (this.valueType.equals("short") || this.valueType.equals("Short")) {
                return new Short[0];
            }
            return null;
        }

        @Override
        public Object getValues() {
            return this.values.toArray(this.createEmptyArrayOfType());
        }

        @Override
        protected void addValue(Object value) {
            this.values.add(value);
        }
    }

    class DocHandler
    extends AbstractHandler {
        RootHandler rootHandler;

        public DocHandler(String rootName, RootHandler rootHandler) {
            super(null, rootName);
            this.rootHandler = rootHandler;
        }

        @Override
        public void startElement(String name, Attributes attributes) {
            if (name.equals(this.elementHandled)) {
                this.rootHandler.initialize(this, name, attributes);
                EndpointDescriptionParser.this.xmlReader.setContentHandler(this.rootHandler);
            } else {
                this.noSubElements(name, attributes);
            }
        }
    }

    public class EndpointDescription {
        private Map<String, Object> properties;

        public EndpointDescription(Map<String, Object> properties) {
            this.properties = properties;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("EndpointDescription [properties=");
            builder.append(this.properties);
            builder.append("]");
            return builder.toString();
        }
    }

    class EndpointDescriptionDocHandler
    extends DocHandler {
        public EndpointDescriptionDocHandler(String rootName, RootHandler rootHandler) {
            super(rootName, rootHandler);
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }
    }

    class EndpointDescriptionHandler
    extends AbstractHandler {
        private Map<String, Object> properties;
        private List<EndpointDescription> descriptions;

        public EndpointDescriptionHandler(ContentHandler parentHandler, Attributes attributes, List<EndpointDescription> descriptions) {
            super(parentHandler, EndpointDescriptionParser.ENDPOINT_DESCRIPTION);
            this.properties = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
            this.descriptions = descriptions;
        }

        @Override
        public void startElement(String name, Attributes attributes) throws SAXException {
            if (EndpointDescriptionParser.ENDPOINT_PROPERTY.equals(name)) {
                new EndpointPropertyHandler(this, attributes, this.properties);
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) {
            if (this.elementHandled.equals(localName)) {
                this.descriptions.add(new EndpointDescription(this.properties));
                super.endElement(namespaceURI, localName, qName);
            }
        }
    }

    class EndpointDescriptionsHandler
    extends RootHandler {
        private List<EndpointDescription> endpointDescriptions;

        EndpointDescriptionsHandler() {
            this.endpointDescriptions = new ArrayList<EndpointDescription>();
        }

        @Override
        protected void handleRootAttributes(Attributes attributes) {
        }

        @Override
        public void startElement(String name, Attributes attributes) throws SAXException {
            if (EndpointDescriptionParser.ENDPOINT_DESCRIPTION.equals(name)) {
                new EndpointDescriptionHandler(this, attributes, this.endpointDescriptions);
            } else {
                this.invalidElement(name, attributes);
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) {
            if (this.elementHandled.equals(localName)) {
                super.endElement(namespaceURI, localName, qName);
            }
        }

        public List<EndpointDescription> getEndpointDescriptions() {
            return this.endpointDescriptions;
        }
    }

    class EndpointPropertyHandler
    extends AbstractHandler {
        private Map<String, Object> properties;
        private String name;
        private String valueType;
        private Object value;
        private MultiValueHandler multiValueHandler;
        private XMLValueHandler xmlValueHandler;

        public EndpointPropertyHandler(ContentHandler parentHandler, Attributes attributes, Map<String, Object> properties) throws SAXException {
            super(parentHandler, EndpointDescriptionParser.ENDPOINT_PROPERTY);
            this.valueType = "String";
            this.name = this.parseRequiredAttributes(attributes, new String[]{EndpointDescriptionParser.ENDPOINT_PROPERTY_NAME})[0];
            String strValue = this.parseOptionalAttribute(attributes, EndpointDescriptionParser.ENDPOINT_PROPERTY_VALUE);
            String vt = this.parseOptionalAttribute(attributes, EndpointDescriptionParser.ENDPOINT_PROPERTY_VALUETYPE);
            if (vt != null) {
                if (!multiValueTypes.contains(vt)) {
                    throw new SAXException("property element valueType=" + vt + " not allowed");
                }
                this.valueType = vt;
            }
            this.properties = properties;
            if (strValue != null) {
                this.value = EndpointDescriptionParser.this.createValue(this.valueType, strValue);
                if (this.isValidProperty(this.name, this.value)) {
                    this.properties.put(this.name, this.value);
                }
            }
        }

        @Override
        public void startElement(String name, Attributes attributes) throws SAXException {
            if (this.value != null) {
                throw new SAXException("property element has both value attribute and sub-element");
            }
            if (EndpointDescriptionParser.ENDPOINT_PROPERTY_ARRAY.equals(name)) {
                if (this.multiValueHandler == null) {
                    this.multiValueHandler = new ArrayMultiValueHandler(this, EndpointDescriptionParser.ENDPOINT_PROPERTY_ARRAY, this.valueType);
                } else {
                    EndpointDescriptionParser.this.duplicateElement(this, name, attributes);
                }
            } else if (EndpointDescriptionParser.ENDPOINT_PROPERTY_LIST.equals(name)) {
                if (this.multiValueHandler == null) {
                    this.multiValueHandler = new ListMultiValueHandler(this, EndpointDescriptionParser.ENDPOINT_PROPERTY_LIST, this.valueType);
                } else {
                    EndpointDescriptionParser.this.duplicateElement(this, name, attributes);
                }
            } else if (EndpointDescriptionParser.ENDPOINT_PROPERTY_SET.equals(name)) {
                if (this.multiValueHandler == null) {
                    this.multiValueHandler = new SetMultiValueHandler(this, EndpointDescriptionParser.ENDPOINT_PROPERTY_SET, this.valueType);
                } else {
                    EndpointDescriptionParser.this.duplicateElement(this, name, attributes);
                }
            } else if (EndpointDescriptionParser.ENDPOINT_PROPERTY_XML.equals(name)) {
                if (this.xmlValueHandler == null) {
                    this.xmlValueHandler = new XMLValueHandler(this);
                } else {
                    EndpointDescriptionParser.this.duplicateElement(this, name, attributes);
                }
            } else {
                this.invalidElement(name, attributes);
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) {
            if (this.elementHandled.equals(localName)) {
                if (this.multiValueHandler != null) {
                    this.properties.put(this.name, this.multiValueHandler.getValues());
                    this.multiValueHandler = null;
                } else if (this.xmlValueHandler != null) {
                    this.properties.put(this.name, this.xmlValueHandler.getXML());
                    this.xmlValueHandler = null;
                }
                super.endElement(namespaceURI, localName, qName);
            }
        }

        private boolean isValidProperty(String name, Object value) {
            return name != null && value != null;
        }
    }

    class IgnoringHandler
    extends AbstractHandler {
        public IgnoringHandler(AbstractHandler parent) {
            super(parent);
            this.elementHandled = "IgnoringAll";
        }

        @Override
        public void startElement(String name, Attributes attributes) {
            this.noSubElements(name, attributes);
        }
    }

    class ListMultiValueHandler
    extends MultiValueHandler {
        private List<Object> values;

        public ListMultiValueHandler(ContentHandler parentHandler, String elementHandled, String valueType) {
            super(parentHandler, elementHandled, valueType);
            this.values = new ArrayList<Object>();
        }

        @Override
        public Object getValues() {
            return this.values;
        }

        @Override
        protected void addValue(Object value) {
            this.values.add(value);
        }
    }

    abstract class MultiValueHandler
    extends AbstractHandler {
        protected String valueType;

        public MultiValueHandler(ContentHandler parentHandler, String elementHandled, String valueType) {
            super(parentHandler, elementHandled);
            this.valueType = valueType;
        }

        @Override
        public void startElement(String name, Attributes attributes) throws SAXException {
            if (EndpointDescriptionParser.ENDPOINT_PROPERTY_VALUE.equals(name)) {
                this.characters = new StringBuffer();
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) {
            if (EndpointDescriptionParser.ENDPOINT_PROPERTY_VALUE.equals(localName)) {
                Object value = EndpointDescriptionParser.this.createValue(this.valueType, this.processValue(this.characters == null ? null : this.characters.toString()));
                if (value != null) {
                    this.addValue(value);
                }
                this.characters = null;
            } else if (this.elementHandled.equals(localName)) {
                super.endElement(namespaceURI, localName, qName);
            }
        }

        private String processValue(String characters) {
            if (characters == null || characters.length() == 0) {
                return null;
            }
            if (this.valueType.equals("String")) {
                return characters;
            }
            return characters.trim();
        }

        protected abstract void addValue(Object var1);

        public abstract Object getValues();
    }

    abstract class RootHandler
    extends AbstractHandler {
        public void initialize(DocHandler document, String rootName, Attributes attributes) {
            this.parentHandler = document;
            this.elementHandled = rootName;
            this.handleRootAttributes(attributes);
        }

        protected abstract void handleRootAttributes(Attributes var1);
    }

    class SetMultiValueHandler
    extends MultiValueHandler {
        private Set<Object> values;

        public SetMultiValueHandler(ContentHandler parentHandler, String elementHandled, String valueType) {
            super(parentHandler, elementHandled, valueType);
            this.values = new HashSet<Object>();
        }

        @Override
        public Object getValues() {
            return this.values;
        }

        @Override
        protected void addValue(Object value) {
            this.values.add(value);
        }
    }

    class XMLValueHandler
    extends AbstractHandler {
        private Map<String, String> nsPrefixMap;
        private StringBuffer buf;

        public XMLValueHandler(ContentHandler parentHandler) {
            super(parentHandler, EndpointDescriptionParser.ENDPOINT_PROPERTY_XML);
            this.nsPrefixMap = new HashMap<String, String>();
            this.buf = new StringBuffer();
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.nsPrefixMap.put(uri, prefix);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.buf.append("<").append(qName);
            Iterator<String> i = this.nsPrefixMap.keySet().iterator();
            while (i.hasNext()) {
                String nsURI = i.next();
                String prefix = this.nsPrefixMap.get(nsURI);
                i.remove();
                if (nsURI == null) continue;
                this.buf.append(" xmlns");
                if (prefix != null) {
                    this.buf.append(":").append(prefix);
                }
                this.buf.append("=\"").append(nsURI).append("\"");
            }
            int i2 = 0;
            while (i2 < attributes.getLength()) {
                this.buf.append(" ");
                this.buf.append(attributes.getQName(i2)).append("=\"").append(attributes.getValue(i2)).append("\"");
                ++i2;
            }
            this.buf.append(">");
            this.characters = new StringBuffer();
        }

        @Override
        public void startElement(String name, Attributes attributes) throws SAXException {
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) {
            if (this.elementHandled.equals(localName)) {
                super.endElement(namespaceURI, localName, qName);
            } else {
                if (this.characters != null) {
                    this.buf.append(this.characters);
                }
                this.buf.append("</").append(qName).append(">");
                this.characters = null;
            }
        }

        public String getXML() {
            return this.buf.toString();
        }
    }
}

