/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.example.collab.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ecf.example.collab.share.EclipseCollabSharedObject;
import org.eclipse.ecf.internal.example.collab.ClientEntry;
import org.eclipse.ecf.internal.example.collab.CollabClient;
import org.eclipse.ecf.internal.example.collab.Messages;
import org.eclipse.ecf.internal.example.collab.ui.JoinGroupWizard;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class JoinGroupWizardAction
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate {
    private static final String CONNECT_PROJECT_MENU_TEXT = Messages.JoinGroupWizardAction_PROJECT_MENU_CONNECT_TEXT;
    private static final String DISCONNECT_PROJECT_MENU_TEXT = Messages.JoinGroupWizardAction_PROJECT_MENU_DISCONNECT_TEXT;
    private IResource resource;
    private boolean connected = false;
    private IWorkbenchPart targetPart;
    private IWorkbenchWindow window;
    private String connectID = null;

    public JoinGroupWizardAction() {
    }

    public JoinGroupWizardAction(String connectID) {
        this();
        this.connectID = connectID;
    }

    private ClientEntry isConnected(IResource res) {
        if (res == null) {
            return null;
        }
        CollabClient client = CollabClient.getDefault();
        ClientEntry entry = client.isConnected(res, "ecf.generic.client");
        return entry;
    }

    private void setAction(IAction action, IResource resource) {
        if (this.isConnected(resource) != null) {
            action.setText(DISCONNECT_PROJECT_MENU_TEXT);
            this.connected = true;
        } else {
            action.setText(CONNECT_PROJECT_MENU_TEXT);
            this.connected = false;
        }
        action.setEnabled(resource == null ? false : resource.isAccessible());
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void run(IAction action) {
        if (!this.connected) {
            JoinGroupWizard wizard = new JoinGroupWizard(this.resource, PlatformUI.getWorkbench(), this.connectID);
            Shell shell = null;
            shell = this.targetPart == null ? (this.window == null ? null : this.window.getShell()) : this.targetPart.getSite().getShell();
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            dialog.open();
        } else {
            ClientEntry client = this.isConnected(this.resource);
            if (client == null) {
                this.connected = false;
                action.setText(CONNECT_PROJECT_MENU_TEXT);
            } else {
                EclipseCollabSharedObject collab = client.getSharedObject();
                if (collab != null) {
                    collab.chatGUIDestroy();
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection iss;
        Object obj;
        this.resource = selection instanceof IStructuredSelection ? ((obj = (iss = (IStructuredSelection)selection).getFirstElement()) instanceof IProject ? (IProject)obj : (obj instanceof IAdaptable ? (IProject)((IAdaptable)obj).getAdapter(IProject.class) : ResourcesPlugin.getWorkspace().getRoot())) : ResourcesPlugin.getWorkspace().getRoot();
        this.setAction(action, this.resource);
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }
}

